/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class JavaLaunchShortcut
implements ILaunchShortcut2 {
    static /* synthetic */ Class class$0;

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected abstract ILaunchConfiguration createConfiguration(IType var1);

    protected abstract IType[] findTypes(Object[] var1, IRunnableContext var2) throws InterruptedException, CoreException;

    protected abstract String getTypeSelectionTitle();

    protected abstract String getEditorEmptyMessage();

    protected abstract String getSelectionEmptyMessage();

    private void searchAndLaunch(Object[] scope, String mode, String selectTitle, String emptyMessage) {
        IType[] types = null;
        try {
            types = this.findTypes(scope, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_0, (String)e.getMessage());
            return;
        }
        IType type = null;
        if (types.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_1, (String)emptyMessage);
        } else {
            type = types.length > 1 ? this.chooseType(types, selectTitle) : types[0];
        }
        if (type != null) {
            this.launch(type, mode);
        }
    }

    protected IType chooseType(IType[] types, String title) {
        DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(JDIDebugUIPlugin.getShell(), types, title);
        if (mmsd.open() == 0) {
            return (IType)mmsd.getResult()[0];
        }
        return null;
    }

    private void launch(IType type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, this.getConfigurationType());
        if (config == null) {
            config = this.createConfiguration(type);
        }
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, ILaunchConfigurationType configType) {
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        if (candidateCount > 1) {
            return this.chooseConfiguration(candidateConfigs);
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getTypeSelectionTitle());
        dialog.setMessage(LauncherMessages.JavaLaunchShortcut_2);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement je;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{je}, mode, this.getTypeSelectionTitle(), this.getEditorEmptyMessage());
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getTypeSelectionTitle(), this.getSelectionEmptyMessage());
        }
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getLaunchableResource((IAdaptable)editorpart.getEditorInput());
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
            return this.getLaunchableResource((IAdaptable)element);
        }
        return null;
    }

    private IResource getLaunchableResource(IAdaptable adaptable) {
        IJavaElement je;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((je = (IJavaElement)adaptable.getAdapter((Class)clazz)) != null) {
            return je.getResource();
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }
}

