/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class OpenTypeAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        try {
            while (itr.hasNext()) {
                Object element = itr.next();
                Object sourceElement = this.resolveSourceElement(element);
                if (sourceElement != null) {
                    this.openInEditor(sourceElement);
                    continue;
                }
                Status status = new Status(1, IJavaDebugUIConstants.PLUGIN_ID, 150, "Source not found", null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }

    protected abstract IDebugElement getDebugElement(IAdaptable var1);

    protected abstract IJavaType getTypeToOpen(IDebugElement var1) throws CoreException;

    protected Object resolveSourceElement(Object e) throws CoreException {
        IType source = null;
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            IJavaType type = this.getTypeToOpen(dbgElement);
            while (type instanceof IJavaArrayType) {
                type = ((IJavaArrayType)type).getComponentType();
            }
            if (type != null && (source = JavaDebugUtils.resolveType((IJavaType)type)) == null) {
                source = OpenTypeAction.findTypeInWorkspace(type.getName());
            }
        }
        return source;
    }

    protected void openInEditor(Object sourceElement) throws CoreException {
        if (this.isHierarchy()) {
            if (sourceElement instanceof IJavaElement) {
                OpenTypeHierarchyUtil.open((IJavaElement)((IJavaElement)sourceElement), (IWorkbenchWindow)this.getWorkbenchWindow());
            } else {
                this.typeHierarchyError();
            }
        } else if (sourceElement instanceof IJavaElement) {
            JavaUI.openInEditor((IJavaElement)((IJavaElement)sourceElement));
        } else {
            this.showErrorMessage(ActionMessages.OpenTypeAction_2);
        }
    }

    protected boolean isHierarchy() {
        return false;
    }

    public static IType findTypeInWorkspace(String typeName) throws CoreException {
        IType[] types = OpenTypeAction.findTypes(typeName, null);
        if (types.length > 0) {
            return types[0];
        }
        return null;
    }

    private static IType[] findTypes(String typeName, IProgressMonitor monitor) throws CoreException {
        final ArrayList results = new ArrayList();
        SearchRequestor collector = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    results.add(element);
                }
            }
        };
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)0, (int)0, (int)0);
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), collector, monitor);
        return results.toArray(new IType[results.size()]);
    }

    protected void typeHierarchyError() {
        this.showErrorMessage(ActionMessages.ObjectActionDelegate_Unable_to_display_type_hierarchy__The_selected_source_element_is_not_contained_in_the_workspace__1);
    }
}

