/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective;

import org.eclipse.wst.ws.internal.datamodel.ElementAdapter;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLAddToFavoritesTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLDetailsTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLImportWSDLToFileSystemTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLImportWSDLToWorkbenchTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLLaunchWebServiceWizardTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLNavigatorNode;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLServiceNode;

public class WSDLNode
extends WSDLNavigatorNode {
    public WSDLNode(TreeElement element, NodeManager nodeManager, int nodeDepth) {
        super(element, nodeManager, nodeDepth, "images/wsdl.gif");
        element.addListener((ElementListener)new ElementAdapter(){

            public void relAdded(RelAddEvent event) {
                String rel = event.getOutBoundRelName();
                if (rel.equals("relWSDLService")) {
                    WSDLServiceNode wsdlServiceNode = new WSDLServiceNode((TreeElement)event.getParentElement(), WSDLNode.this.nodeManager_, WSDLNode.this.nodeDepth_ + 1);
                    WSDLNode.this.addChild(wsdlServiceNode);
                }
            }

            public void relRemoved(RelRemoveEvent event) {
                TreeElement childElement = null;
                if (event.getInBoundRelName().equals("relWSDLService")) {
                    childElement = (TreeElement)event.getInboundElement();
                }
                if (event.getOutBoundRelName().equals("relWSDLService")) {
                    childElement = (TreeElement)event.getOutBoundElement();
                }
                WSDLNode.this.removeChildNode(childElement);
            }
        });
        this.setVisibilityOfChildren(false);
    }

    protected final void initTools() {
        Controller controller = this.nodeManager_.getController();
        WSDLPerspective wsdlPerspective = controller.getWSDLPerspective();
        new WSDLDetailsTool(this.toolManager_, wsdlPerspective.getMessage("ALT_WSDL_DETAILS"));
        new WSDLImportWSDLToWorkbenchTool(this.toolManager_, controller.getMessage("ALT_IMPORT_WSDL_TO_WORKBENCH"));
        new WSDLImportWSDLToFileSystemTool(this.toolManager_, controller.getMessage("ALT_WSDL_IMPORT_TO_FS"));
        new WSDLLaunchWebServiceWizardTool(this.toolManager_, controller.getMessage("ALT_LAUNCH_WEB_SERVICE_WIZARD"));
        new WSDLAddToFavoritesTool(this.toolManager_, wsdlPerspective.getMessage("ALT_ADD_WSDL_TO_FAVORITES"));
    }
}

