/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;

public class CategoryElement
extends RemoteQueriedElement
implements IIUElement {
    private ArrayList ius = new ArrayList(1);
    private IRequiredCapability[] requirements;
    static /* synthetic */ Class class$0;

    public CategoryElement(Object parent, IInstallableUnit iu) {
        super(parent);
        this.ius.add(iu);
    }

    protected String getImageId(Object obj) {
        return "obj/category_obj.gif";
    }

    public String getLabel(Object o) {
        IInstallableUnit iu = this.getIU();
        if (iu != null) {
            return iu.getId();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getIU();
        }
        return super.getAdapter(adapter);
    }

    protected int getDefaultQueryType() {
        return 4;
    }

    public IInstallableUnit getIU() {
        if (this.ius == null || this.ius.isEmpty()) {
            return null;
        }
        return (IInstallableUnit)this.ius.get(0);
    }

    public long getSize() {
        return -1L;
    }

    public boolean shouldShowSize() {
        return false;
    }

    public void computeSize(IProgressMonitor monitor) {
    }

    public boolean shouldShowVersion() {
        return false;
    }

    public void mergeIU(IInstallableUnit iu) {
        this.ius.add(iu);
    }

    public boolean shouldMerge(IInstallableUnit iu) {
        IInstallableUnit myIU = this.getIU();
        if (myIU == null) {
            return false;
        }
        return this.getMergeKey(myIU).equals(this.getMergeKey(iu));
    }

    private String getMergeKey(IInstallableUnit iu) {
        String mergeKey = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.name");
        if (mergeKey == null || mergeKey.length() == 0) {
            mergeKey = iu.getId();
        }
        return mergeKey;
    }

    public IRequiredCapability[] getRequirements() {
        if (this.ius == null || this.ius.isEmpty()) {
            return new IRequiredCapability[0];
        }
        if (this.requirements == null) {
            if (this.ius.size() == 1) {
                this.requirements = this.getIU().getRequiredCapabilities();
            } else {
                ArrayList<IRequiredCapability> capabilities = new ArrayList<IRequiredCapability>();
                Iterator iter = this.ius.iterator();
                while (iter.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)iter.next();
                    capabilities.addAll(Arrays.asList(iu.getRequiredCapabilities()));
                }
                this.requirements = capabilities.toArray(new IRequiredCapability[capabilities.size()]);
            }
        }
        return this.requirements;
    }

    public boolean shouldShowChildren() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryElement)) {
            return false;
        }
        IInstallableUnit myIU = this.getIU();
        IInstallableUnit objIU = ((CategoryElement)obj).getIU();
        if (myIU == null || objIU == null) {
            return false;
        }
        return this.getMergeKey(myIU).equals(this.getMergeKey(objIU));
    }

    public int hashCode() {
        IInstallableUnit iu = this.getIU();
        int result = 1;
        result = 23 * result + (iu == null ? 0 : this.getMergeKey(iu).hashCode());
        return result;
    }

    public String toString() {
        IInstallableUnit iu = this.getIU();
        if (iu == null) {
            return "NULL";
        }
        StringBuffer result = new StringBuffer();
        result.append("Category Element - ");
        result.append(this.getMergeKey(iu));
        result.append(" (merging IUs: ");
        result.append(this.ius.toString());
        result.append(")");
        return result.toString();
    }

    public boolean hasQueryable() {
        if (this.queryable instanceof QueryableMetadataRepositoryManager) {
            return ((QueryableMetadataRepositoryManager)this.queryable).areRepositoriesLoaded();
        }
        return super.hasQueryable();
    }
}

