/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation;

import java.util.Map;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseasabasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASADefaultWrapperImpl;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.ASASQLDataOfflineValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.ASAIdentifierValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLModelValidator;
import org.eclipse.datatools.sqltools.core.modelvalidity.ISQLDataOfflineValidator;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class SybaseASABaseColumnValidator
extends DefaultSQLModelValidator {
    protected boolean validateAttribute(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        SybaseASABaseColumn column = (SybaseASABaseColumn)eObject;
        if (featureId == 1) {
            ValidatorMessage msg;
            IIdentifierValidator identifierValidator = ASAIdentifierValidator.getInstance();
            DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier");
            if (column.getName() == null || column.getName().equals("")) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(1, Integer.toString(1), 1000, Messages.SybaseASABaseColumnValidator_no_column_name, new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseColumn()});
                diagnostics.add((Diagnostic)d);
            } else if (databaseIdentifier != null && (msg = identifierValidator.isValid(SQLUtil.quoteWhenNecessary(column.getName(), databaseIdentifier), 0, databaseIdentifier)) != null && msg.getType() != 0) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(1), 1001, String.valueOf(NLS.bind((String)Messages.SybaseASABaseColumnValidator_for_column, (Object)column.getName())) + msg.getMessage(), new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseColumn()});
                diagnostics.add((Diagnostic)d);
            }
        } else if (featureId == 14) {
            DataType datatype = column.getDataType();
            String defaultValue = column.getDefaultValue();
            SybaseASADefaultWrapperImpl defaultWrapper = new SybaseASADefaultWrapperImpl(defaultValue, column.isIsComputedColumn());
            if (defaultValue != null && !column.isIsComputedColumn()) {
                DatabaseIdentifier databaseIdentifier;
                ASASQLDataOfflineValidator validator = null;
                Object offlineV = sharedParams.get("data_offline_validator");
                validator = offlineV != null && offlineV instanceof ISQLDataOfflineValidator ? (ISQLDataOfflineValidator)offlineV : new ASASQLDataOfflineValidator();
                String msg = validator.validate(datatype, defaultValue);
                if (msg != null) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(14), 1001, String.valueOf(NLS.bind((String)Messages.SybaseASABaseColumnValidator_for_column, (Object)column.getName())) + msg, new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseColumn()});
                    diagnostics.add((Diagnostic)d);
                } else if (!defaultWrapper.isSystemDefault() && !defaultValue.equalsIgnoreCase("identity") && (databaseIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier")) != null && sharedParams.get("validate_default_value_via_db") != null) {
                    SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
                    DataTypeProvider provider = config.getSQLDataService().getDataTypeProvider();
                    ISqlDataValidator dataValidator = SQLToolsFacade.getSQLDataValidator((DatabaseIdentifier)databaseIdentifier);
                    int result = dataValidator.validate(provider.getDataTypeString(column.getDataType(), false), column.getDefaultValue());
                    switch (result) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 2: {
                            isValid = false;
                            BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(14), 1100, String.valueOf(NLS.bind((String)Messages.SybaseASABaseColumnValidator_for_column, (Object)column.getName())) + dataValidator.getErrorMessage(), new Object[]{SybaseasabasesqlmodelPackage.eINSTANCE.getSybaseASABaseColumn()});
                            diagnostics.add((Diagnostic)d);
                        }
                        case 3: {
                            break;
                        }
                    }
                }
            }
        }
        return isValid;
    }

    protected boolean validateReference(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        SybaseASABaseColumn column = (SybaseASABaseColumn)eObject;
        if ((featureId == 7 || featureId == 8) && column.getDataType() == null) {
            isValid = false;
            BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(7), 1, NLS.bind((String)Messages.SybaseASABaseColumnValidator_no_column_data_type, (Object)column.getName()), new Object[0]);
            diagnostics.add((Diagnostic)d);
        }
        return isValid;
    }
}

