/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLDataOfflineValidator;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLModelValidator;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class SybaseParameterValidator
extends DefaultSQLModelValidator {
    public static final Pattern NON_WORD = Pattern.compile("[\\W]+");
    public static final int INVALID_DATATYPE = 9999;
    public static final String SUPPORTS_EXPRESSION = "SUPPORTS_EXPRESSION";

    protected boolean validateAttribute(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        SybaseParameter param = (SybaseParameter)eObject;
        DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)sharedParams.get("didentifier");
        boolean supportsExp = Boolean.valueOf((String)sharedParams.get(SUPPORTS_EXPRESSION));
        if (featureId == 1) {
            if (param.getName() == null || param.getName().trim().equals("")) {
                isValid = false;
                BasicDiagnostic d = new BasicDiagnostic(1, Integer.toString(1), 1000, Messages.SybaseParameterValidator_no_name, new Object[]{param});
                diagnostics.add((Diagnostic)d);
            } else if (databaseIdentifier != null) {
                IIdentifierValidator identifierValidator = SQLToolsFacade.getConfiguration((DatabaseIdentifier)databaseIdentifier, null).getSQLService().getIdentifierValidator();
                if (param.getJDBCParameterType().getValue() == 5) {
                    return true;
                }
                String paraName = param.getName();
                ValidatorMessage msg = identifierValidator.isValid(paraName, 11, databaseIdentifier);
                if (msg != null && msg.getType() != 0) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(this.getDiagnosticCode(msg.getType()), Integer.toString(1), 1001, String.valueOf(msg.getMessage()) + ": " + param.getName(), new Object[]{param});
                    diagnostics.add((Diagnostic)d);
                }
            }
        } else if (featureId == 14) {
            SQLDataType datatype = param.getContainedType();
            String defaultValue = param.getDefaultValue();
            if (defaultValue != null && !defaultValue.equalsIgnoreCase("null")) {
                DefaultSQLDataOfflineValidator validator;
                String msg;
                Matcher m;
                String unquote = SQLUtil.unquote(defaultValue);
                if (this.isStringDataType((DataType)datatype) && (m = NON_WORD.matcher(defaultValue)).find() && defaultValue.equals(unquote)) {
                    BasicDiagnostic d;
                    isValid = false;
                    if (supportsExp) {
                        d = new BasicDiagnostic(2, Integer.toString(14), 1100, NLS.bind((String)Messages.SybaseParameterValueOfflineValidator_message_value_not_quoted_warning, (Object)defaultValue), new Object[]{param});
                        diagnostics.add((Diagnostic)d);
                    } else {
                        isValid = false;
                        d = new BasicDiagnostic(4, Integer.toString(14), 1100, NLS.bind((String)Messages.SybaseParameterValueOfflineValidator_message_value_not_quoted, (Object)defaultValue), new Object[]{param});
                        diagnostics.add((Diagnostic)d);
                    }
                }
                if (!defaultValue.equals(unquote)) {
                    defaultValue = unquote;
                }
                if (sharedParams.get(SUPPORTS_EXPRESSION) == null && (msg = (validator = new DefaultSQLDataOfflineValidator()).validate((DataType)datatype, defaultValue)) != null) {
                    isValid = false;
                    BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(14), 1001, msg, new Object[]{param});
                    diagnostics.add((Diagnostic)d);
                }
                if (databaseIdentifier != null && sharedParams.get("validate_default_value_via_db") != null) {
                    ISqlDataValidator dataValidator = SQLToolsFacade.getSQLDataValidator((DatabaseIdentifier)databaseIdentifier);
                    DataTypeProvider provider = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)ModelUtil.getDatabaseVendorDefinitionId((SQLObject)param.getRoutine())).getSQLDataService().getDataTypeProvider();
                    int result = dataValidator.validate(provider.getDataTypeString(param.getDataType(), false), param.getDefaultValue());
                    switch (result) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            isValid = false;
                            BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(14), 1100, dataValidator.getErrorMessage(), new Object[]{param});
                            diagnostics.add((Diagnostic)d);
                            break;
                        }
                    }
                }
            }
        }
        return isValid;
    }

    private boolean isStringDataType(DataType type) {
        if (type instanceof PredefinedDataType) {
            return type instanceof CharacterStringDataType || type instanceof DateDataType || type instanceof TimeDataType;
        }
        if (type instanceof DistinctUserDefinedType) {
            return this.isStringDataType((DataType)((DistinctUserDefinedType)type).getPredefinedRepresentation());
        }
        return false;
    }

    protected boolean validateReference(EObject eObject, int featureId, DiagnosticChain diagnostics, Map sharedParams) {
        boolean isValid = true;
        SybaseParameter param = (SybaseParameter)eObject;
        if (featureId == 8 && param.getDataType() == null) {
            isValid = false;
            String msg = Messages.SybaseParameterValidator_no_type;
            if (param.getDescription() != null) {
                msg = NLS.bind((String)Messages.SybaseParameterValidator_invalid_datatype, (Object)param.getDescription());
            }
            BasicDiagnostic d = new BasicDiagnostic(4, Integer.toString(7), 9999, msg, new Object[]{param});
            diagnostics.add((Diagnostic)d);
        }
        boolean validateReference = super.validateReference(eObject, featureId, diagnostics, sharedParams);
        return isValid && validateReference;
    }
}

