/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.assist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.Templates;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.Image;

public class MarkupTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    public static final String CONTEXT_ID = "org.eclipse.mylyn.wikitext.ui.editor";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final Comparator<ICompletionProposal> proposalComparator = new ProposalComparator();
    private static final Template[] NO_TEMPLATES = new Template[0];
    private final TemplateContextType contextType = new TemplateContextType("org.eclipse.mylyn.wikitext.ui.editor", Messages.MarkupTemplateCompletionProcessor_contextName);
    private Templates templates;

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return this.contextType;
    }

    protected Image getImage(Template template) {
        return null;
    }

    protected Template[] getTemplates(String contextTypeId) {
        if (this.contextType.getId().equals(contextTypeId) && this.templates != null) {
            return this.templates.getTemplate().toArray(new Template[this.templates.getTemplate().size()]);
        }
        return NO_TEMPLATES;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
            return new ICompletionProposal[0];
        }
        Region selectionRegion = new Region(selection.getOffset(), selection.getLength());
        TemplateContext selectionContext = this.createContext(viewer, (IRegion)selectionRegion);
        int lineOffset = 0;
        try {
            IRegion lineInformationOfOffset = viewer.getDocument().getLineInformationOfOffset(offset);
            lineOffset = offset - lineInformationOfOffset.getOffset();
        }
        catch (BadLocationException badLocationException) {}
        String selectionText = selection.getText();
        context.setVariable("selection", selectionText);
        selectionContext.setVariable("selection", selectionText);
        context.setVariable("text", selectionText);
        selectionContext.setVariable("text", selectionText);
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>(templates.length);
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Template template = templateArray[n2];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block11;
                }
                if (template.matches(prefix, context.getContextType().getId())) {
                    boolean selectionBasedMatch = this.isSelectionBasedMatch(template, context);
                    if (template.getName().startsWith(prefix) || selectionBasedMatch) {
                        int relevance = this.getRelevance(template, lineOffset, prefix);
                        if (selectionBasedMatch) {
                            matches.add(this.createProposal(template, selectionContext, (IRegion)selectionRegion, relevance));
                        } else {
                            matches.add(this.createProposal(template, context, (IRegion)region, relevance));
                        }
                    }
                }
            }
            ++n2;
        }
        Collections.sort(matches, proposalComparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    private int getRelevance(Template template, int lineOffset, String prefix) {
        boolean blockTemplate;
        boolean bl = blockTemplate = this.templates == null ? false : this.templates.isBlock(template);
        if (blockTemplate) {
            if (template.getName().startsWith(prefix)) {
                return lineOffset == 0 ? 95 : 75;
            }
            return lineOffset == 0 ? 85 : 0;
        }
        return super.getRelevance(template, prefix);
    }

    private boolean isSelectionBasedMatch(Template template, TemplateContext context) {
        String pattern = template.getPattern();
        HashSet<String> vars = new HashSet<String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(pattern);
        while (matcher.find()) {
            String variable;
            String variableName = matcher.group(1);
            if (!vars.add(variableName) || (variable = context.getVariable(variableName)) == null || variable.length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.templates = markupLanguage == null ? null : WikiTextUiPlugin.getDefault().getTemplates().get(markupLanguage.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }
}

