/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEModuleVirtualComponent
extends VirtualComponent
implements IComponentImplFactory {
    public static String GET_JAVA_REFS = "GET_JAVA_REFS";
    public static String GET_FUZZY_EAR_REFS = "GET_FUZZY_EAR_REFS";
    private long depGraphModStamp;
    private IVirtualReference[] fuzzyAndJavaRefs = null;
    private IVirtualReference[] fuzzyRefsOnly = null;
    private IVirtualReference[] javaRefsOnly = null;
    private IVirtualReference[] nonJavaRefsOnly = null;

    public J2EEModuleVirtualComponent() {
    }

    public J2EEModuleVirtualComponent(IProject aProject, IPath aRuntimePath) {
        super(aProject, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject aProject) {
        return new J2EEModuleVirtualComponent(aProject, (IPath)new Path("/"));
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation, IPath aRuntimePath) {
        return new J2EEModuleVirtualArchiveComponent(aProject, archiveLocation, aRuntimePath);
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return new VirtualFolder(aProject, aRuntimePath);
    }

    public IVirtualReference[] getNonJavaReferences() {
        if (this.nonJavaRefsOnly == null || !this.checkIfStillValid()) {
            this.nonJavaRefsOnly = this.getReferences(false, false);
        }
        return this.nonJavaRefsOnly;
    }

    public IVirtualReference[] getReferences(Map<String, Object> options) {
        Object objGetFuzzyEarRefs;
        boolean findFuzzyEARRefs;
        Object objGetJavaRefs = options.get(GET_JAVA_REFS);
        boolean getJavaRefs = objGetJavaRefs != null ? (Boolean)objGetJavaRefs : true;
        IVirtualReference[] cachedReferences = this.getCachedReference(getJavaRefs, findFuzzyEARRefs = (objGetFuzzyEarRefs = options.get(GET_FUZZY_EAR_REFS)) != null ? (Boolean)objGetFuzzyEarRefs : false);
        if (cachedReferences != null) {
            return cachedReferences;
        }
        cachedReferences = this.getReferences(getJavaRefs, findFuzzyEARRefs);
        this.setCachedReferences(getJavaRefs, findFuzzyEARRefs, cachedReferences);
        return cachedReferences;
    }

    public IVirtualReference[] getReferences() {
        if (this.javaRefsOnly == null || !this.checkIfStillValid()) {
            this.javaRefsOnly = this.getReferences(true, false);
        }
        return this.javaRefsOnly;
    }

    public IVirtualReference[] getReferences(boolean getJavaRefs, boolean findFuzzyEARRefs) {
        IVirtualReference[] cachedReferences = this.getCachedReference(getJavaRefs, findFuzzyEARRefs);
        if (cachedReferences != null) {
            return cachedReferences;
        }
        IVirtualReference[] hardReferences = this.getNonManifestReferences(getJavaRefs);
        List dynamicReferences = J2EEModuleVirtualComponent.getManifestReferences((IVirtualComponent)this, hardReferences, findFuzzyEARRefs);
        IVirtualReference[] references = null;
        if (dynamicReferences == null) {
            references = hardReferences;
        } else {
            references = new IVirtualReference[hardReferences.length + dynamicReferences.size()];
            System.arraycopy(hardReferences, 0, references, 0, hardReferences.length);
            int i = 0;
            while (i < dynamicReferences.size()) {
                references[hardReferences.length + i] = (IVirtualReference)dynamicReferences.get(i);
                ++i;
            }
        }
        this.setCachedReferences(getJavaRefs, findFuzzyEARRefs, references);
        return references;
    }

    public IVirtualReference[] getNonManifestReferences() {
        return this.getNonManifestReferences(true);
    }

    public IVirtualReference[] getNonManifestReferences(boolean getJavaRefs) {
        ArrayList<IVirtualReference> allRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] hardReferences = super.getReferences();
        int i = 0;
        while (i < hardReferences.length) {
            allRefs.add(hardReferences[i]);
            ++i;
        }
        if (getJavaRefs) {
            IVirtualReference[] cpRefs = this.getJavaClasspathReferences(hardReferences);
            int i2 = 0;
            while (i2 < cpRefs.length) {
                allRefs.add(cpRefs[i2]);
                ++i2;
            }
        }
        return allRefs.toArray(new IVirtualReference[allRefs.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getManifestClasspath(IVirtualComponent moduleComponent) {
        String[] manifestClasspath = null;
        if (moduleComponent.isBinary()) return ((J2EEModuleVirtualArchiveComponent)moduleComponent).getManifestClasspath();
        IVirtualFile vManifest = moduleComponent.getRootFolder().getFile("META-INF/MANIFEST.MF");
        if (!vManifest.exists()) return manifestClasspath;
        IFile manifestFile = vManifest.getUnderlyingFile();
        InputStream in = null;
        try {
            try {
                in = manifestFile.getContents();
                ArchiveManifestImpl manifest = new ArchiveManifestImpl(in);
                manifestClasspath = manifest.getClassPathTokenized();
                return manifestClasspath;
            }
            catch (IOException e) {
                J2EEPlugin.logError(e);
                if (in == null) return manifestClasspath;
                try {
                    in.close();
                    in = null;
                    return manifestClasspath;
                }
                catch (IOException e2) {
                    J2EEPlugin.logError(e2);
                }
                return manifestClasspath;
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
                if (in == null) return manifestClasspath;
                try {
                    in.close();
                    in = null;
                    return manifestClasspath;
                }
                catch (IOException e3) {
                    J2EEPlugin.logError(e3);
                }
                return manifestClasspath;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    J2EEPlugin.logError(e);
                }
            }
        }
    }

    public IVirtualReference[] getJavaClasspathReferences() {
        return this.getJavaClasspathReferences(null);
    }

    private IVirtualReference[] getJavaClasspathReferences(IVirtualReference[] hardReferences) {
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)this);
        if (!isWebApp && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            return new IVirtualReference[0];
        }
        IProject project = this.getProject();
        ArrayList<IVirtualReference> cpRefs = new ArrayList<IVirtualReference>();
        try {
            if (project == null || !project.isAccessible() || !project.hasNature(JavaCoreLite.NATURE_ID)) {
                return new IVirtualReference[0];
            }
            IJavaProjectLite javaProjectLite = JavaCoreLite.create((IProject)project);
            if (javaProjectLite == null) {
                return new IVirtualReference[0];
            }
            Map<IClasspathEntry, IClasspathAttribute> referencedEntries = ClasspathDependencyUtil.getComponentClasspathDependencies(javaProjectLite, isWebApp);
            if (referencedEntries.isEmpty()) {
                return new IVirtualReference[0];
            }
            IVirtualReference[] innerHardReferences = hardReferences;
            if (innerHardReferences == null) {
                innerHardReferences = super.getReferences();
            }
            IPath[] hardRefPaths = new IPath[innerHardReferences.length];
            int j = 0;
            while (j < innerHardReferences.length) {
                IVirtualComponent comp = innerHardReferences[j].getReferencedComponent();
                if (comp.isBinary()) {
                    VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)comp;
                    File diskFile = archiveComp.getUnderlyingDiskFile();
                    Path diskPath = null;
                    if (diskFile.exists()) {
                        diskPath = new Path(diskFile.getAbsolutePath());
                    } else {
                        IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
                        diskPath = iFile.getFullPath();
                    }
                    hardRefPaths[j] = diskPath;
                }
                ++j;
            }
            IContainer[] mappedClassFolders = null;
            for (IClasspathEntry entry : referencedEntries.keySet()) {
                IClasspathAttribute attrib = referencedEntries.get(entry);
                boolean isClassFolder = ClasspathDependencyUtil.isClassFolderEntry(entry);
                IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp, isClassFolder);
                boolean add = true;
                IPath entryLocation = ClasspathDependencyUtil.getEntryLocation(entry);
                if (entryLocation == null) {
                    add = false;
                } else if (!isClassFolder) {
                    int j2 = 0;
                    while (j2 < hardRefPaths.length) {
                        if (entryLocation.equals((Object)hardRefPaths[j2])) {
                            add = false;
                            break;
                        }
                        ++j2;
                    }
                } else {
                    if (mappedClassFolders == null) {
                        List containers = JavaLiteUtilities.getJavaOutputContainers((IVirtualComponent)this);
                        mappedClassFolders = containers.toArray(new IContainer[containers.size()]);
                    }
                    int j3 = 0;
                    while (j3 < mappedClassFolders.length) {
                        if (entryLocation.equals((Object)mappedClassFolders[j3].getFullPath())) {
                            add = false;
                            break;
                        }
                        ++j3;
                    }
                }
                if (!add || entryLocation == null) continue;
                String componentPath = null;
                ClasspathDependencyVirtualComponent entryComponent = null;
                componentPath = "cpe/" + entryLocation.toPortableString();
                entryComponent = new ClasspathDependencyVirtualComponent(project, componentPath, isClassFolder);
                IVirtualReference entryReference = ComponentCore.createReference((IVirtualComponent)this, (IVirtualComponent)entryComponent, (IPath)runtimePath);
                entryReference.setArchiveName(ClasspathDependencyUtil.getArchiveName(entry));
                cpRefs.add(entryReference);
            }
        }
        catch (CoreException jme) {
            J2EEPlugin.logError(jme);
        }
        return cpRefs.toArray(new IVirtualReference[cpRefs.size()]);
    }

    public static List getManifestReferences(IVirtualComponent moduleComponent, IVirtualReference[] hardReferences) {
        return J2EEModuleVirtualComponent.getManifestReferences(moduleComponent, hardReferences, false);
    }

    public static List getManifestReferences(IVirtualComponent moduleComponent, IVirtualReference[] hardReferences, boolean findFuzzyEARRefs) {
        ArrayList<IVirtualReference> dynamicReferences = null;
        String[] manifestClasspath = J2EEModuleVirtualComponent.getManifestClasspath(moduleComponent);
        IVirtualReference foundRef = null;
        String earArchiveURI = null;
        boolean simplePath = false;
        if (manifestClasspath != null && manifestClasspath.length > 0) {
            IProject[] earProjects;
            boolean[] foundRefAlready;
            boolean[] blArray = foundRefAlready = findFuzzyEARRefs ? new boolean[manifestClasspath.length] : null;
            if (foundRefAlready != null) {
                int i = 0;
                while (i < foundRefAlready.length) {
                    foundRefAlready[i] = false;
                    ++i;
                }
            }
            IProject[] iProjectArray = earProjects = EarUtilities.getReferencingEARProjects(moduleComponent.getProject());
            int n = earProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject earProject = iProjectArray[n2];
                if (JavaEEProjectUtilities.isEARProject(earProject)) {
                    IVirtualReference[] earRefs = null;
                    IVirtualComponent tempEARComponent = ComponentCore.createComponent((IProject)earProject);
                    IVirtualReference[] tempEarRefs = tempEARComponent.getReferences();
                    int j = 0;
                    while (j < tempEarRefs.length && earRefs == null) {
                        if (tempEarRefs[j].getReferencedComponent().equals(moduleComponent)) {
                            earRefs = tempEarRefs;
                            foundRef = tempEarRefs[j];
                            earArchiveURI = foundRef.getArchiveName();
                            simplePath = earArchiveURI != null ? earArchiveURI.lastIndexOf("/") == -1 : true;
                        }
                        ++j;
                    }
                    if (earRefs != null) {
                        int manifestIndex = 0;
                        while (manifestIndex < manifestClasspath.length) {
                            boolean found = false;
                            if (foundRefAlready == null || !foundRefAlready[manifestIndex]) {
                                int j2 = 0;
                                while (j2 < earRefs.length && !found) {
                                    String archiveName;
                                    if (foundRef != earRefs[j2] && (archiveName = earRefs[j2].getArchiveName()) != null) {
                                        boolean shouldAdd = false;
                                        String manifestEntryString = manifestClasspath[manifestIndex];
                                        if (manifestEntryString != null) {
                                            Path manifestPath = new Path(manifestEntryString);
                                            manifestEntryString = manifestPath.toPortableString();
                                        }
                                        if (simplePath && manifestEntryString != null && manifestEntryString.lastIndexOf("/") == -1) {
                                            shouldAdd = archiveName.equals(manifestEntryString);
                                        } else {
                                            String earRelativeURI = ArchiveUtil.deriveEARRelativeURI((String)manifestEntryString, (String)earArchiveURI);
                                            if (earRelativeURI != null) {
                                                shouldAdd = earRelativeURI.equals(archiveName);
                                            }
                                        }
                                        if (shouldAdd) {
                                            if (findFuzzyEARRefs && foundRefAlready != null) {
                                                foundRefAlready[manifestIndex] = true;
                                            }
                                            found = true;
                                            boolean shouldInclude = true;
                                            IVirtualComponent dynamicComponent = earRefs[j2].getReferencedComponent();
                                            if (hardReferences != null) {
                                                int k = 0;
                                                while (k < hardReferences.length && shouldInclude) {
                                                    if (hardReferences[k].getReferencedComponent().equals(dynamicComponent)) {
                                                        shouldInclude = false;
                                                    }
                                                    ++k;
                                                }
                                            }
                                            if (shouldInclude) {
                                                IVirtualReference dynamicReference = ComponentCore.createReference((IVirtualComponent)moduleComponent, (IVirtualComponent)dynamicComponent);
                                                if (dynamicReferences == null) {
                                                    dynamicReferences = new ArrayList<IVirtualReference>();
                                                }
                                                dynamicReferences.add(dynamicReference);
                                            }
                                        }
                                    }
                                    ++j2;
                                }
                            }
                            ++manifestIndex;
                        }
                        if (!findFuzzyEARRefs) break;
                        if (foundRefAlready != null) {
                            boolean foundAll = true;
                            int i = 0;
                            while (i < foundRefAlready.length && foundAll) {
                                if (!foundRefAlready[i]) {
                                    foundAll = false;
                                }
                                ++i;
                            }
                            if (foundAll) break;
                        }
                    }
                }
                ++n2;
            }
        }
        return dynamicReferences;
    }

    private void setCachedReferences(boolean getJavaRefs, boolean findFuzzyEARRefs, IVirtualReference[] references) {
        if (findFuzzyEARRefs && getJavaRefs) {
            this.fuzzyAndJavaRefs = references;
        } else if (!findFuzzyEARRefs && !getJavaRefs) {
            this.nonJavaRefsOnly = references;
        } else if (findFuzzyEARRefs) {
            this.fuzzyRefsOnly = references;
        } else {
            this.javaRefsOnly = references;
        }
    }

    private IVirtualReference[] getCachedReference(boolean getJavaRefs, boolean findFuzzyEARRefs) {
        if (this.checkIfStillValid()) {
            if (findFuzzyEARRefs && getJavaRefs) {
                return this.fuzzyAndJavaRefs;
            }
            if (!findFuzzyEARRefs && !getJavaRefs) {
                return this.nonJavaRefsOnly;
            }
            if (findFuzzyEARRefs) {
                return this.fuzzyRefsOnly;
            }
            return this.javaRefsOnly;
        }
        return null;
    }

    private boolean checkIfStillValid() {
        boolean valid;
        boolean bl = valid = IDependencyGraph.INSTANCE.getModStamp() == this.depGraphModStamp;
        if (!valid) {
            this.clearCache();
        }
        return valid;
    }

    protected void clearCache() {
        super.clearCache();
        this.depGraphModStamp = IDependencyGraph.INSTANCE.getModStamp();
        this.fuzzyAndJavaRefs = null;
        this.fuzzyRefsOnly = null;
        this.javaRefsOnly = null;
        this.nonJavaRefsOnly = null;
    }
}

