/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IDefaultVersionProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkListener;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.internal.EventsExtensionPoint;
import org.eclipse.wst.common.project.facet.core.events.internal.FacetedProjectFrameworkEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.FrameworkListenerRegistry;
import org.eclipse.wst.common.project.facet.core.events.internal.LegacyEventHandlerAdapter;
import org.eclipse.wst.common.project.facet.core.events.internal.ProjectListenerRegistry;
import org.eclipse.wst.common.project.facet.core.internal.ActionDefinition;
import org.eclipse.wst.common.project.facet.core.internal.Category;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProject;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectTemplatesExtensionPoint;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.internal.Group;
import org.eclipse.wst.common.project.facet.core.internal.PresetsExtensionPoint;
import org.eclipse.wst.common.project.facet.core.internal.ProblemLog;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetPreferencesGroup;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.UserPreset;
import org.eclipse.wst.common.project.facet.core.internal.ValidationProblem;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.VersionExpr;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetedProjectFrameworkImpl {
    private static final String EXTENSION_ID = "facets";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PROVIDER = "provider";
    private static final String ATTR_SOFT = "soft";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VERSION = "version";
    private static final String EL_ACTION = "action";
    private static final String EL_CATEGORY = "category";
    private static final String EL_CONFIG_FACTORY = "config-factory";
    private static final String EL_CONSTRAINT = "constraint";
    private static final String EL_DEFAULT_VERSION = "default-version";
    private static final String EL_DELEGATE = "delegate";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_EVENT_HANDLER = "event-handler";
    private static final String EL_GROUP = "group";
    private static final String EL_GROUP_MEMBER = "group-member";
    private static final String EL_LABEL = "label";
    private static final String EL_MEMBER = "member";
    private static final String EL_PROJECT_FACET = "project-facet";
    private static final String EL_PROJECT_FACET_VERSION = "project-facet-version";
    private static final String EL_PROPERTY = "property";
    private static final String EL_VERSION_COMPARATOR = "version-comparator";
    private static final String DEFAULT_DESCRIPTION = "";
    private static FacetedProjectFrameworkImpl instance = null;
    private final IndexedSet<String, IProjectFacet> facets;
    private final IndexedSet<String, IActionDefinition> actions;
    private final IndexedSet<String, ICategory> categories;
    private final IndexedSet<String, IPreset> presets;
    private boolean presetsInitialized = false;
    private final IndexedSet<String, IGroup> groups;
    private final Map<String, FacetedProject> projects;
    private final ProjectListenerRegistry projectListenerRegistry;
    private final FrameworkListenerRegistry frameworkListenerRegistry;
    private WeakReference<ProjectFacetPreferencesGroup> globalPreferencesGroup = null;
    private Map<String, WeakReference<ProjectFacetPreferencesGroup>> projectPreferencesGroups = new HashMap<String, WeakReference<ProjectFacetPreferencesGroup>>();

    private FacetedProjectFrameworkImpl() {
        long activationStart = 0L;
        if (FacetCorePlugin.isTracingFrameworkActivation()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Throwable().printStackTrace(pw);
            String context = sw.getBuffer().toString();
            int endOfFirstLine = context.indexOf(10);
            context = context.substring(endOfFirstLine + 1);
            context = context.replaceAll("\\t", "  ");
            int length = context.length();
            length = context.charAt(length - 2) == '\r' ? (length -= 2) : --length;
            context = context.substring(0, length);
            String msg = NLS.bind((String)Resources.tracingFrameworkActivationStarting, (Object)context);
            System.out.println(msg);
            activationStart = System.currentTimeMillis();
        }
        this.facets = new IndexedSet();
        this.actions = new IndexedSet();
        this.categories = new IndexedSet();
        this.presets = new IndexedSet();
        this.presetsInitialized = false;
        this.groups = new IndexedSet();
        this.projects = new HashMap<String, FacetedProject>();
        this.projectListenerRegistry = new ProjectListenerRegistry();
        this.frameworkListenerRegistry = new FrameworkListenerRegistry();
        this.readMetadata();
        EventsExtensionPoint.processExtensions(this);
        new ResourceChangeListener().register();
        if (FacetCorePlugin.isTracingFrameworkActivation()) {
            long duration = System.currentTimeMillis() - activationStart;
            String msg = NLS.bind((String)Resources.tracingFrameworkActivationFinished, (Object)String.valueOf(duration));
            System.out.println(msg);
        }
    }

    public static synchronized FacetedProjectFrameworkImpl getInstance() {
        if (instance == null) {
            instance = new FacetedProjectFrameworkImpl();
        }
        return instance;
    }

    public Set<IProjectFacet> getProjectFacets() {
        return this.facets.getUnmodifiable();
    }

    public boolean isProjectFacetDefined(String id) {
        return this.facets.containsKey(id);
    }

    public IProjectFacet getProjectFacet(String id) {
        IProjectFacet f = this.facets.get(id);
        if (f == null) {
            String msg = NLS.bind((String)Resources.facetNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return f;
    }

    public Set<IActionDefinition> getActionDefinitions() {
        return this.actions.getUnmodifiable();
    }

    public boolean isActionDefined(String id) {
        return this.actions.containsKey(id);
    }

    public IActionDefinition getActionDefinition(String id) {
        IActionDefinition adef = this.actions.get(id);
        if (adef == null) {
            String msg = NLS.bind((String)Resources.actionNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return adef;
    }

    public Set<ICategory> getCategories() {
        return this.categories.getUnmodifiable();
    }

    public boolean isCategoryDefined(String id) {
        return this.categories.containsKey(id);
    }

    public ICategory getCategory(String id) {
        ICategory category = this.categories.get(id);
        if (category == null) {
            String msg = NLS.bind((String)Resources.categoryNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IPreset> getPresets() {
        IndexedSet<String, IPreset> indexedSet = this.presets;
        synchronized (indexedSet) {
            this.initializePresets();
            return this.presets.getUnmodifiable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresetDefined(String id) {
        IndexedSet<String, IPreset> indexedSet = this.presets;
        synchronized (indexedSet) {
            this.initializePresets();
            return this.presets.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPreset getPreset(String id) {
        IndexedSet<String, IPreset> indexedSet = this.presets;
        synchronized (indexedSet) {
            this.initializePresets();
            IPreset preset = this.presets.get(id);
            if (preset == null) {
                String msg = NLS.bind((String)Resources.presetNotDefined, (Object)id);
                throw new IllegalArgumentException(msg);
            }
            return preset;
        }
    }

    public IPreset definePreset(String name, Set<IProjectFacetVersion> facets) {
        return this.definePreset(name, null, facets);
    }

    public IPreset definePreset(String name, String description, Set<IProjectFacetVersion> facets) {
        this.initializePresets();
        IPreset preset = this.definePreset(name, description, facets, true);
        FacetedProjectFrameworkEvent event = new FacetedProjectFrameworkEvent(IFacetedProjectFrameworkEvent.Type.PRESET_ADDED);
        this.frameworkListenerRegistry.notifyListeners(event);
        return preset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPreset definePreset(String name, String description, Set<IProjectFacetVersion> facets, boolean save) {
        IndexedSet<String, IPreset> indexedSet = this.presets;
        synchronized (indexedSet) {
            String id;
            int i = 0;
            do {
                id = ".usr." + i;
                ++i;
            } while (this.presets.containsKey(id));
            UserPreset preset = new UserPreset(id, name, description == null ? DEFAULT_DESCRIPTION : description, facets);
            this.presets.add(id, preset);
            if (save) {
                this.saveUserPresets();
            }
            return preset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletePreset(IPreset preset) {
        boolean deleted;
        IndexedSet<String, IPreset> indexedSet = this.presets;
        synchronized (indexedSet) {
            block6: {
                this.initializePresets();
                if (preset.getType() == IPreset.Type.USER_DEFINED) break block6;
                return false;
            }
            deleted = this.presets.delete(preset.getId());
            if (deleted) {
                this.saveUserPresets();
            }
        }
        if (deleted) {
            FacetedProjectFrameworkEvent event = new FacetedProjectFrameworkEvent(IFacetedProjectFrameworkEvent.Type.PRESET_REMOVED);
            this.frameworkListenerRegistry.notifyListeners(event);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePresets() {
        IndexedSet<String, IPreset> indexedSet = this.presets;
        synchronized (indexedSet) {
            if (!this.presetsInitialized) {
                for (IPreset preset : PresetsExtensionPoint.getPresets()) {
                    this.presets.add(preset.getId(), preset);
                }
                this.readUserPresets();
                this.presetsInitialized = true;
            }
        }
    }

    private void saveUserPresets() {
        try {
            Preferences root = FacetedProjectFrameworkImpl.getUserPresetsPreferences();
            String[] children = root.childrenNames();
            int i = 0;
            while (i < children.length) {
                root.node(children[i]).removeNode();
                ++i;
            }
            for (IPreset preset : this.presets) {
                if (preset.getType() != IPreset.Type.USER_DEFINED) continue;
                Preferences pnode = root.node(preset.getId());
                pnode.put(EL_LABEL, preset.getLabel());
                pnode.put(EL_DESCRIPTION, preset.getDescription());
                int counter = 1;
                for (IProjectFacetVersion fv : preset.getProjectFacets()) {
                    Preferences fnode = pnode.node(String.valueOf(counter));
                    fnode.put(ATTR_ID, fv.getProjectFacet().getId());
                    fnode.put(ATTR_VERSION, fv.getVersionString());
                    ++counter;
                }
            }
            root.flush();
        }
        catch (BackingStoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
        }
    }

    private void readUserPresets() {
        try {
            Preferences root = FacetedProjectFrameworkImpl.getUserPresetsPreferences();
            String[] pkeys = root.childrenNames();
            int i = 0;
            while (i < pkeys.length) {
                Preferences pnode = root.node(pkeys[i]);
                String label = pnode.get(EL_LABEL, null);
                if (label != null) {
                    String description = pnode.get(EL_DESCRIPTION, null);
                    if (description == null) {
                        description = DEFAULT_DESCRIPTION;
                    }
                    String[] fkeys = pnode.childrenNames();
                    HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();
                    int j = 0;
                    while (j < fkeys.length) {
                        IProjectFacet f;
                        Preferences fnode = pnode.node(fkeys[j]);
                        String id = fnode.get(ATTR_ID, null);
                        String version = fnode.get(ATTR_VERSION, null);
                        if (id == null || version == null) {
                            facets = null;
                            break;
                        }
                        if (this.isProjectFacetDefined(id)) {
                            f = this.getProjectFacet(id);
                            if (!f.hasVersion(version)) {
                                facets = null;
                                break;
                            }
                        } else {
                            facets = null;
                            break;
                        }
                        facets.add(f.getVersion(version));
                        ++j;
                    }
                    if (facets != null) {
                        this.definePreset(label, description, facets, false);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BackingStoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
        }
    }

    private static Preferences getUserPresetsPreferences() {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.wst.common.project.facet.core");
        return pluginRoot.node("user.presets");
    }

    public Set<IFacetedProjectTemplate> getTemplates() {
        return FacetedProjectTemplatesExtensionPoint.getTemplates();
    }

    public boolean isTemplateDefined(String id) {
        return FacetedProjectTemplatesExtensionPoint.getTemplate(id) != null;
    }

    public IFacetedProjectTemplate getTemplate(String id) {
        IFacetedProjectTemplate template = FacetedProjectTemplatesExtensionPoint.getTemplate(id);
        if (template == null) {
            String msg = NLS.bind((String)Resources.templateNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return template;
    }

    public Set<IGroup> getGroups() {
        return this.groups.getUnmodifiable();
    }

    public boolean isGroupDefined(String id) {
        return this.groups.containsKey(id);
    }

    public IGroup getGroup(String id) {
        IGroup group = this.groups.get(id);
        if (group == null) {
            String msg = NLS.bind((String)Resources.groupNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return group;
    }

    public Set<IFacetedProject> getFacetedProjects() throws CoreException {
        return this.getFacetedProjects(null, null);
    }

    public Set<IFacetedProject> getFacetedProjects(IProjectFacet f) throws CoreException {
        return this.getFacetedProjects(f, null);
    }

    public Set<IFacetedProject> getFacetedProjects(IProjectFacetVersion fv) throws CoreException {
        return this.getFacetedProjects(null, fv);
    }

    private Set<IFacetedProject> getFacetedProjects(IProjectFacet f, IProjectFacetVersion fv) throws CoreException {
        IProject[] all = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IFacetedProject> result = new HashSet<IFacetedProject>();
        int i = 0;
        while (i < all.length) {
            IProject proj = all[i];
            IFacetedProject fproj = this.create(proj);
            if (fproj != null && (f == null || fproj.hasProjectFacet(f)) && (fv == null || fproj.hasProjectFacet(fv))) {
                result.add(fproj);
            }
            ++i;
        }
        return result;
    }

    public IFacetedProjectWorkingCopy createNewProject() {
        return new FacetedProjectWorkingCopy(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFacetedProject create(IProject project) throws CoreException {
        if (project.isAccessible() && project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature")) {
            FacetedProject fproj = null;
            Map<String, FacetedProject> map = this.projects;
            synchronized (map) {
                fproj = this.projects.get(project.getName());
                if (fproj == null) {
                    fproj = new FacetedProject(project);
                    this.projects.put(project.getName(), fproj);
                }
            }
            fproj.refresh();
            return fproj;
        }
        return null;
    }

    public IFacetedProject create(IProject project, boolean convertIfNecessary, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(DEFAULT_DESCRIPTION, 1);
        }
        try {
            if (project.isAccessible() && !project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature") && convertIfNecessary) {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[prevNatures.length] = "org.eclipse.wst.common.project.facet.core.nature";
                description.setNatureIds(newNatures);
                FileUtil.validateEdit(project.getFile(".project"));
                project.setDescription(description, FacetedProjectFrameworkImpl.submon(monitor, 1));
            }
            IFacetedProject iFacetedProject = this.create(project);
            return iFacetedProject;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IFacetedProject create(String name, IPath location, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(DEFAULT_DESCRIPTION, 2);
        }
        try {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject(name);
            IProjectDescription desc = ws.newProjectDescription(name);
            desc.setLocation(location);
            project.create(desc, FacetedProjectFrameworkImpl.submon(monitor, 1));
            project.open(FacetedProjectFrameworkImpl.submon(monitor, 1));
            desc.setNatureIds(new String[]{"org.eclipse.wst.common.project.facet.core.nature"});
            project.setDescription(desc, null);
            IFacetedProject iFacetedProject = this.create(project);
            return iFacetedProject;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void addListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        this.projectListenerRegistry.addListener(listener, types);
    }

    public void addListener(IFacetedProjectFrameworkListener listener, IFacetedProjectFrameworkEvent.Type ... types) {
        this.frameworkListenerRegistry.addListener(listener, types);
    }

    public void removeListener(IFacetedProjectListener listener) {
        this.projectListenerRegistry.removeListener(listener);
    }

    public void removeListener(IFacetedProjectFrameworkListener listener) {
        this.frameworkListenerRegistry.removeListener(listener);
    }

    ProjectListenerRegistry getProjectListenerRegistry() {
        return this.projectListenerRegistry;
    }

    public IStatus check(Set<IProjectFacetVersion> base, Set<IFacetedProject.Action> actions) {
        IStatus[] children;
        MultiStatus result = Constraint.createMultiStatus();
        for (IFacetedProject.Action action : actions) {
            Object ptype;
            if (action.getProjectFacetVersion().supports(base, action.getType())) continue;
            if (action.getType() == IFacetedProject.Action.Type.INSTALL) {
                ptype = ValidationProblem.Type.INSTALL_NOT_SUPPORTED;
            } else if (action.getType() == IFacetedProject.Action.Type.UNINSTALL) {
                ptype = ValidationProblem.Type.UNINSTALL_NOT_SUPPORTED;
            } else if (action.getType() == IFacetedProject.Action.Type.VERSION_CHANGE) {
                ptype = ValidationProblem.Type.VERSION_CHANGE_NOT_SUPPORTED;
            } else {
                throw new IllegalStateException();
            }
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            ValidationProblem vp = new ValidationProblem((ValidationProblem.Type)ptype, fv.getProjectFacet().getLabel(), fv.getVersionString());
            result.add((IStatus)vp);
        }
        HashMap<IProjectFacet, HashSet<IFacetedProject.Action>> facetToActionsMap = new HashMap<IProjectFacet, HashSet<IFacetedProject.Action>>();
        for (IFacetedProject.Action action : actions) {
            IProjectFacet f = action.getProjectFacetVersion().getProjectFacet();
            HashSet<IFacetedProject.Action> group = (HashSet<IFacetedProject.Action>)facetToActionsMap.get(f);
            if (group == null) {
                group = new HashSet<IFacetedProject.Action>();
                facetToActionsMap.put(f, group);
            }
            group.add(action);
        }
        for (Set group : facetToActionsMap.values()) {
            if (group.size() <= 1) continue;
            boolean bad = true;
            if (group.size() == 2) {
                IFacetedProject.Action install = null;
                IFacetedProject.Action uninstall = null;
                for (IFacetedProject.Action action : group) {
                    if (action.getType() == IFacetedProject.Action.Type.INSTALL) {
                        install = action;
                        continue;
                    }
                    if (action.getType() != IFacetedProject.Action.Type.UNINSTALL) break;
                    uninstall = action;
                }
                if (install != null && uninstall != null && base.contains(uninstall.getProjectFacetVersion())) {
                    bad = false;
                }
            }
            if (!bad) continue;
            ValidationProblem.Type ptype = ValidationProblem.Type.MULTIPLE_ACTIONS_NOT_SUPPORTED;
            result.add((IStatus)new ValidationProblem(ptype));
            break;
        }
        for (IFacetedProject.Action action : actions) {
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            IProjectFacet f = fv.getProjectFacet();
            ValidationProblem.Type ptype = null;
            if (action.getType() == IFacetedProject.Action.Type.UNINSTALL) {
                if (!base.contains(fv)) {
                    ptype = ValidationProblem.Type.CANNOT_UNINSTALL;
                }
            } else {
                IProjectFacetVersion existing = null;
                for (IProjectFacetVersion iProjectFacetVersion : base) {
                    if (iProjectFacetVersion.getProjectFacet() != f) continue;
                    existing = iProjectFacetVersion;
                    break;
                }
                if (action.getType() == IFacetedProject.Action.Type.VERSION_CHANGE && existing == null) {
                    ptype = ValidationProblem.Type.CANNOT_CHANGE_VERSION;
                } else if (action.getType() == IFacetedProject.Action.Type.INSTALL && existing != null) {
                    ptype = ValidationProblem.Type.FACET_ALREADY_INSTALLED;
                }
            }
            if (ptype == null) continue;
            result.add((IStatus)new ValidationProblem(ptype, f.getLabel(), fv.getVersionString()));
        }
        if (!result.isOK()) {
            return result;
        }
        HashSet<IProjectFacetVersion> all = new HashSet<IProjectFacetVersion>(base);
        for (IFacetedProject.Action action : actions) {
            if (action.getType() != IFacetedProject.Action.Type.UNINSTALL) continue;
            FacetedProjectFrameworkImpl.apply(all, action);
        }
        for (IFacetedProject.Action action : actions) {
            if (action.getType() == IFacetedProject.Action.Type.UNINSTALL) continue;
            FacetedProjectFrameworkImpl.apply(all, action);
        }
        for (IProjectFacetVersion fv : all) {
            IStatus st;
            IConstraint constraint = fv.getConstraint();
            if (constraint == null || (st = constraint.check(all)).isOK()) continue;
            result.addAll(st);
        }
        HashSet<IStatus> problems = new HashSet<IStatus>();
        IStatus[] iStatusArray = children = result.getChildren();
        int n = children.length;
        int st = 0;
        while (st < n) {
            IStatus child = iStatusArray[st];
            problems.add(child);
            ++st;
        }
        HashSet<ValidationProblem> toremove = new HashSet<ValidationProblem>();
        for (IStatus problem : problems) {
            ValidationProblem validationProblem;
            if (toremove.contains(problem) || (validationProblem = (ValidationProblem)problem).getType() != ValidationProblem.Type.CONFLICTS) continue;
            Object[] p = validationProblem.getParameters();
            ValidationProblem reverse = new ValidationProblem(ValidationProblem.Type.CONFLICTS, new Object[]{p[1], p[0]});
            toremove.add(reverse);
        }
        if (toremove.size() > 0) {
            problems.removeAll(toremove);
            children = problems.toArray(new IStatus[problems.size()]);
            result = Constraint.createMultiStatus(children);
        }
        return result;
    }

    public void sort(Set<IProjectFacetVersion> base, List<IFacetedProject.Action> actions) {
        int count = actions.size();
        if (count == 0) {
            return;
        }
        IStatus st = this.check(base, new HashSet<IFacetedProject.Action>(actions));
        if (!st.isOK()) {
            FacetCorePlugin.log(st);
            return;
        }
        ArrayList<IFacetedProject.Action> unsorted = null;
        int steps = 0;
        if (FacetCorePlugin.isTracingActionSorting()) {
            unsorted = new ArrayList<IFacetedProject.Action>(actions);
        }
        Comparator<IFacetedProject.Action> comp = new Comparator<IFacetedProject.Action>(){

            @Override
            public int compare(IFacetedProject.Action a1, IFacetedProject.Action a2) {
                int res = this.compare(a1.getType(), a2.getType());
                if (res == 0) {
                    String fid1 = a1.getProjectFacetVersion().getProjectFacet().getId();
                    String fid2 = a2.getProjectFacetVersion().getProjectFacet().getId();
                    res = fid1.compareTo(fid2);
                }
                return res;
            }

            @Override
            private int compare(IFacetedProject.Action.Type t1, IFacetedProject.Action.Type t2) {
                if (t1 == t2) {
                    return 0;
                }
                if (t1 == IFacetedProject.Action.Type.UNINSTALL) {
                    return -1;
                }
                if (t2 == IFacetedProject.Action.Type.UNINSTALL) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(actions, comp);
        HashSet<IProjectFacetVersion> fnl = new HashSet<IProjectFacetVersion>(base);
        for (IFacetedProject.Action action : actions) {
            FacetedProjectFrameworkImpl.apply(fnl, action);
        }
        boolean makeAnotherPass = true;
        block1: while (makeAnotherPass) {
            makeAnotherPass = false;
            HashSet<IProjectFacetVersion> state = new HashSet<IProjectFacetVersion>(base);
            int i = 0;
            while (i < count) {
                IFacetedProject.Action action = actions.get(i);
                IFacetedProject.Action.Type type = action.getType();
                IProjectFacetVersion fv = action.getProjectFacetVersion();
                IConstraint constraint = fv.getConstraint();
                if (type == IFacetedProject.Action.Type.UNINSTALL) {
                    if (!constraint.check(state, true).isOK() && constraint.check(base, true).isOK()) {
                        FacetedProjectFrameworkImpl.moveToFront(actions, i);
                        makeAnotherPass = true;
                        ++steps;
                        continue block1;
                    }
                    FacetedProjectFrameworkImpl.apply(state, action);
                    ++i;
                    continue;
                }
                if (constraint.check(state).isOK() && (constraint.check(state, true).isOK() || !constraint.check(fnl, true).isOK())) {
                    FacetedProjectFrameworkImpl.apply(state, action);
                    ++i;
                    continue;
                }
                FacetedProjectFrameworkImpl.moveToEnd(actions, i);
                ++steps;
            }
        }
        if (FacetCorePlugin.isTracingActionSorting()) {
            String text = Resources.bind(Resources.tracingActionSorting, FacetedProjectFrameworkImpl.toString(base), FacetedProjectFrameworkImpl.toString(unsorted), FacetedProjectFrameworkImpl.toString(actions), String.valueOf(steps));
            System.out.println(text);
        }
    }

    static void apply(Set<IProjectFacetVersion> facets, IFacetedProject.Action action) {
        IFacetedProject.Action.Type type = action.getType();
        IProjectFacetVersion fv = action.getProjectFacetVersion();
        if (type == IFacetedProject.Action.Type.INSTALL) {
            facets.add(fv);
        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
            facets.remove(fv);
        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
            for (IProjectFacetVersion x : facets) {
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                facets.remove(x);
                break;
            }
            facets.add(fv);
        }
    }

    public synchronized Preferences getPreferences(IProjectFacet facet) throws BackingStoreException {
        ProjectFacetPreferencesGroup group = null;
        if (this.globalPreferencesGroup != null) {
            group = (ProjectFacetPreferencesGroup)this.globalPreferencesGroup.get();
        }
        if (group == null) {
            group = new ProjectFacetPreferencesGroup(null);
            this.globalPreferencesGroup = new WeakReference<ProjectFacetPreferencesGroup>(group);
        }
        return group.getPreferences(facet);
    }

    public synchronized Preferences getPreferences(IProjectFacet facet, IFacetedProject project) throws BackingStoreException {
        String pjname = project.getProject().getName();
        ProjectFacetPreferencesGroup group = null;
        WeakReference<ProjectFacetPreferencesGroup> ref = this.projectPreferencesGroups.get(pjname);
        if (ref != null) {
            group = (ProjectFacetPreferencesGroup)ref.get();
        }
        if (group == null) {
            group = new ProjectFacetPreferencesGroup(project);
            ref = new WeakReference<ProjectFacetPreferencesGroup>(group);
            this.projectPreferencesGroups.put(pjname, ref);
        }
        return group.getPreferences(facet);
    }

    private static IProgressMonitor submon(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return null;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    private static void moveToFront(List<IFacetedProject.Action> actions, int index) {
        IFacetedProject.Action action = actions.get(index);
        int i = index;
        while (i > 0) {
            actions.set(i, actions.get(i - 1));
            --i;
        }
        actions.set(0, action);
    }

    private static void moveToEnd(List<IFacetedProject.Action> actions, int index) {
        IFacetedProject.Action action = actions.get(index);
        int i = index + 1;
        int n = actions.size();
        while (i < n) {
            actions.set(i - 1, actions.get(i));
            ++i;
        }
        actions.set(actions.size() - 1, action);
    }

    private void readMetadata() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgel = iConfigurationElementArray[n4];
                cfgels.add(cfgel);
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals("category")) continue;
            try {
                this.readCategory(config);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_PROJECT_FACET)) continue;
            try {
                this.readProjectFacet(config);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        HashMap<ProjectFacetVersion, IConfigurationElement> fvToConstraint = new HashMap<ProjectFacetVersion, IConfigurationElement>();
        HashMap<ProjectFacetVersion, List<IConfigurationElement>> fvToActions = new HashMap<ProjectFacetVersion, List<IConfigurationElement>>();
        for (IConfigurationElement iConfigurationElement : cfgels) {
            if (!iConfigurationElement.getName().equals(EL_PROJECT_FACET_VERSION)) continue;
            this.readProjectFacetVersion(iConfigurationElement, fvToConstraint, fvToActions);
        }
        this.calculateVersionComparisonTables(fvToConstraint, fvToActions);
        for (Map.Entry entry : fvToConstraint.entrySet()) {
            this.readConstraint((IConfigurationElement)entry.getValue(), (ProjectFacetVersion)entry.getKey());
        }
        for (Map.Entry entry : fvToActions.entrySet()) {
            ProjectFacetVersion fv = (ProjectFacetVersion)entry.getKey();
            List actions = (List)entry.getValue();
            for (IConfigurationElement config : actions) {
                this.readAction(config, (ProjectFacet)fv.getProjectFacet(), fv.getVersionString());
            }
        }
        for (IConfigurationElement iConfigurationElement : cfgels) {
            if (iConfigurationElement.getName().equals(EL_ACTION)) {
                this.readAction(iConfigurationElement);
                continue;
            }
            if (!iConfigurationElement.getName().equals(EL_EVENT_HANDLER)) continue;
            this.readEventHandler(iConfigurationElement);
        }
        for (IConfigurationElement iConfigurationElement : cfgels) {
            if (!iConfigurationElement.getName().equals(EL_PROJECT_FACET)) continue;
            this.readDefaultVersionInfo(iConfigurationElement);
        }
        for (IConfigurationElement iConfigurationElement : cfgels) {
            if (!iConfigurationElement.getName().equals("group")) continue;
            try {
                this.readGroup(iConfigurationElement);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private void readCategory(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        Category category = new Category();
        category.setId(PluginUtil.findRequiredAttribute(config, ATTR_ID));
        category.setPluginId(config.getContributor().getName());
        IConfigurationElement elLabel = PluginUtil.findOptionalElement(config, EL_LABEL);
        category.setLabel(PluginUtil.getElementValue(elLabel, category.getId()));
        IConfigurationElement elDesc = PluginUtil.findOptionalElement(config, EL_DESCRIPTION);
        category.setDescription(PluginUtil.getElementValue(elDesc, DEFAULT_DESCRIPTION));
        this.categories.add(category.getId(), category);
    }

    private void readProjectFacet(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        IConfigurationElement elCategory;
        ProjectFacet f = new ProjectFacet();
        f.setId(PluginUtil.findRequiredAttribute(config, ATTR_ID));
        f.setPluginId(config.getContributor().getName());
        IConfigurationElement elLabel = PluginUtil.findOptionalElement(config, EL_LABEL);
        f.setLabel(PluginUtil.getElementValue(elLabel, f.getId()));
        IConfigurationElement elDesc = PluginUtil.findOptionalElement(config, EL_DESCRIPTION);
        f.setDescription(PluginUtil.getElementValue(elDesc, DEFAULT_DESCRIPTION));
        IConfigurationElement elComp = PluginUtil.findOptionalElement(config, EL_VERSION_COMPARATOR);
        if (elComp != null) {
            f.setVersionComparator(PluginUtil.findRequiredAttribute(elComp, ATTR_CLASS));
        }
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_PROPERTY)) {
                String name = child.getAttribute(ATTR_NAME);
                if (name == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_NAME);
                } else {
                    String value = child.getAttribute(ATTR_VALUE);
                    if (value == null) {
                        PluginUtil.reportMissingAttribute(child, ATTR_VALUE);
                    } else {
                        Object parsedValue = value;
                        if (name.equals("hide.version")) {
                            parsedValue = Boolean.parseBoolean(value);
                        }
                        f.setProperty(name, parsedValue);
                    }
                }
            }
            ++i;
        }
        String catname = null;
        IConfigurationElement elMember = PluginUtil.findOptionalElement(config, EL_MEMBER);
        if (elMember != null) {
            catname = PluginUtil.findRequiredAttribute(elMember, "category");
        }
        if ((elCategory = PluginUtil.findOptionalElement(config, "category")) != null) {
            catname = PluginUtil.getElementValue(elCategory, null);
        }
        if (catname != null) {
            if (this.isCategoryDefined(catname)) {
                Category category = (Category)this.getCategory(catname);
                f.setCategory(category);
                category.addProjectFacet(f);
            } else {
                String msg = String.valueOf(NLS.bind((String)Resources.categoryNotDefined, (Object)catname)) + NLS.bind((String)Resources.usedInPlugin, (Object)config.getContributor().getName());
                FacetCorePlugin.log(msg);
            }
        }
        this.facets.add(f.getId(), f);
    }

    private void readProjectFacetVersion(IConfigurationElement config, Map<ProjectFacetVersion, IConfigurationElement> fvToConstraint, Map<ProjectFacetVersion, List<IConfigurationElement>> fvToActions) {
        String childName;
        IConfigurationElement child;
        String fid = config.getAttribute(ATTR_FACET);
        if (fid == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProblemLog.reportMissingFacet(fid, config.getContributor().getName());
            return;
        }
        ProjectFacetVersion fv = new ProjectFacetVersion();
        fv.setProjectFacet(f);
        fv.setVersionString(ver);
        fv.setPluginId(config.getContributor().getName());
        ArrayList<IConfigurationElement> actions = new ArrayList<IConfigurationElement>();
        fvToActions.put(fv, actions);
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            childName = child.getName();
            if (childName.equals(EL_CONSTRAINT)) {
                fvToConstraint.put(fv, child);
            } else if (childName.equals(EL_GROUP_MEMBER)) {
                String id = child.getAttribute(ATTR_ID);
                if (id == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_ID);
                    return;
                }
                Group group = (Group)this.groups.get(id);
                if (group == null) {
                    group = new Group();
                    group.setId(id);
                    this.groups.add(id, group);
                }
                group.addMember(fv);
            } else if (childName.equals(EL_ACTION)) {
                actions.add(child);
            } else if (childName.equals(EL_PROPERTY)) {
                String name = child.getAttribute(ATTR_NAME);
                if (name == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_NAME);
                } else {
                    String value = child.getAttribute(ATTR_VALUE);
                    if (value == null) {
                        PluginUtil.reportMissingAttribute(child, ATTR_VALUE);
                    } else {
                        fv.setProperty(name, value);
                    }
                }
            }
            ++i;
        }
        f.addVersion(fv);
        i = 0;
        while (i < children.length) {
            child = children[i];
            childName = child.getName();
            if (childName.equals(EL_EVENT_HANDLER)) {
                this.readEventHandler(child, f, ver);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calculateVersionComparisonTables(Map<ProjectFacetVersion, IConfigurationElement> fvToConstraint, Map<ProjectFacetVersion, List<IConfigurationElement>> fvToActions) {
        ArrayList<IProjectFacet> badFacets = new ArrayList<IProjectFacet>();
        for (IProjectFacet f : this.facets) {
            try {
                void var9_12;
                Comparator<String> comp = f.getVersionComparator();
                ArrayList<IProjectFacetVersion> versions = new ArrayList<IProjectFacetVersion>(f.getVersions());
                HashMap compTables = new HashMap();
                for (IProjectFacetVersion iProjectFacetVersion : versions) {
                    compTables.put(iProjectFacetVersion, new HashMap());
                }
                boolean bl = false;
                int n = versions.size();
                while (var9_12 < n) {
                    IProjectFacetVersion iVer = (IProjectFacetVersion)versions.get((int)var9_12);
                    String iVerStr = iVer.getVersionString();
                    Map iCompTable = (Map)compTables.get(iVer);
                    void j = var9_12 + true;
                    while (j < n) {
                        IProjectFacetVersion jVer = (IProjectFacetVersion)versions.get((int)j);
                        String jVerStr = jVer.getVersionString();
                        Map jCompTable = (Map)compTables.get(jVer);
                        int result = comp.compare(iVerStr, jVerStr);
                        iCompTable.put(jVer, new Integer(result));
                        jCompTable.put(iVer, new Integer(result * -1));
                        ++j;
                    }
                    ++var9_12;
                }
                for (Map.Entry entry : compTables.entrySet()) {
                    ProjectFacetVersion fv = (ProjectFacetVersion)entry.getKey();
                    fv.setComparisonTable((Map)entry.getValue());
                }
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
                badFacets.add(f);
            }
        }
        for (IProjectFacet f : badFacets) {
            this.facets.remove(f);
            Category category = (Category)f.getCategory();
            if (category != null) {
                category.removeProjectFacet(f);
            }
            for (IProjectFacetVersion fv : f.getVersions()) {
                fvToConstraint.remove(fv);
                fvToActions.remove(fv);
            }
        }
    }

    private void readDefaultVersionInfo(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null || !this.isProjectFacetDefined(id)) {
            return;
        }
        ProjectFacet f = (ProjectFacet)this.getProjectFacet(id);
        boolean defaultVersionSpecified = false;
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_DEFAULT_VERSION)) {
                String clname = child.getAttribute(ATTR_PROVIDER);
                if (clname != null) {
                    IDefaultVersionProvider defaultVersionProvider = PluginUtil.instantiate(f.getPluginId(), clname, IDefaultVersionProvider.class);
                    if (defaultVersionProvider != null) {
                        f.setDefaultVersionProvider(defaultVersionProvider);
                        defaultVersionSpecified = true;
                    }
                } else {
                    String version = child.getAttribute(ATTR_VERSION);
                    if (version != null) {
                        if (f.hasVersion(version)) {
                            f.setDefaultVersion((IProjectFacetVersion)f.getVersion(version));
                            defaultVersionSpecified = true;
                        } else {
                            ProblemLog.reportMissingFacetVersion(f, version, config.getContributor().getName());
                        }
                    } else {
                        PluginUtil.reportMissingAttribute(config, ATTR_VERSION);
                    }
                }
            }
            ++i;
        }
        if (!defaultVersionSpecified) {
            try {
                f.setDefaultVersion((IProjectFacetVersion)f.getLatestVersion());
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }

    private void readAction(IConfigurationElement config) {
        String fid = config.getAttribute(ATTR_FACET);
        if (fid == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProblemLog.reportMissingFacet(fid, config.getContributor().getName());
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            ver = "*";
        }
        this.readAction(config, f, ver);
    }

    private void readAction(IConfigurationElement config, ProjectFacet f, String version) {
        String pluginId = config.getContributor().getName();
        ActionDefinition def = new ActionDefinition();
        def.setPluginId(pluginId);
        String type = config.getAttribute(ATTR_TYPE);
        if (type == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_TYPE);
            return;
        }
        if (type.equals("runtime-changed")) {
            String msg = NLS.bind((String)Resources.deprecatedRuntimeChangedAction, (Object)pluginId);
            FacetCorePlugin.logWarning(msg, true);
            this.readEventHandler(config, f, version);
            return;
        }
        def.setActionType(IFacetedProject.Action.Type.valueOf(type));
        if (def.getActionType() == null) {
            String msg = String.valueOf(NLS.bind((String)Resources.invalidActionType, (Object)type)) + NLS.bind((String)Resources.usedInPlugin, (Object)pluginId);
            FacetCorePlugin.log(msg);
            return;
        }
        try {
            def.setVersionExpr(new VersionExpr((Object)f, version, pluginId));
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return;
        }
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            String clname;
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_CONFIG_FACTORY)) {
                clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_CLASS);
                    return;
                }
                def.setConfigFactoryClassName(clname);
            } else if (childName.equals(EL_DELEGATE)) {
                clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    PluginUtil.reportMissingAttribute(config, ATTR_CLASS);
                    return;
                }
                def.setDelegateClassName(clname);
            } else if (childName.equals(EL_PROPERTY)) {
                String name = child.getAttribute(ATTR_NAME);
                if (name == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_NAME);
                    return;
                }
                String value = child.getAttribute(ATTR_VALUE);
                if (value == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_VALUE);
                    return;
                }
                Object parsedValue = value;
                if (name.equals("from.versions")) {
                    try {
                        parsedValue = new VersionExpr((Object)f, value, pluginId);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                        return;
                    }
                }
                def.setProperty(name, parsedValue);
            }
            ++i;
        }
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(f.getId());
            buf.append('#');
            buf.append(version);
            buf.append('#');
            buf.append(def.getActionType().name());
            for (Map.Entry<String, Object> entry : def.getProperties().entrySet()) {
                buf.append('#');
                buf.append(entry.getKey());
                buf.append('=');
                buf.append(entry.getValue().toString());
            }
            id = buf.toString();
        }
        def.setId(id);
        if (this.isActionDefined(id)) {
            String msg = NLS.bind((String)Resources.actionAlreadyDefined, (Object)id, (Object)pluginId);
            FacetCorePlugin.logError(msg);
        } else {
            this.actions.add(def.getId(), def);
            f.addActionDefinition(def);
        }
    }

    private void readEventHandler(IConfigurationElement config) {
        String fid = config.getAttribute(ATTR_FACET);
        if (fid == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_FACET);
            return;
        }
        ProjectFacet f = (ProjectFacet)this.facets.get(fid);
        if (f == null) {
            ProblemLog.reportMissingFacet(fid, config.getContributor().getName());
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            ver = "*";
        }
        this.readEventHandler(config, f, ver);
    }

    private void readEventHandler(IConfigurationElement config, ProjectFacet f, String version) {
        VersionExpr vexpr;
        String pluginId = config.getContributor().getName();
        String type = config.getAttribute(ATTR_TYPE);
        if (type == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_TYPE);
            return;
        }
        IFacetedProjectEvent.Type t = type.equals("runtime-changed") || type.equals("RUNTIME_CHANGED") ? IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED : IFacetedProjectEvent.Type.valueOf(type);
        if (t == null) {
            String msg = String.valueOf(NLS.bind((String)Resources.invalidEventHandlerType, (Object)type)) + NLS.bind((String)Resources.usedInPlugin, (Object)pluginId);
            FacetCorePlugin.log(msg);
            return;
        }
        try {
            vexpr = new VersionExpr((Object)f, version, pluginId);
        }
        catch (CoreException e) {
            FacetCorePlugin.log((Exception)((Object)e));
            return;
        }
        String delegateClassName = null;
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_DELEGATE)) {
                String clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    PluginUtil.reportMissingAttribute(config, ATTR_CLASS);
                    return;
                }
                delegateClassName = clname;
            }
            ++i;
        }
        if (delegateClassName == null) {
            PluginUtil.reportMissingElement(config, EL_DELEGATE);
            return;
        }
        LegacyEventHandlerAdapter adapter = new LegacyEventHandlerAdapter(f, vexpr, pluginId, delegateClassName);
        this.addListener(adapter, t);
    }

    private void readConstraint(IConfigurationElement config, ProjectFacetVersion fv) {
        ProblemLog.Policy problemLoggingPolicy = ProblemLog.Policy.createBasedOnIgnoreProblemsAttr(config);
        IConfigurationElement[] ops = config.getChildren();
        ArrayList<IConstraint> parsed = new ArrayList<IConstraint>();
        int j = 0;
        while (j < ops.length) {
            IConstraint op = this.readConstraintHelper(ops[j], fv, problemLoggingPolicy);
            if (op != null) {
                parsed.add(op);
            }
            ++j;
        }
        if (parsed.size() == 1) {
            fv.setConstraint((IConstraint)parsed.get(0));
        } else if (parsed.size() > 1) {
            Constraint and = new Constraint(fv, IConstraint.Type.AND, parsed.toArray());
            fv.setConstraint(and);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IConstraint readConstraintHelper(IConfigurationElement root, ProjectFacetVersion fv, ProblemLog.Policy parentProblemLoggingPolicy) {
        Object[] operands;
        String pluginId = root.getContributor().getName();
        ProblemLog.Policy localProblemLoggingPolicy = ProblemLog.Policy.createBasedOnIgnoreProblemsAttr(root, parentProblemLoggingPolicy);
        IConstraint.Type type = IConstraint.Type.valueOf(root.getName());
        if (type == IConstraint.Type.AND || type == IConstraint.Type.OR) {
            IConfigurationElement[] children = root.getChildren();
            ArrayList<IConstraint> operandsList = new ArrayList<IConstraint>(children.length);
            int i = 0;
            while (i < children.length) {
                IConstraint operand = this.readConstraintHelper(children[i], fv, localProblemLoggingPolicy);
                if (operand != null) {
                    operandsList.add(operand);
                } else if (type == IConstraint.Type.AND) {
                    return null;
                }
                ++i;
            }
            operands = operandsList.toArray();
            return new Constraint(fv, type, operands);
        }
        if (type != IConstraint.Type.REQUIRES && type != IConstraint.Type.CONFLICTS) throw new IllegalStateException();
        String gid = root.getAttribute("group");
        String fid = root.getAttribute(ATTR_FACET);
        String vexprstr = root.getAttribute(ATTR_VERSION);
        String softStr = root.getAttribute(ATTR_SOFT);
        Boolean soft = Boolean.FALSE;
        if (softStr != null && softStr.equals(Boolean.TRUE.toString())) {
            soft = Boolean.TRUE;
        }
        if (gid != null && (fid != null || vexprstr != null)) {
            String template = type == IConstraint.Type.REQUIRES ? Resources.invalidRequiresConstraint : Resources.invalidConflictsConstraint;
            String msg = NLS.bind((String)template, (Object)pluginId);
            FacetCorePlugin.logError(msg, true);
            return null;
        }
        if (gid != null) {
            if (!this.isGroupDefined(gid)) {
                ProblemLog.reportMissingGroup(gid, pluginId, localProblemLoggingPolicy);
                return null;
            }
            IGroup group = this.getGroup(gid);
            operands = type == IConstraint.Type.REQUIRES ? new Object[]{group, soft} : new Object[]{group};
            return new Constraint(fv, type, operands);
        }
        if (fid != null) {
            if (!this.isProjectFacetDefined(fid)) {
                ProblemLog.reportMissingFacet(fid, pluginId, localProblemLoggingPolicy);
                return null;
            }
            IProjectFacet f = this.getProjectFacet(fid);
            VersionExpr vexpr = null;
            try {
                if (vexprstr == null || vexprstr.trim().length() == 0) {
                    vexprstr = "*";
                }
                vexpr = new VersionExpr(f, vexprstr, pluginId);
            }
            catch (CoreException e) {
                FacetCorePlugin.log((Exception)((Object)e));
                return null;
            }
            operands = type == IConstraint.Type.REQUIRES ? new Object[]{f, vexpr, soft} : new Object[]{f, vexpr};
            return new Constraint(fv, type, operands);
        }
        String msg = Resources.bind(Resources.missingOneOfTwoAttributes, pluginId, root.getName(), "group", ATTR_FACET);
        FacetCorePlugin.logError(msg, true);
        return null;
    }

    private void readGroup(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        String id = PluginUtil.findRequiredAttribute(config, ATTR_ID);
        if (!this.isGroupDefined(id)) {
            return;
        }
        Group group = (Group)this.getGroup(id);
        IConfigurationElement elLabel = PluginUtil.findOptionalElement(config, EL_LABEL);
        group.setLabel(PluginUtil.getElementValue(elLabel, group.getId()));
        IConfigurationElement elDesc = PluginUtil.findOptionalElement(config, EL_DESCRIPTION);
        group.setDescription(PluginUtil.getElementValue(elDesc, DEFAULT_DESCRIPTION));
    }

    private static String toString(Collection<? extends Object> collection) {
        StringBuffer buf = new StringBuffer();
        for (Object object : collection) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            if (object instanceof IProjectFacetVersion) {
                IProjectFacetVersion fv = (IProjectFacetVersion)object;
                buf.append(fv.getProjectFacet().getId());
                buf.append(' ');
                buf.append(fv.getVersionString());
                continue;
            }
            buf.append(object.toString());
        }
        return buf.toString();
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void register() {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)this, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            ArrayList<FacetedProject> projectsToRefresh = new ArrayList<FacetedProject>();
            Map map = FacetedProjectFrameworkImpl.this.projects;
            synchronized (map) {
                IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(2);
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta subdelta = iResourceDeltaArray[n2];
                    String pjname = subdelta.getFullPath().segment(0);
                    IFacetedProject fpj = (IFacetedProject)FacetedProjectFrameworkImpl.this.projects.remove(pjname);
                    if (fpj != null) {
                        try {
                            ((FacetedProject)fpj).markDeleted();
                        }
                        catch (CoreException e) {
                            FacetCorePlugin.log((Exception)((Object)e));
                        }
                    }
                    ++n2;
                }
                for (FacetedProject fproj : FacetedProjectFrameworkImpl.this.projects.values()) {
                    IResourceDelta subdelta = delta.findMember(fproj.f.getFullPath());
                    if (subdelta == null) continue;
                    projectsToRefresh.add(fproj);
                }
            }
            for (FacetedProject fproj : projectsToRefresh) {
                try {
                    fproj.refresh();
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)((Object)e));
                }
            }
        }
    }

    public static final class Resources
    extends NLS {
        public static String missingOneOfTwoAttributes;
        public static String categoryNotDefined;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String actionNotDefined;
        public static String actionAlreadyDefined;
        public static String groupNotDefined;
        public static String presetNotDefined;
        public static String templateNotDefined;
        public static String usedInPlugin;
        public static String invalidActionType;
        public static String invalidEventHandlerType;
        public static String invalidRequiresConstraint;
        public static String invalidConflictsConstraint;
        public static String deprecatedRuntimeChangedAction;
        public static String tracingActionSorting;
        public static String tracingFrameworkActivationStarting;
        public static String tracingFrameworkActivationFinished;

        static {
            Resources.initializeMessages((String)FacetedProjectFrameworkImpl.class.getName(), Resources.class);
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

