/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCloud
implements Cloud {
    protected final BugCollection bugCollection;
    CopyOnWriteArraySet<Cloud.CloudListener> listeners = new CopyOnWriteArraySet();

    protected AbstractCloud(BugCollection bugs) {
        this.bugCollection = bugs;
    }

    @Override
    public BugCollection getBugCollection() {
        return this.bugCollection;
    }

    @Override
    public boolean supportsBugLinks() {
        return false;
    }

    @Override
    public boolean supportsClaims() {
        return false;
    }

    @Override
    public boolean supportsCloudReports() {
        return false;
    }

    @Override
    public boolean supportsSourceLinks() {
        return false;
    }

    @Override
    public String claimedBy(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean claim(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getBugLink(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cloud.BugFilingStatus getBugLinkStatus(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCloudReport(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getSourceLink(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourceLinkToolTip(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getUserDate(BugInstance b) {
        return new Date(this.getUserTimestamp(b));
    }

    public boolean hasExistingBugLink(BugInstance b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(Cloud.CloudListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Cloud.CloudListener listener) {
        this.listeners.remove(listener);
    }

    protected void updatedStatus() {
        for (Cloud.CloudListener listener : this.listeners) {
            listener.statusUpdated();
        }
    }

    protected void updatedIssue(BugInstance bug) {
        for (Cloud.CloudListener listener : this.listeners) {
            listener.issueUpdate(bug);
        }
    }

    @Override
    public String getStatusMsg() {
        return "";
    }

    @Override
    public void shutdown() {
    }

    public void printCloudReport(Iterable<BugInstance> bugs, PrintWriter w) {
        w.println("No cloud report available");
    }

    @Override
    public boolean getIWillFix(BugInstance b) {
        return this.getUserDesignation(b) == Cloud.UserDesignation.I_WILL_FIX;
    }

    @Override
    public boolean overallClassificationIsNotAProblem(BugInstance b) {
        return false;
    }

    @Override
    public double getClassificationScore(BugInstance b) {
        return this.getUserDesignation(b).score();
    }

    @Override
    public double getPortionObsoleteClassifications(BugInstance b) {
        if (this.getUserDesignation(b) == Cloud.UserDesignation.OBSOLETE_CODE) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double getClassificationVariance(BugInstance b) {
        return 0.0;
    }

    @Override
    public int getNumberReviewers(BugInstance b) {
        if (this.getUserDesignation(b) == Cloud.UserDesignation.UNCLASSIFIED) {
            return 0;
        }
        return 1;
    }

    @Override
    public void printCloudSummary(PrintWriter w, Iterable<BugInstance> bugs, String[] packagePrefixes) {
    }

    @Override
    public boolean supportsCloudSummaries() {
        return false;
    }

    @Override
    public boolean canStoreUserAnnotation(BugInstance bugInstance) {
        return true;
    }

    @Override
    public double getClassificationDisagreement(BugInstance b) {
        return 0.0;
    }
}

