/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CharMap4J14 {
    static final String ACTION_GOTO_END = "GotoEnd";
    static final String ACTION_GOTO_HOME = "GotoHome";
    static final String ACTION_LINE_DOWN = "LineDown";
    static final String ACTION_LINE_UP = "LineUp";
    static final String ACTION_PAGE_DOWN = "PageDown";
    static final String ACTION_PAGE_UP = "PageUp";
    static final String ACTION_PROGRAM_EXIT = "ProgramExit";
    static final String ACTION_REPORT_HIDE = "ReportHide";
    static final String ACTION_REPORT_SHOW = "ReportShow";
    static final String ACTION_SAMPLE_CLEAR = "SampleClear";
    static final String COPYRIGHT_NOTICE = "Copyright (c) 2008 by Keith Fenske.  Released under GNU Public License.";
    static final String DEFAULT_FILE = "CharMap4.txt";
    static final String DEFAULT_FONT = "Verdana";
    static final int DEFAULT_HEIGHT = 500;
    static final int DEFAULT_LEFT = 50;
    static final int DEFAULT_SIZE = 30;
    static final int DEFAULT_TOP = 50;
    static final int DEFAULT_WIDTH = 700;
    static final String EMPTY_STATUS = " ";
    static final String[] FONT_SIZES = new String[]{"18", "24", "30", "36", "48", "60", "72", "96"};
    static final String LICENSE_FILE = "GnuPublicLicense3.txt";
    static final String LICENSE_NAME = "GNU General Public License (GPL)";
    static final int MAX_SIZE = 999;
    static final int MIN_FRAME = 200;
    static final int MIN_SIZE = 10;
    static final String PROGRAM_TITLE = "Display Characters and Copy to System Clipboard - by: Keith Fenske";
    static final char REPLACE_CHAR = '\ufffd';
    static final String SYSTEM_FONT = "Dialog";
    static final String[] HANGUL_NAME_INITIAL = new String[]{"Kiyeok", "Ssangkiyeok", "Nieun", "Tikeut", "Ssangtikeut", "Rieul", "Mieum", "Pieup", "Ssangpieup", "Sios", "Ssangsios", "Ieung", "Cieuc", "Ssangcieuc", "Chieuch", "Khieukh", "Thieuth", "Phieuph", "Hieuh"};
    static final String[] HANGUL_NAME_MEDIAL = new String[]{"A", "Ae", "Ya", "Yae", "Eo", "E", "Yeo", "Ye", "O", "Wa", "Wae", "Oe", "Yo", "U", "Weo", "We", "Wi", "Yu", "Eu", "Yi", "I"};
    static final String[] HANGUL_NAME_FINAL = new String[]{"", "Kiyeok", "Ssangkiyeok", "Kiyeok-Sios", "Nieun", "Nieun-Cieuc", "Nieun-Hieuh", "Tikeut", "Rieul", "Rieul-Kiyeok", "Rieul-Mieum", "Rieul-Pieup", "Rieul-Sios", "Rieul-Thieuth", "Rieul-Phieuph", "Rieul-Hieuh", "Mieum", "Pieup", "Pieup-Sios", "Sios", "Ssangsios", "Ieung", "Cieuc", "Chieuch", "Khieukh", "Thieuth", "Phieuph", "Hieuh"};
    static final String[] HANGUL_SOUND_INITIAL = new String[]{"G", "KK", "N", "D", "TT", "R", "M", "B", "PP", "S", "SS", "", "J", "JJ", "CH", "K", "T", "P", "H"};
    static final String[] HANGUL_SOUND_MEDIAL = new String[]{"A", "AE", "YA", "YAE", "EO", "E", "YEO", "YE", "O", "WA", "WAE", "OE", "YO", "U", "WO", "WE", "WI", "YU", "EU", "UI", "I"};
    static final String[] HANGUL_SOUND_FINAL = new String[]{"", "K", "KK", "KS", "N", "NJ", "NH", "T", "L", "LK", "LM", "LP", "LS", "LT", "LP", "LH", "M", "P", "PS", "S", "SS", "NG", "J", "CH", "K", "T", "P", "H"};
    static final int MAX_UNICODE = 65535;
    static final int MIN_UNICODE = 0;
    static Font buttonFont;
    static TreeMap captionMap;
    static JButton clearButton;
    static boolean clickReplace;
    static JButton copyButton;
    static String dataFile;
    static Font displayFont;
    static String fontName;
    static int fontSize;
    static NumberFormat formatComma;
    static boolean glyphFlag;
    static CharMap4J14Grid gridPanel;
    static JScrollBar gridScroll;
    static JFrame mainFrame;
    static JButton menuButton;
    static JMenuItem menuChars;
    static JMenuItem menuExit;
    static JMenuItem menuGlyphs;
    static JMenuItem menuReport;
    static JPopupMenu menuPopup;
    static boolean mswinFlag;
    static JComboBox nameDialog;
    static JButton reportCloseButton;
    static JButton reportLicenseButton;
    static JButton reportSummaryButton;
    static JFrame reportDialog;
    static JTextArea reportText;
    static JMenuItem rightCopyCaption;
    static JMenuItem rightCopyGlyph;
    static JMenuItem rightCopyNotation;
    static JMenuItem rightCopyNumber;
    static JMenuItem rightCopyText;
    static JPopupMenu rightPopup;
    static String rightSaveCaption;
    static int rightSaveChar;
    static int rightSaveGlyph;
    static JTextField sampleDialog;
    static JComboBox sizeDialog;
    static JLabel statusDialog;
    static ActionListener userActions;
    static int windowHeight;
    static int windowLeft;
    static int windowTop;
    static int windowWidth;

    public static void main(String[] stringArray) {
        Object object;
        buttonFont = null;
        captionMap = null;
        clickReplace = false;
        dataFile = DEFAULT_FILE;
        displayFont = null;
        fontName = DEFAULT_FONT;
        fontSize = 30;
        glyphFlag = false;
        gridPanel = null;
        mainFrame = null;
        boolean bl = false;
        mswinFlag = System.getProperty("os.name").startsWith("Windows");
        reportDialog = null;
        String string = "";
        windowHeight = 500;
        windowLeft = 50;
        windowTop = 50;
        windowWidth = 700;
        formatComma = NumberFormat.getInstance();
        formatComma.setGroupingUsed(true);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].toLowerCase();
            if (string2.length() == 0) continue;
            if (string2.equals("?") || string2.equals("-?") || string2.equals("/?") || string2.equals("-h") || mswinFlag && string2.equals("/h") || string2.equals("-help") || mswinFlag && string2.equals("/help")) {
                CharMap4J14.showHelp();
                System.exit(0);
                continue;
            }
            if (string2.equals("-c") || mswinFlag && string2.equals("/c") || string2.equals("-c1") || mswinFlag && string2.equals("/c1")) {
                clickReplace = true;
                continue;
            }
            if (string2.equals("-c0") || mswinFlag && string2.equals("/c0")) {
                clickReplace = false;
                continue;
            }
            if (string2.startsWith("-d") || mswinFlag && string2.startsWith("/d")) {
                dataFile = stringArray[i].substring(2);
                continue;
            }
            if (string2.startsWith("-f") || mswinFlag && string2.startsWith("/f")) {
                CharMap4J14.setFontName(stringArray[i].substring(2));
                continue;
            }
            if (string2.startsWith("-s") || mswinFlag && string2.startsWith("/s")) {
                CharMap4J14.setPointSize(stringArray[i].substring(2));
                continue;
            }
            if (string2.startsWith("-u") || mswinFlag && string2.startsWith("/u")) {
                int n = -1;
                try {
                    n = Integer.parseInt(string2.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n < 10 || n > 99) {
                    System.err.println("Dialog font size must be from 10 to 99: " + stringArray[i]);
                    CharMap4J14.showHelp();
                    System.exit(-1);
                }
                buttonFont = new Font(SYSTEM_FONT, 0, n);
                continue;
            }
            if (string2.startsWith("-w") || mswinFlag && string2.startsWith("/w")) {
                Pattern pattern = Pattern.compile("\\s*\\(\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*\\)\\s*");
                object = pattern.matcher(string2.substring(2));
                if (((Matcher)object).matches()) {
                    windowLeft = Integer.parseInt(((Matcher)object).group(1));
                    windowTop = Integer.parseInt(((Matcher)object).group(2));
                    windowWidth = Integer.parseInt(((Matcher)object).group(3));
                    windowHeight = Integer.parseInt(((Matcher)object).group(4));
                } else {
                    windowWidth = -1;
                    windowTop = -1;
                    windowLeft = -1;
                    windowHeight = -1;
                }
                if (windowHeight >= 200 && windowWidth >= 200) continue;
                System.err.println("Invalid window position or size: " + stringArray[i]);
                CharMap4J14.showHelp();
                System.exit(-1);
                continue;
            }
            if (string2.equals("-x") || mswinFlag && string2.equals("/x")) {
                bl = true;
                continue;
            }
            if (string2.startsWith("-") || mswinFlag && string2.startsWith("/")) {
                System.err.println("Option not recognized: " + stringArray[i]);
                CharMap4J14.showHelp();
                System.exit(-1);
                continue;
            }
            if (string.length() > 0) {
                string = string + ' ';
            }
            string = string + stringArray[i];
        }
        CharMap4J14.setFontName(fontName);
        userActions = new CharMap4J14User(null);
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        object = new JPanel(new FlowLayout(0, 0, 0));
        menuButton = new JButton("Menu");
        menuButton.addActionListener(userActions);
        if (buttonFont != null) {
            menuButton.setFont(buttonFont);
        }
        menuButton.setMnemonic(77);
        menuButton.setToolTipText("Select characters or glyphs, close program.");
        ((Container)object).add(menuButton);
        ((Container)object).add(Box.createHorizontalStrut(10));
        nameDialog = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        nameDialog.setEditable(true);
        if (buttonFont != null) {
            nameDialog.setFont(buttonFont);
        }
        nameDialog.setSelectedItem(fontName);
        nameDialog.setToolTipText("Font name for display text.");
        nameDialog.addActionListener(userActions);
        ((Container)object).add(nameDialog);
        ((Container)object).add(Box.createHorizontalStrut(10));
        sizeDialog = new JComboBox<String>(FONT_SIZES);
        sizeDialog.setEditable(false);
        if (buttonFont != null) {
            sizeDialog.setFont(buttonFont);
        }
        sizeDialog.setPrototypeDisplayValue("9999");
        sizeDialog.setToolTipText("Point size for display text.");
        ((Container)object).add(sizeDialog);
        jPanel.add((Component)object, "West");
        statusDialog = new JLabel(EMPTY_STATUS, 0);
        if (buttonFont != null) {
            statusDialog.setFont(buttonFont);
        }
        jPanel.add((Component)statusDialog, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add(Box.createVerticalStrut(5), "North");
        jPanel2.add(Box.createHorizontalStrut(10), "West");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add(Box.createHorizontalStrut(10), "East");
        jPanel2.add(Box.createVerticalStrut(5), "South");
        menuPopup = new JPopupMenu();
        menuReport = new JMenuItem("About, Help");
        menuReport.addActionListener(userActions);
        if (buttonFont != null) {
            menuReport.setFont(buttonFont);
        }
        menuPopup.add(menuReport);
        menuPopup.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        menuChars = new JRadioButtonMenuItem("Characters", !glyphFlag);
        menuChars.addActionListener(userActions);
        if (buttonFont != null) {
            menuChars.setFont(buttonFont);
        }
        buttonGroup.add(menuChars);
        menuPopup.add(menuChars);
        menuGlyphs = new JRadioButtonMenuItem("Glyphs", glyphFlag);
        menuGlyphs.addActionListener(userActions);
        if (buttonFont != null) {
            menuGlyphs.setFont(buttonFont);
        }
        buttonGroup.add(menuGlyphs);
        menuPopup.add(menuGlyphs);
        menuPopup.addSeparator();
        menuExit = new JMenuItem("Exit");
        menuExit.addActionListener(userActions);
        if (buttonFont != null) {
            menuExit.setFont(buttonFont);
        }
        menuExit.setMnemonic(88);
        menuPopup.add(menuExit);
        rightPopup = new JPopupMenu();
        rightCopyCaption = new JMenuItem("Caption Text");
        rightCopyCaption.addActionListener(userActions);
        if (buttonFont != null) {
            rightCopyCaption.setFont(buttonFont);
        }
        rightPopup.add(rightCopyCaption);
        rightCopyNumber = new JMenuItem("Character Number");
        rightCopyNumber.addActionListener(userActions);
        if (buttonFont != null) {
            rightCopyNumber.setFont(buttonFont);
        }
        rightPopup.add(rightCopyNumber);
        rightCopyText = new JMenuItem("Character Text");
        rightCopyText.addActionListener(userActions);
        if (buttonFont != null) {
            rightCopyText.setFont(buttonFont);
        }
        rightPopup.add(rightCopyText);
        rightCopyGlyph = new JMenuItem("Glyph Number");
        rightCopyGlyph.addActionListener(userActions);
        if (buttonFont != null) {
            rightCopyGlyph.setFont(buttonFont);
        }
        rightPopup.add(rightCopyGlyph);
        rightCopyNotation = new JMenuItem("Unicode Notation");
        rightCopyNotation.addActionListener(userActions);
        if (buttonFont != null) {
            rightCopyNotation.setFont(buttonFont);
        }
        rightPopup.add(rightCopyNotation);
        gridPanel = new CharMap4J14Grid();
        gridPanel.setFocusable(true);
        gridScroll = new JScrollBar(1, 0, 1, 0, 1);
        gridScroll.addMouseWheelListener(gridPanel);
        gridScroll.setEnabled(true);
        gridScroll.setFocusable(true);
        gridScroll.getModel().addChangeListener(gridPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        clearButton = new JButton("Clear");
        clearButton.addActionListener(userActions);
        if (buttonFont != null) {
            clearButton.setFont(buttonFont);
        }
        clearButton.setMnemonic(67);
        clearButton.setToolTipText("Clear all sample text.");
        jPanel3.add((Component)clearButton, "West");
        sampleDialog = new JTextField(string);
        sampleDialog.addActionListener(userActions);
        sampleDialog.setFont(displayFont);
        sampleDialog.setMargin(new Insets(1, 5, 2, 5));
        jPanel3.add((Component)sampleDialog, "Center");
        copyButton = new JButton("Copy All");
        copyButton.addActionListener(userActions);
        if (buttonFont != null) {
            copyButton.setFont(buttonFont);
        }
        copyButton.setMnemonic(65);
        copyButton.setToolTipText("Copy all sample text to clipboard.");
        jPanel3.add((Component)copyButton, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.add(Box.createVerticalStrut(5), "North");
        jPanel4.add(Box.createHorizontalStrut(10), "West");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add(Box.createHorizontalStrut(10), "East");
        jPanel4.add(Box.createVerticalStrut(5), "South");
        mainFrame = new JFrame(PROGRAM_TITLE);
        JPanel jPanel5 = (JPanel)mainFrame.getContentPane();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, "North");
        jPanel5.add((Component)gridPanel, "Center");
        jPanel5.add((Component)gridScroll, "East");
        if (!clickReplace) {
            jPanel5.add((Component)jPanel4, "South");
        }
        mainFrame.setDefaultCloseOperation(3);
        if (bl) {
            mainFrame.setExtendedState(6);
        }
        mainFrame.setLocation(windowLeft, windowTop);
        mainFrame.setSize(windowWidth, windowHeight);
        mainFrame.validate();
        mainFrame.setVisible(true);
        sizeDialog.setMaximumSize(sizeDialog.getPreferredSize());
        sizeDialog.setEditable(true);
        sizeDialog.setSelectedItem(String.valueOf(fontSize));
        sizeDialog.addActionListener(userActions);
        InputMap inputMap = jPanel5.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(40, 2), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(35, 0), ACTION_GOTO_END);
        inputMap.put(KeyStroke.getKeyStroke(35, 2), ACTION_GOTO_END);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), ACTION_SAMPLE_CLEAR);
        inputMap.put(KeyStroke.getKeyStroke(112, 0), ACTION_REPORT_SHOW);
        inputMap.put(KeyStroke.getKeyStroke(72, 8), ACTION_REPORT_SHOW);
        inputMap.put(KeyStroke.getKeyStroke(36, 0), ACTION_GOTO_HOME);
        inputMap.put(KeyStroke.getKeyStroke(36, 2), ACTION_GOTO_HOME);
        inputMap.put(KeyStroke.getKeyStroke(225, 0), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(225, 2), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(226, 0), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(226, 2), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(227, 0), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(227, 2), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(224, 0), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(224, 2), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(37, 2), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(34, 0), ACTION_PAGE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(34, 2), ACTION_PAGE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(33, 0), ACTION_PAGE_UP);
        inputMap.put(KeyStroke.getKeyStroke(33, 2), ACTION_PAGE_UP);
        inputMap.put(KeyStroke.getKeyStroke(82, 8), ACTION_REPORT_SHOW);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(39, 2), ACTION_LINE_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(38, 2), ACTION_LINE_UP);
        inputMap.put(KeyStroke.getKeyStroke(88, 8), ACTION_PROGRAM_EXIT);
        ActionMap actionMap = jPanel5.getActionMap();
        actionMap.put(ACTION_GOTO_END, new CharMap4J14User(ACTION_GOTO_END));
        actionMap.put(ACTION_GOTO_HOME, new CharMap4J14User(ACTION_GOTO_HOME));
        actionMap.put(ACTION_LINE_DOWN, new CharMap4J14User(ACTION_LINE_DOWN));
        actionMap.put(ACTION_LINE_UP, new CharMap4J14User(ACTION_LINE_UP));
        actionMap.put(ACTION_PAGE_DOWN, new CharMap4J14User(ACTION_PAGE_DOWN));
        actionMap.put(ACTION_PAGE_UP, new CharMap4J14User(ACTION_PAGE_UP));
        actionMap.put(ACTION_PROGRAM_EXIT, new CharMap4J14User(ACTION_PROGRAM_EXIT));
        actionMap.put(ACTION_REPORT_SHOW, new CharMap4J14User(ACTION_REPORT_SHOW));
        actionMap.put(ACTION_SAMPLE_CLEAR, new CharMap4J14User(ACTION_SAMPLE_CLEAR));
        Thread thread = new Thread((Runnable)((Object)userActions), "loadConfig");
        thread.setPriority(1);
        thread.start();
        if (string.length() > 0) {
            CharMap4J14.copyText();
            sampleDialog.select(999999999, 999999999);
        }
        sampleDialog.requestFocusInWindow();
    }

    static String captionGet(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CharMap4J14.unicodeNotation(n));
        stringBuffer.append(" = ");
        String string = captionMap == null ? null : (String)captionMap.get(new Integer(n));
        if (string == null) {
            string = n >= 0 && n <= 127 ? "Basic Latin" : (n >= 128 && n <= 255 ? "Latin-1 Supplement" : (n >= 256 && n <= 383 ? "Latin Extended-A" : (n >= 384 && n <= 591 ? "Latin Extended-B" : (n >= 592 && n <= 687 ? "IPA Extensions" : (n >= 688 && n <= 767 ? "Spacing Modifier Letters" : (n >= 768 && n <= 879 ? "Combining Diacritical Marks" : (n >= 880 && n <= 1023 ? "Greek and Coptic" : (n >= 1024 && n <= 1279 ? "Cyrillic" : (n >= 1280 && n <= 1327 ? "Cyrillic Supplement" : (n >= 1328 && n <= 1423 ? "Armenian" : (n >= 1424 && n <= 1535 ? "Hebrew" : (n >= 1536 && n <= 1791 ? "Arabic" : (n >= 1792 && n <= 1871 ? "Syriac" : (n >= 1872 && n <= 1919 ? "Arabic Supplement" : (n >= 1920 && n <= 1983 ? "Thaana" : (n >= 1984 && n <= 2047 ? "NKo" : (n >= 2304 && n <= 2431 ? "Devanagari" : (n >= 2432 && n <= 2559 ? "Bengali" : (n >= 2560 && n <= 2687 ? "Gurmukhi" : (n >= 2688 && n <= 2815 ? "Gujarati" : (n >= 2816 && n <= 2943 ? "Oriya" : (n >= 2944 && n <= 3071 ? "Tamil" : (n >= 3072 && n <= 3199 ? "Telugu" : (n >= 3200 && n <= 3327 ? "Kannada" : (n >= 3328 && n <= 3455 ? "Malayalam" : (n >= 3456 && n <= 3583 ? "Sinhala" : (n >= 3584 && n <= 3711 ? "Thai" : (n >= 3712 && n <= 3839 ? "Lao" : (n >= 3840 && n <= 4095 ? "Tibetan" : (n >= 4096 && n <= 4255 ? "Myanmar" : (n >= 4256 && n <= 4351 ? "Georgian" : (n >= 4352 && n <= 4607 ? "Hangul Jamo" : (n >= 4608 && n <= 4991 ? "Ethiopic" : (n >= 4992 && n <= 5023 ? "Ethiopic Supplement" : (n >= 5024 && n <= 5119 ? "Cherokee" : (n >= 5120 && n <= 5759 ? "Unified Canadian Aboriginal Syllabics" : (n >= 5760 && n <= 5791 ? "Ogham" : (n >= 5792 && n <= 5887 ? "Runic" : (n >= 5888 && n <= 5919 ? "Tagalog" : (n >= 5920 && n <= 5951 ? "Hanunoo" : (n >= 5952 && n <= 5983 ? "Buhid" : (n >= 5984 && n <= 6015 ? "Tagbanwa" : (n >= 6016 && n <= 6143 ? "Khmer" : (n >= 6144 && n <= 6319 ? "Mongolian" : (n >= 6400 && n <= 6479 ? "Limbu" : (n >= 6480 && n <= 6527 ? "Tai Le" : (n >= 6528 && n <= 6623 ? "New Tai Lue" : (n >= 6624 && n <= 6655 ? "Khmer Symbols" : (n >= 6656 && n <= 6687 ? "Buginese" : (n >= 6912 && n <= 7039 ? "Balinese" : (n >= 7040 && n <= 7103 ? "Sundanese" : (n >= 7168 && n <= 7247 ? "Lepcha" : (n >= 7248 && n <= 7295 ? "Ol Chiki" : (n >= 7424 && n <= 7551 ? "Phonetic Extensions" : (n >= 7552 && n <= 7615 ? "Phonetic Extensions Supplement" : (n >= 7616 && n <= 7679 ? "Combining Diacritical Marks Supplement" : (n >= 7680 && n <= 7935 ? "Latin Extended Additional" : (n >= 7936 && n <= 8191 ? "Greek Extended" : (n >= 8192 && n <= 8303 ? "General Punctuation" : (n >= 8304 && n <= 8351 ? "Superscripts and Subscripts" : (n >= 8352 && n <= 8399 ? "Currency Symbols" : (n >= 8400 && n <= 8447 ? "Combining Diacritical Marks for Symbols" : (n >= 8448 && n <= 8527 ? "Letterlike Symbols" : (n >= 8528 && n <= 8591 ? "Number Forms" : (n >= 8592 && n <= 8703 ? "Arrows" : (n >= 8704 && n <= 8959 ? "Mathematical Operators" : (n >= 8960 && n <= 9215 ? "Miscellaneous Technical" : (n >= 9216 && n <= 9279 ? "Control Pictures" : (n >= 9280 && n <= 9311 ? "Optical Character Recognition" : (n >= 9312 && n <= 9471 ? "Enclosed Alphanumerics" : (n >= 9472 && n <= 9599 ? "Box Drawing" : (n >= 9600 && n <= 9631 ? "Block Elements" : (n >= 9632 && n <= 9727 ? "Geometric Shapes" : (n >= 9728 && n <= 9983 ? "Miscellaneous Symbols" : (n >= 9984 && n <= 10175 ? "Dingbats" : (n >= 10176 && n <= 10223 ? "Miscellaneous Mathematical Symbols-A" : (n >= 10224 && n <= 10239 ? "Supplemental Arrows-A" : (n >= 10240 && n <= 10495 ? "Braille Patterns" : (n >= 10496 && n <= 10623 ? "Supplemental Arrows-B" : (n >= 10624 && n <= 10751 ? "Miscellaneous Mathematical Symbols-B" : (n >= 10752 && n <= 11007 ? "Supplemental Mathematical Operators" : (n >= 11008 && n <= 11263 ? "Miscellaneous Symbols and Arrows" : (n >= 11264 && n <= 11359 ? "Glagolitic" : (n >= 11360 && n <= 11391 ? "Latin Extended-C" : (n >= 11392 && n <= 11519 ? "Coptic" : (n >= 11520 && n <= 11567 ? "Georgian Supplement" : (n >= 11568 && n <= 11647 ? "Tifinagh" : (n >= 11648 && n <= 11743 ? "Ethiopic Extended" : (n >= 11744 && n <= 11775 ? "Cyrillic Extended-A" : (n >= 11776 && n <= 11903 ? "Supplemental Punctuation" : (n >= 11904 && n <= 12031 ? "CJK Radicals Supplement" : (n >= 12032 && n <= 12255 ? "Kangxi Radicals" : (n >= 12272 && n <= 12287 ? "Ideographic Description Characters" : (n >= 12288 && n <= 12351 ? "CJK Symbols and Punctuation" : (n >= 12352 && n <= 12447 ? "Hiragana" : (n >= 12448 && n <= 12543 ? "Katakana" : (n >= 12544 && n <= 12591 ? "Bopomofo" : (n >= 12592 && n <= 12687 ? "Hangul Compatibility Jamo" : (n >= 12688 && n <= 12703 ? "Kanbun" : (n >= 12704 && n <= 12735 ? "Bopomofo Extended" : (n >= 12736 && n <= 12783 ? "CJK Strokes" : (n >= 12784 && n <= 12799 ? "Katakana Phonetic Extensions" : (n >= 12800 && n <= 13055 ? "Enclosed CJK Letters and Months" : (n >= 13056 && n <= 13311 ? "CJK Compatibility" : (n >= 13312 && n <= 19903 ? "CJK Unified Ideographs Extension A" : (n >= 19904 && n <= 19967 ? "Yijing Hexagram Symbols" : (n >= 19968 && n <= 40959 ? "CJK Unified Ideographs" : (n >= 40960 && n <= 42127 ? "Yi Syllables" : (n >= 42128 && n <= 42191 ? "Yi Radicals" : (n >= 42240 && n <= 42559 ? "Vai" : (n >= 42560 && n <= 42655 ? "Cyrillic Extended-B" : (n >= 42752 && n <= 42783 ? "Modifier Tone Letters" : (n >= 42784 && n <= 43007 ? "Latin Extended-D" : (n >= 43008 && n <= 43055 ? "Syloti Nagri" : (n >= 43072 && n <= 43135 ? "Phags-pa" : (n >= 43136 && n <= 43231 ? "Saurashtra" : (n >= 43264 && n <= 43311 ? "Kayah Li" : (n >= 43312 && n <= 43359 ? "Rejang" : (n >= 43520 && n <= 43615 ? "Cham" : (n >= 44032 && n <= 55215 ? "Hangul Syllables" : (n >= 55296 && n <= 56191 ? "High Surrogates" : (n >= 56192 && n <= 56319 ? "High Private Use Surrogates" : (n >= 56320 && n <= 57343 ? "Low Surrogates" : (n >= 57344 && n <= 63743 ? "Private Use Area" : (n >= 63744 && n <= 64255 ? "CJK Compatibility Ideographs" : (n >= 64256 && n <= 64335 ? "Alphabetic Presentation Forms" : (n >= 64336 && n <= 65023 ? "Arabic Presentation Forms-A" : (n >= 65024 && n <= 65039 ? "Variation Selectors" : (n >= 65040 && n <= 65055 ? "Vertical Forms" : (n >= 65056 && n <= 65071 ? "Combining Half Marks" : (n >= 65072 && n <= 65103 ? "CJK Compatibility Forms" : (n >= 65104 && n <= 65135 ? "Small Form Variants" : (n >= 65136 && n <= 65279 ? "Arabic Presentation Forms-B" : (n >= 65280 && n <= 65519 ? "Halfwidth and Fullwidth Forms" : (n >= 65520 && n <= 65535 ? "Specials" : (n >= 65536 && n <= 65663 ? "Linear B Syllabary" : (n >= 65664 && n <= 65791 ? "Linear B Ideograms" : (n >= 65792 && n <= 65855 ? "Aegean Numbers" : (n >= 65856 && n <= 65935 ? "Ancient Greek Numbers" : (n >= 65936 && n <= 65999 ? "Ancient Symbols" : (n >= 66000 && n <= 66047 ? "Phaistos Disc" : (n >= 66176 && n <= 66207 ? "Lycian" : (n >= 66208 && n <= 66271 ? "Carian" : (n >= 66304 && n <= 66351 ? "Old Italic" : (n >= 66352 && n <= 66383 ? "Gothic" : (n >= 66432 && n <= 66463 ? "Ugaritic" : (n >= 66464 && n <= 66527 ? "Old Persian" : (n >= 66560 && n <= 66639 ? "Deseret" : (n >= 66640 && n <= 66687 ? "Shavian" : (n >= 66688 && n <= 66735 ? "Osmanya" : (n >= 67584 && n <= 67647 ? "Cypriot Syllabary" : (n >= 67840 && n <= 67871 ? "Phoenician" : (n >= 67872 && n <= 67903 ? "Lydian" : (n >= 68096 && n <= 68191 ? "Kharoshthi" : (n >= 73728 && n <= 74751 ? "Cuneiform" : (n >= 74752 && n <= 74879 ? "Cuneiform Numbers and Punctuation" : (n >= 118784 && n <= 119039 ? "Byzantine Musical Symbols" : (n >= 119040 && n <= 119295 ? "Musical Symbols" : (n >= 119296 && n <= 119375 ? "Ancient Greek Musical Notation" : (n >= 119552 && n <= 119647 ? "Tai Xuan Jing Symbols" : (n >= 119648 && n <= 119679 ? "Counting Rod Numerals" : (n >= 119808 && n <= 120831 ? "Mathematical Alphanumeric Symbols" : (n >= 126976 && n <= 127023 ? "Mahjong Tiles" : (n >= 127024 && n <= 127135 ? "Domino Tiles" : (n >= 131072 && n <= 173791 ? "CJK Unified Ideographs Extension B" : (n >= 194560 && n <= 195103 ? "CJK Compatibility Ideographs Supplement" : (n >= 917504 && n <= 917631 ? "Tags" : (n >= 917760 && n <= 917999 ? "Variation Selectors Supplement" : (n >= 983040 && n <= 1048575 ? "Supplementary Private Use Area-A" : (n >= 0x100000 && n <= 0x10FFFF ? "Supplementary Private Use Area-B" : "decimal " + formatComma.format(n)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static void captionPut(int n, String string) {
        captionMap.put(new Integer(n), string);
    }

    static String charToString(int n) {
        return String.valueOf((char)n);
    }

    static void copyText() {
        int n = sampleDialog.getSelectionEnd();
        int n2 = sampleDialog.getSelectionStart();
        sampleDialog.selectAll();
        sampleDialog.copy();
        sampleDialog.select(n2, n);
    }

    static void loadConfig() {
        String string;
        String string2;
        int n;
        Pattern pattern = Pattern.compile("^\\s*(\\w+)\\s*=\\s*(.*\\S)\\s*$");
        captionMap = new TreeMap();
        Pattern pattern2 = Pattern.compile("^\\s*[Uu]\\+([0-9A-Fa-f]+)\\s*=\\s*(.*\\S)\\s*$");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), "UTF-8"));
            bufferedReader.mark(4);
            n = bufferedReader.read();
            if (n >= 0 && n != 65279 && n != 65534) {
                bufferedReader.reset();
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                int n2 = string2.length();
                for (n = 0; n < n2 && Character.isWhitespace(string2.charAt(n)); ++n) {
                }
                if (n >= n2 || string2.charAt(n) == '#') continue;
                Matcher matcher = pattern2.matcher(string2);
                if (matcher.matches()) {
                    try {
                        n = Integer.parseInt(matcher.group(1), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = -1;
                    }
                    if (n >= 0 && n <= 0x10FFFF) {
                        CharMap4J14.captionPut(n, matcher.group(2));
                        continue;
                    }
                    System.err.println("Unicode number out of range: " + string2);
                    continue;
                }
                matcher = pattern.matcher(string2);
                if (matcher.matches()) {
                    String string3 = matcher.group(1).toLowerCase();
                    string = matcher.group(2);
                    if (string3.equals("aboutmenu")) {
                        menuReport.setText(string);
                        continue;
                    }
                    if (string3.equals("charmenu")) {
                        menuChars.setText(string);
                        continue;
                    }
                    if (string3.equals("clearbutton")) {
                        clearButton.setText(string);
                        continue;
                    }
                    if (string3.equals("clearcaption")) {
                        clearButton.setToolTipText(string);
                        continue;
                    }
                    if (string3.equals("copybutton")) {
                        copyButton.setText(string);
                        continue;
                    }
                    if (string3.equals("copycaption")) {
                        copyButton.setToolTipText(string);
                        continue;
                    }
                    if (string3.equals("exitmenu")) {
                        menuExit.setText(string);
                        continue;
                    }
                    if (string3.equals("fontcaption")) {
                        nameDialog.setToolTipText(string);
                        continue;
                    }
                    if (string3.equals("glyphmenu")) {
                        menuGlyphs.setText(string);
                        continue;
                    }
                    if (string3.equals("menubutton")) {
                        menuButton.setText(string);
                        continue;
                    }
                    if (string3.equals("menucaption")) {
                        menuButton.setToolTipText(string);
                        continue;
                    }
                    if (string3.equals("programtitle")) {
                        mainFrame.setTitle(string);
                        continue;
                    }
                    if (string3.equals("rightcaption")) {
                        rightCopyCaption.setText(string);
                        continue;
                    }
                    if (string3.equals("rightglyph")) {
                        rightCopyGlyph.setText(string);
                        continue;
                    }
                    if (string3.equals("rightnotation")) {
                        rightCopyNotation.setText(string);
                        continue;
                    }
                    if (string3.equals("rightnumber")) {
                        rightCopyNumber.setText(string);
                        continue;
                    }
                    if (string3.equals("righttext")) {
                        rightCopyText.setText(string);
                        continue;
                    }
                    if (string3.equals("sizecaption")) {
                        sizeDialog.setToolTipText(string);
                        continue;
                    }
                    System.err.println("Unknown button or menu name: " + string2);
                    continue;
                }
                System.err.println("Unknown configuration command: " + string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!dataFile.equals(DEFAULT_FILE)) {
                System.err.println("Configuration data file not found: " + dataFile);
                System.err.println("in current working directory " + System.getProperty("user.dir"));
            }
            CharMap4J14.captionPut(32, "Space");
            CharMap4J14.captionPut(33, "Exclamation Mark");
            CharMap4J14.captionPut(34, "Quotation Mark");
            CharMap4J14.captionPut(35, "Number Sign");
            CharMap4J14.captionPut(36, "Dollar Sign");
            CharMap4J14.captionPut(37, "Percent Sign");
            CharMap4J14.captionPut(38, "Ampersand");
            CharMap4J14.captionPut(39, "Apostrophe");
            CharMap4J14.captionPut(40, "Left Parenthesis");
            CharMap4J14.captionPut(41, "Right Parenthesis");
            CharMap4J14.captionPut(42, "Asterisk");
            CharMap4J14.captionPut(43, "Plus Sign");
            CharMap4J14.captionPut(44, "Comma");
            CharMap4J14.captionPut(45, "Hyphen-Minus");
            CharMap4J14.captionPut(46, "Full Stop");
            CharMap4J14.captionPut(47, "Solidus");
            CharMap4J14.captionPut(48, "Digit Zero");
            CharMap4J14.captionPut(49, "Digit One");
            CharMap4J14.captionPut(50, "Digit Two");
            CharMap4J14.captionPut(51, "Digit Three");
            CharMap4J14.captionPut(52, "Digit Four");
            CharMap4J14.captionPut(53, "Digit Five");
            CharMap4J14.captionPut(54, "Digit Six");
            CharMap4J14.captionPut(55, "Digit Seven");
            CharMap4J14.captionPut(56, "Digit Eight");
            CharMap4J14.captionPut(57, "Digit Nine");
            CharMap4J14.captionPut(58, "Colon");
            CharMap4J14.captionPut(59, "Semicolon");
            CharMap4J14.captionPut(60, "Less-Than Sign");
            CharMap4J14.captionPut(61, "Equals Sign");
            CharMap4J14.captionPut(62, "Greater-Than Sign");
            CharMap4J14.captionPut(63, "Question Mark");
            CharMap4J14.captionPut(64, "Commercial At");
            CharMap4J14.captionPut(65, "Latin Capital Letter A");
            CharMap4J14.captionPut(66, "Latin Capital Letter B");
            CharMap4J14.captionPut(67, "Latin Capital Letter C");
            CharMap4J14.captionPut(68, "Latin Capital Letter D");
            CharMap4J14.captionPut(69, "Latin Capital Letter E");
            CharMap4J14.captionPut(70, "Latin Capital Letter F");
            CharMap4J14.captionPut(71, "Latin Capital Letter G");
            CharMap4J14.captionPut(72, "Latin Capital Letter H");
            CharMap4J14.captionPut(73, "Latin Capital Letter I");
            CharMap4J14.captionPut(74, "Latin Capital Letter J");
            CharMap4J14.captionPut(75, "Latin Capital Letter K");
            CharMap4J14.captionPut(76, "Latin Capital Letter L");
            CharMap4J14.captionPut(77, "Latin Capital Letter M");
            CharMap4J14.captionPut(78, "Latin Capital Letter N");
            CharMap4J14.captionPut(79, "Latin Capital Letter O");
            CharMap4J14.captionPut(80, "Latin Capital Letter P");
            CharMap4J14.captionPut(81, "Latin Capital Letter Q");
            CharMap4J14.captionPut(82, "Latin Capital Letter R");
            CharMap4J14.captionPut(83, "Latin Capital Letter S");
            CharMap4J14.captionPut(84, "Latin Capital Letter T");
            CharMap4J14.captionPut(85, "Latin Capital Letter U");
            CharMap4J14.captionPut(86, "Latin Capital Letter V");
            CharMap4J14.captionPut(87, "Latin Capital Letter W");
            CharMap4J14.captionPut(88, "Latin Capital Letter X");
            CharMap4J14.captionPut(89, "Latin Capital Letter Y");
            CharMap4J14.captionPut(90, "Latin Capital Letter Z");
            CharMap4J14.captionPut(91, "Left Square Bracket");
            CharMap4J14.captionPut(92, "Reverse Solidus");
            CharMap4J14.captionPut(93, "Right Square Bracket");
            CharMap4J14.captionPut(94, "Circumflex Accent");
            CharMap4J14.captionPut(95, "Low Line");
            CharMap4J14.captionPut(96, "Grave Accent");
            CharMap4J14.captionPut(97, "Latin Small Letter A");
            CharMap4J14.captionPut(98, "Latin Small Letter B");
            CharMap4J14.captionPut(99, "Latin Small Letter C");
            CharMap4J14.captionPut(100, "Latin Small Letter D");
            CharMap4J14.captionPut(101, "Latin Small Letter E");
            CharMap4J14.captionPut(102, "Latin Small Letter F");
            CharMap4J14.captionPut(103, "Latin Small Letter G");
            CharMap4J14.captionPut(104, "Latin Small Letter H");
            CharMap4J14.captionPut(105, "Latin Small Letter I");
            CharMap4J14.captionPut(106, "Latin Small Letter J");
            CharMap4J14.captionPut(107, "Latin Small Letter K");
            CharMap4J14.captionPut(108, "Latin Small Letter L");
            CharMap4J14.captionPut(109, "Latin Small Letter M");
            CharMap4J14.captionPut(110, "Latin Small Letter N");
            CharMap4J14.captionPut(111, "Latin Small Letter O");
            CharMap4J14.captionPut(112, "Latin Small Letter P");
            CharMap4J14.captionPut(113, "Latin Small Letter Q");
            CharMap4J14.captionPut(114, "Latin Small Letter R");
            CharMap4J14.captionPut(115, "Latin Small Letter S");
            CharMap4J14.captionPut(116, "Latin Small Letter T");
            CharMap4J14.captionPut(117, "Latin Small Letter U");
            CharMap4J14.captionPut(118, "Latin Small Letter V");
            CharMap4J14.captionPut(119, "Latin Small Letter W");
            CharMap4J14.captionPut(120, "Latin Small Letter X");
            CharMap4J14.captionPut(121, "Latin Small Letter Y");
            CharMap4J14.captionPut(122, "Latin Small Letter Z");
            CharMap4J14.captionPut(123, "Left Curly Bracket");
            CharMap4J14.captionPut(124, "Vertical Line");
            CharMap4J14.captionPut(125, "Right Curly Bracket");
            CharMap4J14.captionPut(126, "Tilde");
        }
        catch (IOException iOException) {
            System.err.println("Unable to read configuration data from file " + dataFile);
            System.err.println("in current working directory " + System.getProperty("user.dir"));
            System.err.println(iOException.getMessage());
        }
        if (mswinFlag) {
            byte[] byArray = new byte[1];
            for (n = 32; n <= 255; ++n) {
                char c;
                byArray[0] = (byte)n;
                string2 = new String(byArray);
                if (string2.length() != 1 || (c = string2.charAt(0)) == '\ufffd') continue;
                string = (String)captionMap.get(new Integer(c));
                string = string == null ? "" : string + " = ";
                string = string + CharMap4J14.winaltNotation(n);
                CharMap4J14.captionPut(c, string);
            }
        }
    }

    static void putError(String string) {
        if (mainFrame == null) {
            System.err.println(string);
        } else {
            JOptionPane.showMessageDialog(mainFrame, string);
        }
    }

    static void reportMakeDialog() {
        if (reportDialog != null) {
            return;
        }
        reportDialog = new JFrame();
        reportDialog.setDefaultCloseOperation(1);
        reportDialog.setLocation(windowLeft + 30, windowTop + 30);
        reportDialog.setSize(windowWidth - 60, windowHeight - 60);
        JPanel jPanel = (JPanel)reportDialog.getContentPane();
        jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), ACTION_REPORT_HIDE);
        jPanel.getActionMap().put(ACTION_REPORT_HIDE, new CharMap4J14User(ACTION_REPORT_HIDE));
        reportText = new JTextArea();
        reportText.setEditable(false);
        reportText.setFont(new Font(SYSTEM_FONT, 0, 18));
        reportText.setLineWrap(false);
        reportText.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(reportText);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        reportCloseButton = new JButton("Close");
        reportCloseButton.addActionListener(userActions);
        if (buttonFont != null) {
            reportCloseButton.setFont(buttonFont);
        }
        reportCloseButton.setMnemonic(67);
        reportCloseButton.setToolTipText("Close/hide this dialog window.");
        jPanel2.add(reportCloseButton);
        jPanel2.add(Box.createHorizontalStrut(40));
        reportLicenseButton = new JButton("Show License");
        reportLicenseButton.addActionListener(userActions);
        if (buttonFont != null) {
            reportLicenseButton.setFont(buttonFont);
        }
        reportLicenseButton.setMnemonic(76);
        reportLicenseButton.setToolTipText("Show user license for this program.");
        jPanel2.add(reportLicenseButton);
        jPanel2.add(Box.createHorizontalStrut(40));
        reportSummaryButton = new JButton("Show Summary");
        reportSummaryButton.addActionListener(userActions);
        if (buttonFont != null) {
            reportSummaryButton.setFont(buttonFont);
        }
        reportSummaryButton.setMnemonic(83);
        reportSummaryButton.setToolTipText("Show program summary, sample text.");
        jPanel2.add(reportSummaryButton);
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add(Box.createVerticalStrut(15), "North");
        jPanel.add(Box.createHorizontalStrut(10), "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add(Box.createHorizontalStrut(10), "East");
        jPanel.add(Box.createVerticalStrut(10), "South");
    }

    static void reportShowDialog() {
        int n = reportDialog.getExtendedState();
        if ((n & 1) != 0) {
            reportDialog.setExtendedState(n ^ 1);
        }
        reportDialog.validate();
        reportDialog.setVisible(true);
        reportDialog.repaint();
        reportCloseButton.requestFocusInWindow();
    }

    static void reportShowLicense() {
        CharMap4J14.reportMakeDialog();
        reportDialog.setTitle(LICENSE_NAME);
        try {
            reportText.read(new FileReader(LICENSE_FILE), null);
        }
        catch (IOException iOException) {
            reportText.setText("Sorry, can't read license text from file: GnuPublicLicense3.txt");
        }
        reportText.select(0, 0);
        CharMap4J14.reportShowDialog();
    }

    static void reportShowSummary() {
        CharMap4J14.reportMakeDialog();
        reportDialog.setTitle("Characters in Sample Text");
        String string = sampleDialog.getText();
        int n = string.length();
        reportText.setText("Display Characters and Copy to System Clipboard - by: Keith Fenske\nCopyright (c) 2008 by Keith Fenske.  Released under GNU Public License.\n\nCurrent window position is (" + mainFrame.getX() + "," + mainFrame.getY() + ") and size is (" + mainFrame.getWidth() + "," + mainFrame.getHeight() + ") pixels.\n\nFont <" + fontName + "> has " + formatComma.format(CharMap4J14.gridPanel.charCount) + " characters with " + formatComma.format(CharMap4J14.gridPanel.glyphCount) + " glyphs.\n");
        int n2 = n;
        if (n2 > 1) {
            reportText.append("Sample text has " + formatComma.format(n2) + " characters:\n");
        } else if (n2 > 0) {
            reportText.append("Sample text has one character:\n");
        } else {
            reportText.append("Sample text is empty.\n");
        }
        n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2++);
            reportText.append(CharMap4J14.charToString(c) + " = " + CharMap4J14.captionGet(c) + "\n");
        }
        reportText.select(0, 0);
        CharMap4J14.reportShowDialog();
    }

    static void setDisplayFont() {
        displayFont = new Font(fontName, 0, fontSize);
        if (mainFrame != null) {
            sampleDialog.setFont(displayFont);
            mainFrame.validate();
            gridPanel.clear();
        }
    }

    static void setFontName(String string) {
        fontName = string;
        if (!fontName.equals(new Font(fontName, 0, fontSize).getFamily())) {
            CharMap4J14.putError("Font name <" + fontName + "> not found; using <" + SYSTEM_FONT + "> instead.");
            fontName = SYSTEM_FONT;
            if (mainFrame != null) {
                nameDialog.setSelectedItem(fontName);
            }
        }
        CharMap4J14.setDisplayFont();
    }

    static void setPointSize(String string) {
        try {
            fontSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            fontSize = -1;
        }
        if (fontSize < 10 || fontSize > 999) {
            CharMap4J14.putError("Point size <" + string + "> must be from " + 10 + " to " + 999 + "; using " + 30 + " instead.");
            fontSize = 30;
            if (mainFrame != null) {
                sizeDialog.setSelectedItem(String.valueOf(fontSize));
            }
        }
        CharMap4J14.setDisplayFont();
    }

    static void showHelp() {
        System.err.println();
        System.err.println(PROGRAM_TITLE);
        System.err.println();
        System.err.println("This is a graphical application.  You may give options and/or sample text on");
        System.err.println("the command line.  Options are:");
        System.err.println();
        System.err.println("Options:");
        System.err.println("  -? or -help = show summary of command-line syntax");
        System.err.println("  -c0 = mouse click inserts sample text or replaces selection (default)");
        System.err.println("  -c1 = -c = each mouse click replaces sample text with one character");
        System.err.println("  -d# = text file with character name data; default is -d\"CharMap4.txt\"");
        System.err.println("  -f# = initial font for display text; default is -f\"Verdana\"");
        System.err.println("  -s# = initial point size for display text; default is -s30");
        System.err.println("  -u# = font size for buttons, dialogs, etc; default is local system;");
        System.err.println("      example: -u16");
        System.err.println("  -w(#,#,#,#) = normal window position: left, top, width, height;");
        System.err.println("      default is -w(50,50,700,500)");
        System.err.println("  -x = maximize application window; default is normal window");
        System.err.println();
        System.err.println(COPYRIGHT_NOTICE);
    }

    static String unicodeNotation(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 4) {
            string = "0000".substring(string.length()) + string;
        }
        string = "U+" + string;
        return string;
    }

    static void userButton(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == clearButton) {
            sampleDialog.setText("");
            sampleDialog.requestFocusInWindow();
        } else if (object == copyButton) {
            CharMap4J14.copyText();
            sampleDialog.requestFocusInWindow();
        } else if (object == menuButton) {
            menuPopup.show(menuButton, 0, menuButton.getHeight());
        } else if (object == menuChars) {
            glyphFlag = !menuChars.isSelected();
            CharMap4J14.gridPanel.hoverIndex = -1;
            CharMap4J14.gridPanel.clickIndex = -1;
            CharMap4J14.gridPanel.cornerIndex = 0;
            gridPanel.repaint();
        } else if (object == menuExit) {
            System.exit(0);
        } else if (object == menuGlyphs) {
            glyphFlag = menuGlyphs.isSelected();
            CharMap4J14.gridPanel.hoverIndex = -1;
            CharMap4J14.gridPanel.clickIndex = -1;
            CharMap4J14.gridPanel.cornerIndex = 0;
            gridPanel.repaint();
        } else if (object == menuReport) {
            CharMap4J14.reportShowSummary();
        } else if (object == nameDialog) {
            CharMap4J14.setFontName((String)nameDialog.getSelectedItem());
        } else if (object == rightCopyCaption) {
            if (rightSaveCaption != null && rightSaveCaption.length() > 0) {
                gridPanel.mouseReplaceText(rightSaveCaption);
            }
        } else if (object == rightCopyGlyph) {
            if (rightSaveGlyph >= 0) {
                gridPanel.mouseReplaceText(String.valueOf(rightSaveGlyph));
            }
        } else if (object == rightCopyNotation) {
            if (rightSaveChar >= 0) {
                gridPanel.mouseReplaceText(CharMap4J14.unicodeNotation(rightSaveChar));
            }
        } else if (object == rightCopyNumber) {
            if (rightSaveChar >= 0) {
                gridPanel.mouseReplaceText(String.valueOf(rightSaveChar));
            }
        } else if (object == rightCopyText) {
            if (rightSaveChar >= 0) {
                gridPanel.mouseReplaceText(CharMap4J14.charToString(rightSaveChar));
            }
        } else if (object == sampleDialog) {
            copyButton.doClick();
        } else if (object == sizeDialog) {
            CharMap4J14.setPointSize((String)sizeDialog.getSelectedItem());
        } else if (reportDialog != null && object == reportCloseButton) {
            reportDialog.setVisible(false);
        } else if (reportDialog != null && object == reportLicenseButton) {
            CharMap4J14.reportShowLicense();
        } else if (reportDialog != null && object == reportSummaryButton) {
            CharMap4J14.reportShowSummary();
        } else {
            System.err.println("Error in userButton(): unknown ActionEvent: " + actionEvent);
        }
    }

    static void userKey(String string) {
        if (mainFrame != null) {
            if (string.equals(ACTION_GOTO_END)) {
                gridScroll.setValue(gridScroll.getMaximum());
            } else if (string.equals(ACTION_GOTO_HOME)) {
                gridScroll.setValue(gridScroll.getMinimum());
            } else if (string.equals(ACTION_LINE_DOWN)) {
                gridScroll.setValue(gridScroll.getValue() + 1);
            } else if (string.equals(ACTION_LINE_UP)) {
                gridScroll.setValue(gridScroll.getValue() - 1);
            } else if (string.equals(ACTION_PAGE_DOWN)) {
                gridScroll.setValue(gridScroll.getValue() + gridScroll.getBlockIncrement());
            } else if (string.equals(ACTION_PAGE_UP)) {
                gridScroll.setValue(gridScroll.getValue() - gridScroll.getBlockIncrement());
            } else if (string.equals(ACTION_PROGRAM_EXIT)) {
                menuExit.doClick();
            } else if (string.equals(ACTION_REPORT_HIDE)) {
                reportDialog.setVisible(false);
            } else if (string.equals(ACTION_REPORT_SHOW)) {
                menuReport.doClick();
            } else if (string.equals(ACTION_SAMPLE_CLEAR)) {
                clearButton.doClick();
            } else {
                System.err.println("Error in userKey(): unknown command: " + string);
            }
        }
    }

    static String winaltNotation(int n) {
        String string = Integer.toString(n);
        if (string.length() < 4) {
            string = "0000".substring(string.length()) + string;
        }
        string = "Alt+" + string;
        return string;
    }
}

