/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.components;

import FontViewer.components.ListPanel;
import FontViewer.windows.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SystemFontsPanel
extends JPanel
implements ListPanel {
    private MainWindow mw;
    private String[] names;
    private String location;
    private JList systemFontsList;
    private JScrollPane systemFontsScrollPane;

    public SystemFontsPanel(MainWindow mw) {
        this.mw = mw;
        this.initComponents();
        this.initSystemFonts();
    }

    private void initSystemFonts() {
        this.names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.location = "System Font";
        this.systemFontsList.setListData(this.names);
    }

    @Override
    public String[] getItem(int itemNumber) {
        String[] s = new String[3];
        if (itemNumber >= 0 && itemNumber < this.names.length) {
            s[0] = this.names[itemNumber];
            s[1] = this.location;
            s[2] = String.valueOf(itemNumber);
        }
        return s;
    }

    @Override
    public int getNumItems() {
        int items = 0;
        if (this.names != null) {
            items = this.names.length;
        }
        return items;
    }

    @Override
    public String[] getCurrentItem() {
        String[] s = new String[3];
        int p = this.systemFontsList.getSelectedIndex();
        if (p >= 0) {
            s[0] = this.names[p];
            s[1] = this.location;
            s[2] = String.valueOf(p);
        }
        return s;
    }

    @Override
    public int getCurrentItemNum() {
        return this.systemFontsList.getSelectedIndex();
    }

    @Override
    public void selectItem(String name, String loc) {
        this.systemFontsList.setSelectedValue(name, true);
        int p = this.systemFontsList.getSelectedIndex();
        if (p >= 0) {
            this.mw.setCurrentFont(this.names[p], this.location, p);
        }
    }

    @Override
    public void selectNext() {
        int i = this.systemFontsList.getSelectedIndex();
        if (i >= 0) {
            if (i + 1 < this.names.length) {
                ++i;
            }
            this.setCurrentItem(i, true);
        } else {
            this.setCurrentItem(0, true);
        }
    }

    @Override
    public void selectPrev() {
        int i = this.systemFontsList.getSelectedIndex();
        if (i >= 0) {
            if (i - 1 >= 0) {
                --i;
            }
            this.setCurrentItem(i, true);
        } else {
            this.setCurrentItem(0, true);
        }
    }

    private void setCurrentItem(int p, boolean internal) {
        if (internal) {
            this.systemFontsList.setSelectedIndex(p);
            int spos = p * (this.systemFontsScrollPane.getVerticalScrollBar().getMaximum() / this.names.length);
            this.systemFontsScrollPane.getVerticalScrollBar().setValue(spos -= this.systemFontsScrollPane.getSize().height / 2);
        }
        if (p >= 0) {
            this.mw.setCurrentFont(this.names[p], this.location, p);
        }
    }

    private void initComponents() {
        this.systemFontsScrollPane = new JScrollPane();
        this.systemFontsList = new JList();
        this.setLayout(new BorderLayout());
        this.systemFontsScrollPane.setBorder(null);
        this.systemFontsList.setFont(new Font("Dialog", 0, 10));
        this.systemFontsList.setSelectionMode(0);
        this.systemFontsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SystemFontsPanel.this.systemFontsListKeyReleased(evt);
            }
        });
        this.systemFontsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SystemFontsPanel.this.systemFontsListMouseClicked(evt);
            }
        });
        this.systemFontsScrollPane.setViewportView(this.systemFontsList);
        this.add((Component)this.systemFontsScrollPane, "Center");
    }

    private void systemFontsListKeyReleased(KeyEvent evt) {
        this.setCurrentItem(this.systemFontsList.getSelectedIndex(), false);
    }

    private void systemFontsListMouseClicked(MouseEvent evt) {
        this.setCurrentItem(this.systemFontsList.getSelectedIndex(), false);
    }

    private void exitForm(WindowEvent evt) {
    }
}

