/*
 * Decompiled with CFR 0.152.
 */
package FontViewer.windows.dialogs;

import FontViewer.components.AAToggleButton;
import FontViewer.windows.dialogs.TextAreaDialog;
import com.jgoodies.plaf.BorderStyle;
import com.jgoodies.plaf.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class ListView
extends JDialog {
    private final int SYSTEM = 0;
    private final int FILE = 1;
    private int rows;
    private int columns;
    private int fontSize;
    private int fontNum;
    private int drawToNum;
    private String sampleText = "\u30b5\u30f3\u30d7\u30eb\u30c6\u30ad\u30b9\u30c8";
    private Vector selectedFonts;
    private Object[] list;
    JFrame parent;
    private JMenuItem changeSampleTextMenuItem;
    private JMenuItem closeViewMenuItem;
    private JLabel fontSizeLabel;
    private JTextField fontSizeTextField;
    private JLabel fontsPerPageLabel;
    private JTextField fontsPerPageTextField;
    private JMenuItem goToFontMenuItem;
    private JMenu hiddenMenu;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel listPanel;
    private JScrollPane listScrollPane;
    private JMenuBar menuBar;
    private JLabel navInfoLabel;
    private JPanel navigationPanel;
    private JButton nextButton;
    private JMenuItem nextMenuItem;
    private JMenu optionsMenu;
    private JPanel optionsPanel;
    private JButton prevButton;
    private JMenuItem prevMenuItem;
    private JMenuItem quitMenuItem;
    private JMenuItem saveFavsMenuItem;
    private JMenuItem viewFavsMenuItem;

    public ListView(JFrame parent, int rows, int columns, Object[] o) {
        super(parent);
        this.parent = parent;
        this.setModal(true);
        this.rows = rows;
        this.columns = columns;
        this.list = o;
        this.fontSize = 20;
        this.fontNum = 0;
        this.drawToNum = this.fontNum + rows;
        this.selectedFonts = new Vector();
        this.initComponents();
        this.menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.menuBar.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
        this.drawFonts();
        this.fontSizeTextField.setFont(new Font("Dialog", 0, 10));
        this.fontSizeTextField.setText("" + this.fontSize);
        this.fontsPerPageTextField.setText("" + rows);
        this.navInfoLabel.setFont(new Font("Dialog", 0, 10));
        this.navInfoLabel.setText("\u30d5\u30a9\u30f3\u30c8 " + (this.fontNum + 1) + "~" + this.drawToNum + " \uff0f " + this.list.length);
        this.pack();
        this.hiddenMenu.setVisible(false);
        this.hiddenMenu.setEnabled(false);
        this.setLocation((GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getSize().width) / 2, (GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height - this.getSize().height) / 2);
    }

    private void drawFonts() {
        boolean objectType = false;
        Font f = null;
        WeakReference<Font> wrf = null;
        WeakReference<AAToggleButton> wrb = null;
        this.listPanel.removeAll();
        this.listPanel.repaint();
        int i = this.fontNum;
        while (i < this.drawToNum) {
            AAToggleButton tb;
            if (this.list[i] instanceof String) {
                f = new Font(this.list[i].toString(), 0, this.fontSize);
                wrf = new WeakReference<Font>(f);
                objectType = false;
            } else if (this.list[i] instanceof File) {
                try {
                    f = Font.createFont(0, new FileInputStream((File)this.list[i]));
                    wrf = new WeakReference<Font>(f);
                    objectType = true;
                }
                catch (Exception e) {
                    f = null;
                }
            }
            if (f != null) {
                tb = new AAToggleButton(this.sampleText);
                tb.setFont(new Font("Dialog", 0, 10));
                wrb = new WeakReference<AAToggleButton>(tb);
                ((AAToggleButton)wrb.get()).setBackground(Color.WHITE);
                ((AAToggleButton)wrb.get()).setFont(f.deriveFont(0, this.fontSize));
                if (objectType) {
                    ((AAToggleButton)wrb.get()).setToolTipText(String.valueOf(((Font)wrf.get()).getName()) + " (" + ((File)this.list[i]).getName() + ")");
                } else {
                    ((AAToggleButton)wrb.get()).setToolTipText(((Font)wrf.get()).getName());
                }
                if (this.selectedFonts.contains(((AAToggleButton)wrb.get()).getToolTipText())) {
                    ((AAToggleButton)wrb.get()).setSelected(true);
                }
                ((AAToggleButton)wrb.get()).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JToggleButton source = (JToggleButton)evt.getSource();
                        if (source.isSelected()) {
                            ListView.this.selectedFonts.add(source.getToolTipText());
                        } else {
                            ListView.this.selectedFonts.remove(source.getToolTipText());
                        }
                        ListView.this.menuBar.requestFocus();
                    }
                });
            } else {
                tb = new AAToggleButton("\u30d5\u30a9\u30f3\u30c8\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
                tb.setFont(new Font("Dialog", 0, 10));
            }
            this.listPanel.add((AAToggleButton)wrb.get());
            ++i;
        }
    }

    private void updateFontSize() {
        this.fontSizeTextField.setText("" + this.fontSize);
        this.drawFonts();
    }

    private void updateRows() {
        this.fontsPerPageTextField.setText("" + this.rows);
        this.drawFonts();
    }

    private void updateNavInfo() {
        this.drawToNum = this.fontNum + this.rows < this.list.length ? this.fontNum + this.rows : this.list.length;
        this.navInfoLabel.setFont(new Font("Dialog", 0, 10));
        this.navInfoLabel.setText("\u30d5\u30a9\u30f3\u30c8 " + (this.fontNum + 1) + "~" + this.drawToNum + " \uff0f " + this.list.length);
        this.navInfoLabel.setToolTipText(this.navInfoLabel.getText());
        this.drawFonts();
    }

    private void showNextPage() {
        if (this.fontNum + this.rows < this.list.length) {
            this.fontNum += this.rows;
            this.updateNavInfo();
        }
    }

    private void showPrevPage() {
        if (this.fontNum != 0) {
            this.fontNum = this.fontNum - this.rows >= 0 ? (this.fontNum -= this.rows) : 0;
            this.updateNavInfo();
        }
    }

    @Override
    public void pack() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = env.getMaximumWindowBounds();
        super.pack();
        int w = this.getWidth();
        int h = this.getHeight();
        boolean changed = false;
        if (w > bounds.width) {
            w = bounds.width;
            changed = true;
            this.setLocation(0, (int)this.getLocation().getY());
        }
        if (h > bounds.height) {
            h = bounds.height;
            changed = true;
            this.setLocation((int)this.getLocation().getX(), 0);
        }
        if (changed) {
            this.setSize(w, h);
        }
        Point p = this.getLocation();
        int px = p.x;
        int py = p.y;
        boolean moved = false;
        if (px + w > bounds.width) {
            px = (bounds.width - w) / 2;
            moved = true;
        }
        if (py + h > bounds.height) {
            py = (bounds.height - h) / 2;
            moved = true;
        }
        if (moved) {
            this.setLocation(px, py);
        }
    }

    private void saveFavToFile(File f) {
        if (this.selectedFonts.size() == 0) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, "\u4fdd\u5b58\u3059\u308b\u304a\u6c17\u306b\u5165\u308a\u30d5\u30a9\u30f3\u30c8\u304c\u3042\u308a\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 0);
        } else {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                Collections.sort(this.selectedFonts);
                int i = 0;
                while (i < this.selectedFonts.size()) {
                    bw.write(this.selectedFonts.get(i).toString());
                    bw.newLine();
                    ++i;
                }
                bw.close();
            }
            catch (IOException ioe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u51fa\u305b\u307e\u305b\u3093\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
    }

    private StringBuffer getSortedFavs() {
        Collections.sort(this.selectedFonts);
        StringBuffer favs = new StringBuffer(this.selectedFonts.size() * 15);
        int i = 0;
        while (i < this.selectedFonts.size()) {
            favs.append(this.selectedFonts.get(i) + "\n");
            ++i;
        }
        return favs;
    }

    private void initComponents() {
        this.optionsPanel = new JPanel();
        this.optionsPanel.setFont(new Font("Dialog", 0, 10));
        this.fontsPerPageLabel = new JLabel();
        this.fontsPerPageTextField = new JTextField();
        this.fontSizeLabel = new JLabel();
        this.fontSizeTextField = new JTextField();
        this.listScrollPane = new JScrollPane();
        this.listPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.prevButton = new JButton();
        this.navInfoLabel = new JLabel();
        this.nextButton = new JButton();
        this.menuBar = new JMenuBar();
        this.optionsMenu = new JMenu();
        this.goToFontMenuItem = new JMenuItem();
        this.changeSampleTextMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.viewFavsMenuItem = new JMenuItem();
        this.saveFavsMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.closeViewMenuItem = new JMenuItem();
        this.hiddenMenu = new JMenu();
        this.prevMenuItem = new JMenuItem();
        this.nextMenuItem = new JMenuItem();
        this.quitMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this.setDefaultCloseOperation(2);
        this.setTitle("\u4e00\u89a7");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ListView.this.exitForm(evt);
            }
        });
        this.optionsPanel.setLayout(new GridLayout(1, 0));
        this.optionsPanel.setPreferredSize(new Dimension(10, 20));
        this.fontsPerPageLabel.setHorizontalAlignment(0);
        this.fontsPerPageLabel.setFont(new Font("Dialog", 0, 10));
        this.fontsPerPageLabel.setText("\u30d5\u30a9\u30f3\u30c8/\u30da\u30fc\u30b8");
        this.fontsPerPageLabel.setToolTipText("\u30da\u30fc\u30b8\u6bce\u306b\u8868\u793a\u3059\u308b\u30d5\u30a9\u30f3\u30c8");
        this.optionsPanel.add(this.fontsPerPageLabel);
        this.fontsPerPageTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ListView.this.fontsPerPageTextFieldKeyPressed(evt);
            }
        });
        this.optionsPanel.add(this.fontsPerPageTextField);
        this.fontSizeLabel.setHorizontalAlignment(0);
        this.fontSizeLabel.setFont(new Font("Dialog", 0, 10));
        this.fontSizeLabel.setText("\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba");
        this.fontSizeLabel.setToolTipText("\u30d5\u30a9\u30f3\u30c8\u306e\u5927\u304d\u3055");
        this.optionsPanel.add(this.fontSizeLabel);
        this.fontSizeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ListView.this.fontSizeTextFieldKeyPressed(evt);
            }
        });
        this.optionsPanel.add(this.fontSizeTextField);
        this.getContentPane().add((Component)this.optionsPanel, "North");
        this.listScrollPane.setMinimumSize(new Dimension(300, 22));
        this.listScrollPane.setPreferredSize(null);
        this.listPanel.setLayout(new GridLayout(1, 1));
        this.listPanel.setMinimumSize(new Dimension(300, 0));
        this.listPanel.setLayout(new GridLayout(this.rows, this.columns, 2, 0));
        this.listScrollPane.setViewportView(this.listPanel);
        this.getContentPane().add((Component)this.listScrollPane, "Center");
        this.navigationPanel.setLayout(new FlowLayout(1, 5, 0));
        this.navigationPanel.setPreferredSize(new Dimension(250, 20));
        this.prevButton.setFont(new Font("Dialog", 0, 10));
        this.prevButton.setText("<");
        this.prevButton.setToolTipText("\u524d\u306e\u30da\u30fc\u30b8\u3078\u79fb\u52d5\u3059\u308b");
        this.prevButton.setPreferredSize(new Dimension(41, 20));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.prevButtonActionPerformed(evt);
            }
        });
        this.navigationPanel.add(this.prevButton);
        this.navInfoLabel.setHorizontalAlignment(0);
        this.navInfoLabel.setFont(new Font("Dialog", 0, 10));
        this.navInfoLabel.setText("\u30d5\u30a9\u30f3\u30c8 0~0 \uff0f 0");
        this.navInfoLabel.setPreferredSize(new Dimension(150, 20));
        this.navigationPanel.add(this.navInfoLabel);
        this.nextButton.setFont(new Font("Dialog", 0, 10));
        this.nextButton.setText(">");
        this.nextButton.setToolTipText("\u6b21\u306e\u30da\u30fc\u30b8\u3078\u79fb\u52d5\u3059\u308b");
        this.nextButton.setPreferredSize(new Dimension(41, 20));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.nextButtonActionPerformed(evt);
            }
        });
        this.navigationPanel.add(this.nextButton);
        this.getContentPane().add((Component)this.navigationPanel, "South");
        this.optionsMenu.setMnemonic('o');
        this.optionsMenu.setFont(new Font("Dialog", 0, 10));
        this.optionsMenu.setText("\u8a2d\u5b9a");
        this.goToFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.goToFontMenuItem.setFont(new Font("Dialog", 0, 10));
        this.goToFontMenuItem.setText("\u30d5\u30a9\u30f3\u30c8#\u3078\u79fb\u52d5\u3059\u308b");
        this.goToFontMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.goToFontMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.goToFontMenuItem);
        this.changeSampleTextMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.changeSampleTextMenuItem.setFont(new Font("Dialog", 0, 10));
        this.changeSampleTextMenuItem.setText("\u30b5\u30f3\u30d7\u30eb\u30c6\u30ad\u30b9\u30c8\u3092\u5909\u66f4\u3059\u308b");
        this.changeSampleTextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.changeSampleTextMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.changeSampleTextMenuItem);
        this.optionsMenu.add(this.jSeparator1);
        this.viewFavsMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.viewFavsMenuItem.setMnemonic('v');
        this.viewFavsMenuItem.setFont(new Font("Dialog", 0, 10));
        this.viewFavsMenuItem.setText("\u304a\u6c17\u306b\u5165\u308a\u3092\u8868\u793a");
        this.viewFavsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.viewFavsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.viewFavsMenuItem);
        this.saveFavsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveFavsMenuItem.setMnemonic('s');
        this.saveFavsMenuItem.setFont(new Font("Dialog", 0, 10));
        this.saveFavsMenuItem.setText("\u304a\u6c17\u306b\u5165\u308a\u3092\u4fdd\u5b58");
        this.saveFavsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.saveFavsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.saveFavsMenuItem);
        this.optionsMenu.add(this.jSeparator2);
        this.closeViewMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        this.closeViewMenuItem.setMnemonic('c');
        this.closeViewMenuItem.setFont(new Font("Dialog", 0, 10));
        this.closeViewMenuItem.setText("\u9589\u3058\u308b");
        this.closeViewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.closeViewMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.closeViewMenuItem);
        this.menuBar.add(this.optionsMenu);
        this.hiddenMenu.setFont(new Font("Dialog", 0, 10));
        this.hiddenMenu.setText("\u96a0\u308c\u30e1\u30cb\u30e5\u30fc");
        this.prevMenuItem.setAccelerator(KeyStroke.getKeyStroke(33, 0));
        this.prevMenuItem.setFont(new Font("Dialog", 0, 10));
        this.prevMenuItem.setText("\u524d\u3078");
        this.prevMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.prevMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.prevMenuItem);
        this.nextMenuItem.setAccelerator(KeyStroke.getKeyStroke(34, 0));
        this.nextMenuItem.setFont(new Font("Dialog", 0, 10));
        this.nextMenuItem.setText("\u6b21\u3078");
        this.nextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.nextMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.nextMenuItem);
        this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.quitMenuItem.setFont(new Font("Dialog", 0, 10));
        this.quitMenuItem.setText("\u9805\u76ee");
        this.quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListView.this.quitMenuItemActionPerformed(evt);
            }
        });
        this.hiddenMenu.add(this.quitMenuItem);
        this.menuBar.add(this.hiddenMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void goToFontMenuItemActionPerformed(ActionEvent evt) {
        block5: {
            new JOptionPane();
            String fontNumString = JOptionPane.showInputDialog(this, "\u79fb\u52d5\u5148\u306e\u30d5\u30a9\u30f3\u30c8\u756a\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u30d5\u30a9\u30f3\u30c8#\u3078\u79fb\u52d5", 3);
            if (fontNumString != null) {
                try {
                    int fn = Integer.parseInt(fontNumString);
                    if (fn > 0 && fn <= this.list.length) {
                        if (this.fontNum != fn - 1) {
                            this.fontNum = fn - 1;
                            this.updateNavInfo();
                        }
                        break block5;
                    }
                    throw new NumberFormatException();
                }
                catch (NumberFormatException nfe) {
                    new JOptionPane();
                    JOptionPane.showMessageDialog(this, "\u4e0d\u6b63\u306a\u30d5\u30a9\u30f3\u30c8\u756a\u53f7\u3067\u3059\u30021\u304b\u3089" + this.list.length + "\u306e\u756a\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "\u30a8\u30e9\u30fc", 0);
                }
            }
        }
    }

    private void quitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void closeViewMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void nextMenuItemActionPerformed(ActionEvent evt) {
        this.showNextPage();
    }

    private void prevMenuItemActionPerformed(ActionEvent evt) {
        this.showPrevPage();
    }

    private void viewFavsMenuItemActionPerformed(ActionEvent evt) {
        new TextAreaDialog(this.parent, "\u304a\u6c17\u306b\u5165\u308a\u30d5\u30a9\u30f3\u30c8", this.getSortedFavs().toString()).show();
    }

    private void saveFavsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(new File(""));
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            File f = fc.getSelectedFile();
            if (f.exists()) {
                new JOptionPane();
                if (JOptionPane.showConfirmDialog(this, "\u30d5\u30a1\u30a4\u30eb" + f.getName() + "\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f", "\u8b66\u544a", 0, 2) == 0) {
                    this.saveFavToFile(f);
                }
            } else {
                this.saveFavToFile(f);
            }
        }
    }

    private void changeSampleTextMenuItemActionPerformed(ActionEvent evt) {
        new JOptionPane();
        String t = JOptionPane.showInputDialog(this, "\u30b5\u30f3\u30d7\u30eb\u30c6\u30ad\u30b9\u30c8\u306b\u4f7f\u3046\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a", "\u30b5\u30f3\u30d7\u30eb\u30c6\u30ad\u30b9\u30c8\u3092\u5909\u66f4", 3);
        if (t != null) {
            this.sampleText = t;
            this.drawFonts();
            this.pack();
        }
    }

    private void fontSizeTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int tfs = Integer.parseInt(this.fontSizeTextField.getText());
                if (tfs <= 0) {
                    this.fontSizeTextField.setText("" + this.fontSize);
                    throw new NumberFormatException();
                }
                this.fontSize = tfs;
                this.drawFonts();
                this.pack();
            }
            catch (NumberFormatException nfe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "\u4e0d\u6b63\u306a\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
    }

    private void fontsPerPageTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int tmpRows = Integer.parseInt(this.fontsPerPageTextField.getText());
                if (tmpRows > 0) {
                    this.rows = tmpRows;
                    this.listPanel.setLayout(new GridLayout(this.rows, this.columns, 2, 0));
                    if (this.rows > this.list.length) {
                        this.fontNum = 0;
                    }
                } else {
                    this.fontsPerPageTextField.setText("" + this.rows);
                    throw new NumberFormatException();
                }
                this.updateNavInfo();
                this.pack();
            }
            catch (NumberFormatException nfe) {
                new JOptionPane();
                JOptionPane.showMessageDialog(this, "\u4e0d\u6b63\u306a\u30da\u30fc\u30b8\u6bce\u306e\u30d5\u30a9\u30f3\u30c8\u6570\u3002", "\u30a8\u30e9\u30fc", 0);
            }
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.showNextPage();
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.showPrevPage();
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }
}

