/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.wizards.SuiteClassesContentProvider;
import org.eclipse.jdt.internal.junit.wizards.TestSuiteClassListRange;
import org.eclipse.jdt.internal.junit.wizards.UpdateTestSuite;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewTestSuiteWizardPage
extends NewTypeWizardPage {
    private static final String ALL_TESTS = "AllTests";
    public static final String NON_COMMENT_END_MARKER = "$JUnit-END$";
    public static final String NON_COMMENT_START_MARKER = "$JUnit-BEGIN$";
    public static final String COMMENT_START = "//";
    public static final String START_MARKER = "//$JUnit-BEGIN$";
    public static final String END_MARKER = "//$JUnit-END$";
    private static final String PAGE_NAME = "NewTestSuiteCreationWizardPage";
    public static final String CLASSES_IN_SUITE = "NewTestSuiteCreationWizardPage.classesinsuite";
    private CheckboxTableViewer fClassesInSuiteTable;
    private IStatus fClassesInSuiteStatus;
    private Label fSelectedClassesLabel;
    private boolean fUpdatedExistingClassButton;

    public NewTestSuiteWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(WizardMessages.NewTestSuiteWizPage_title);
        this.setDescription(WizardMessages.NewTestSuiteWizPage_description);
        this.fClassesInSuiteStatus = new JUnitStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createClassesInSuiteControl(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.junit.new_testsuite_wizard_page2_context");
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initSuitePage(jelem);
        this.doStatusUpdate();
    }

    private void initSuitePage(IJavaElement jelem) {
        if (jelem != null) {
            IPackageFragment pack = (IPackageFragment)jelem.getAncestor(4);
            IJavaProject project = jelem.getJavaProject();
            this.setPackageFragment(pack, true);
            this.setAddComments(StubUtility.doAddComments((IJavaProject)project), true);
        }
        this.setTypeName(ALL_TESTS, true);
        this.fTypeNameStatus = this.typeNameChanged();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewTypeWizardPage.package") || fieldName.equals("NewContainerWizardPage.container")) {
            this.updateClassesInSuiteTable();
        } else if (fieldName.equals(CLASSES_IN_SUITE)) {
            this.fClassesInSuiteStatus = this.classesInSuiteChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.updateSelectedClassesLabel();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassesInSuiteStatus};
        this.updateStatus(status);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setFocus();
            this.updateClassesInSuiteTable();
            this.handleAllFieldsChanged();
        } else {
            this.saveWidgetValues();
        }
        super.setVisible(visible);
    }

    private void handleAllFieldsChanged() {
        this.handleFieldChanged("NewTypeWizardPage.package");
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.handleFieldChanged(CLASSES_IN_SUITE);
        this.handleFieldChanged("NewTypeWizardPage.typename");
    }

    protected void updateClassesInSuiteTable() {
        if (this.fClassesInSuiteTable != null) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack == null) {
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root != null) {
                    pack = root.getPackageFragment("");
                } else {
                    return;
                }
            }
            this.fClassesInSuiteTable.setInput((Object)pack);
            this.fClassesInSuiteTable.setAllChecked(true);
            this.updateSelectedClassesLabel();
        }
    }

    protected void createClassesInSuiteControl(Composite parent, int nColumns) {
        if (this.fClassesInSuiteTable == null) {
            Label label = new Label(parent, 16384);
            label.setText(WizardMessages.NewTestSuiteWizPage_classes_in_suite_label);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = nColumns;
            label.setLayoutData((Object)gd);
            this.fClassesInSuiteTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            gd = new GridData(1808);
            gd.heightHint = 80;
            gd.horizontalSpan = nColumns - 1;
            this.fClassesInSuiteTable.getTable().setLayoutData((Object)gd);
            this.fClassesInSuiteTable.setContentProvider((IContentProvider)new SuiteClassesContentProvider());
            this.fClassesInSuiteTable.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.fClassesInSuiteTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    NewTestSuiteWizardPage.this.handleFieldChanged(NewTestSuiteWizardPage.CLASSES_IN_SUITE);
                }
            });
            Composite buttonContainer = new Composite(parent, 0);
            gd = new GridData(1040);
            buttonContainer.setLayoutData((Object)gd);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.marginWidth = 0;
            buttonLayout.marginHeight = 0;
            buttonContainer.setLayout((Layout)buttonLayout);
            Button selectAllButton = new Button(buttonContainer, 8);
            selectAllButton.setText(WizardMessages.NewTestSuiteWizPage_selectAll);
            GridData bgd = new GridData(770);
            bgd.widthHint = LayoutUtil.getButtonWidthHint(selectAllButton);
            selectAllButton.setLayoutData((Object)bgd);
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTestSuiteWizardPage.this.fClassesInSuiteTable.setAllChecked(true);
                    NewTestSuiteWizardPage.this.handleFieldChanged(NewTestSuiteWizardPage.CLASSES_IN_SUITE);
                }
            });
            Button deselectAllButton = new Button(buttonContainer, 8);
            deselectAllButton.setText(WizardMessages.NewTestSuiteWizPage_deselectAll);
            bgd = new GridData(770);
            bgd.widthHint = LayoutUtil.getButtonWidthHint(deselectAllButton);
            deselectAllButton.setLayoutData((Object)bgd);
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTestSuiteWizardPage.this.fClassesInSuiteTable.setAllChecked(false);
                    NewTestSuiteWizardPage.this.handleFieldChanged(NewTestSuiteWizardPage.CLASSES_IN_SUITE);
                }
            });
            this.fSelectedClassesLabel = new Label(parent, 16448);
            this.fSelectedClassesLabel.setFont(parent.getFont());
            this.updateSelectedClassesLabel();
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.fSelectedClassesLabel.setLayoutData((Object)gd);
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.writeImports(imports);
        type.createMethod(this.getSuiteMethodString(type), null, false, null);
    }

    private String getSuiteMethodString(IType type) {
        String typeName = type.getElementName();
        StringBuffer suite = new StringBuffer("public static Test suite () {TestSuite suite= new TestSuite(" + typeName + ".class.getName());\n");
        suite.append(this.getUpdatableString());
        suite.append("\nreturn suite;}");
        return suite.toString();
    }

    private String getUpdatableString() {
        return UpdateTestSuite.getUpdatableString(this.fClassesInSuiteTable.getCheckedElements());
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IPackageFragment pack = this.getPackageFragment();
        ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(this.getTypeName()) + ".java");
        if (!cu.exists()) {
            super.createType(monitor);
            this.fUpdatedExistingClassButton = false;
        } else {
            this.updateExistingType(cu, monitor);
            this.fUpdatedExistingClassButton = true;
        }
    }

    private void updateExistingType(ICompilationUnit cu, IProgressMonitor monitor) throws JavaModelException {
        block8: {
            if (!UpdateTestSuite.checkValidateEditStatus(cu, this.getShell())) {
                return;
            }
            IType suiteType = cu.getType(this.getTypeName());
            monitor.beginTask(WizardMessages.NewTestSuiteWizPage_createType_beginTask, 10);
            IMethod suiteMethod = suiteType.getMethod("suite", new String[0]);
            monitor.worked(1);
            String lineDelimiter = cu.findRecommendedLineSeparator();
            if (suiteMethod.exists()) {
                ISourceRange range = suiteMethod.getSourceRange();
                if (range != null) {
                    try {
                        Document fullSource = new Document(cu.getBuffer().getContents());
                        String originalContent = fullSource.get(range.getOffset(), range.getLength());
                        StringBuffer source = new StringBuffer(originalContent);
                        TestSuiteClassListRange classListRange = UpdateTestSuite.getTestSuiteClassListRange(originalContent);
                        if (classListRange != null) {
                            monitor.subTask(WizardMessages.NewTestSuiteWizPage_createType_updating_suite_method);
                            monitor.worked(1);
                            source.replace(classListRange.getStart(), classListRange.getEnd(), this.getUpdatableString());
                            fullSource.replace(range.getOffset(), range.getLength(), source.toString());
                            monitor.worked(1);
                            String formattedContent = JUnitStubUtility.formatCompilationUnit(cu.getJavaProject(), fullSource.get(), lineDelimiter);
                            cu.getBuffer().setContents(formattedContent);
                            monitor.worked(1);
                            cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
                            break block8;
                        }
                        this.cannotUpdateSuiteError();
                    }
                    catch (BadLocationException badLocationException) {
                        Assert.isTrue((boolean)false, (String)"Should never happen");
                    }
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.NewTestSuiteWizPage_createType_updateErrorDialog_title, (String)WizardMessages.NewTestSuiteWizPage_createType_updateErrorDialog_message);
                }
            } else {
                suiteType.createMethod(this.getSuiteMethodString(suiteType), null, true, monitor);
                String originalContent = cu.getSource();
                monitor.worked(2);
                String formattedContent = JUnitStubUtility.formatCompilationUnit(cu.getJavaProject(), originalContent, lineDelimiter);
                cu.getBuffer().setContents(formattedContent);
                monitor.worked(1);
                cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
            }
        }
        monitor.done();
    }

    public boolean hasUpdatedExistingClass() {
        return this.fUpdatedExistingClassButton;
    }

    private IStatus classesInSuiteChanged() {
        JUnitStatus status = new JUnitStatus();
        if (this.fClassesInSuiteTable.getCheckedElements().length <= 0) {
            status.setWarning(WizardMessages.NewTestSuiteWizPage_classes_in_suite_error_no_testclasses_selected);
        }
        return status;
    }

    private void updateSelectedClassesLabel() {
        int noOfClassesChecked = this.fClassesInSuiteTable.getCheckedElements().length;
        String key = noOfClassesChecked == 1 ? WizardMessages.NewTestClassWizPage_treeCaption_classSelected : WizardMessages.NewTestClassWizPage_treeCaption_classesSelected;
        this.fSelectedClassesLabel.setText(Messages.format((String)key, (Object)new Integer(noOfClassesChecked)));
    }

    protected IStatus typeNameChanged() {
        IStatus recursiveSuiteInclusionStatus;
        super.typeNameChanged();
        JUnitStatus status = new JUnitStatus();
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(WizardMessages.NewTestSuiteWizPage_typeName_error_name_empty);
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(WizardMessages.NewTestSuiteWizPage_typeName_error_name_qualified);
            return status;
        }
        IStatus val = JavaConventionsUtil.validateJavaTypeName((String)typeName, (IJavaElement)this.getJavaProject());
        if (val.getSeverity() == 4) {
            status.setError(String.valueOf(WizardMessages.NewTestSuiteWizPage_typeName_error_name_not_valid) + val.getMessage());
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(String.valueOf(WizardMessages.NewTestSuiteWizPage_typeName_error_name_name_discouraged) + val.getMessage());
        }
        if (!(recursiveSuiteInclusionStatus = this.checkRecursiveTestSuiteInclusion()).isOK()) {
            return recursiveSuiteInclusionStatus;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            if (cu.exists()) {
                status.setWarning(WizardMessages.NewTestSuiteWizPage_typeName_warning_already_exists);
                return status;
            }
            IResource resource = cu.getResource();
            if (resource != null && !ResourcesPlugin.getWorkspace().validateFiltered(resource).isOK()) {
                status.setError(WizardMessages.NewTestSuiteWizPage_typeName_error_filtered);
                return status;
            }
        }
        return status;
    }

    private IStatus checkRecursiveTestSuiteInclusion() {
        if (this.fClassesInSuiteTable == null) {
            return new JUnitStatus();
        }
        String typeName = this.getTypeName();
        JUnitStatus status = new JUnitStatus();
        Object[] checkedClasses = this.fClassesInSuiteTable.getCheckedElements();
        int i = 0;
        while (i < checkedClasses.length) {
            IType checkedClass = (IType)checkedClasses[i];
            if (checkedClass.getElementName().equals(typeName)) {
                status.setWarning(WizardMessages.NewTestSuiteCreationWizardPage_infinite_recursion);
                return status;
            }
            ++i;
        }
        return new JUnitStatus();
    }

    private void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.NewTestSuiteWizPage_cannotUpdateDialog_title, (String)Messages.format((String)WizardMessages.NewTestSuiteWizPage_cannotUpdateDialog_message, (Object[])new String[]{START_MARKER, END_MARKER}));
    }

    private void writeImports(NewTypeWizardPage.ImportsManager imports) {
        imports.addImport("junit.framework.Test");
        imports.addImport("junit.framework.TestSuite");
    }

    private void restoreWidgetValues() {
    }

    private void saveWidgetValues() {
    }
}

