/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ExpressionDropAdapter
extends ViewerDropAdapter {
    private TransferData fCurrentTransferType = null;
    private boolean fInsertBefore;
    private int fDropType;
    private static final int DROP_TYPE_DEFAULT = 0;
    private static final int DROP_TYPE_VARIABLE = 1;
    private static final int DROP_TYPE_EXPRESSION = 2;
    private static final int DROP_TYPE_WATCH_ADAPTABLE_ELEMENT = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected ExpressionDropAdapter(TreeModelViewer viewer) {
        super((Viewer)viewer);
        this.setFeedbackEnabled(true);
        this.setSelectionFeedbackEnabled(false);
        this.setScrollExpandEnabled(false);
    }

    public void dragEnter(DropTargetEvent event) {
        this.fDropType = 0;
        event.detail = 0;
        int i = 0;
        while (i < event.dataTypes.length) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                if (this.isExpressionDrop()) {
                    event.currentDataType = event.dataTypes[i];
                    event.detail = 2;
                    this.fDropType = 2;
                    break;
                }
                if (this.isVariableDrop()) {
                    event.currentDataType = event.dataTypes[i];
                    event.detail = 1;
                    this.fDropType = 1;
                    break;
                }
                if (this.isWatchAdaptableElementDrop()) {
                    event.currentDataType = event.dataTypes[i];
                    event.detail = 1;
                    this.fDropType = 3;
                    break;
                }
            } else if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                event.detail = 1;
                this.fDropType = 0;
                break;
            }
            ++i;
        }
        super.dragEnter(event);
    }

    private boolean isExpressionDrop() {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (this.getTargetExpression(element) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isVariableDrop() {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element instanceof IVariable) continue;
            return false;
        }
        return true;
    }

    private boolean isWatchAdaptableElementDrop() {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (element instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable.getAdapter((Class)clazz) != null) continue;
            }
            return false;
        }
        return true;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        event.feedback |= 8;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            if (this.fDropType == 2) {
                return this.validateExpressionDrop(target);
            }
            if (this.fDropType == 1) {
                return this.validateVariableDrop(target);
            }
            if (this.fDropType == 3) {
                return this.validateWatchAdaptableDrop(target);
            }
        } else if (TextTransfer.getInstance().isSupportedType(transferType)) {
            return this.validateTextDrop(target);
        }
        return false;
    }

    private boolean validateExpressionDrop(Object target) {
        block7: {
            block8: {
                if (target instanceof IExpression) break block7;
                if (!(target instanceof IAdaptable)) break block8;
                IAdaptable iAdaptable = (IAdaptable)target;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.debug.core.model.IExpression");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iAdaptable.getAdapter((Class)clazz) != null) break block7;
            }
            return false;
        }
        return true;
    }

    private IExpression getTargetExpression(Object target) {
        if (target instanceof IExpression) {
            return (IExpression)target;
        }
        if (target instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.core.model.IExpression");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IExpression)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    private boolean validateVariableDrop(Object target) {
        if (target != null && this.getTargetExpression(target) == null) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        int enabled = 0;
        int size = -1;
        if (selection != null) {
            size = selection.size();
            IExpressionManager manager = DebugPlugin.getDefault().getExpressionManager();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof IVariable)) continue;
                IVariable variable = (IVariable)element;
                if (variable instanceof IndexedVariablePartition || !manager.hasWatchExpressionDelegate(variable.getModelIdentifier()) || !this.isFactoryEnabled(variable)) break;
                ++enabled;
            }
        }
        return enabled == size;
    }

    private boolean validateWatchAdaptableDrop(Object target) {
        if (target != null && this.getTargetExpression(target) == null) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        int enabled = 0;
        int size = -1;
        if (selection != null) {
            size = selection.size();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!this.isFactory2Enabled(element)) break;
                ++enabled;
            }
        }
        return enabled == size;
    }

    private boolean validateTextDrop(Object target) {
        return target == null || this.getTargetExpression(target) != null;
    }

    private boolean isFactoryEnabled(IVariable variable) {
        IWatchExpressionFactoryAdapter factory = this.getFactory(variable);
        if (factory instanceof IWatchExpressionFactoryAdapterExtension) {
            IWatchExpressionFactoryAdapterExtension ext = (IWatchExpressionFactoryAdapterExtension)factory;
            return ext.canCreateWatchExpression(variable);
        }
        return true;
    }

    private boolean isFactory2Enabled(Object element) {
        IWatchExpressionFactoryAdapter2 factory = this.getFactory2(element);
        if (factory != null) {
            return factory.canCreateWatchExpression(element);
        }
        return false;
    }

    public void drop(DropTargetEvent event) {
        this.fCurrentTransferType = event.currentDataType;
        this.fInsertBefore = this.getCurrentLocation() != 2;
        super.drop(event);
    }

    public boolean performDrop(Object data) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(this.fCurrentTransferType)) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            if (this.fDropType == 2) {
                return this.performExpressionDrop(selection);
            }
            if (this.fDropType == 1 || this.fDropType == 3) {
                return this.performVariableOrWatchAdaptableDrop(selection);
            }
        } else if (TextTransfer.getInstance().isSupportedType(this.fCurrentTransferType) && data != null) {
            return this.performTextDrop((String)data);
        }
        return false;
    }

    private boolean performExpressionDrop(IStructuredSelection selection) {
        IExpression targetExpression = this.getTargetExpression(this.getCurrentTarget());
        if (targetExpression != null) {
            IExpression[] expressions = new IExpression[selection.size()];
            Object[] selectionElements = selection.toArray();
            int i = 0;
            while (i < selectionElements.length) {
                expressions[i] = this.getTargetExpression(selectionElements[i]);
                ++i;
            }
            IExpressionManager manager = DebugPlugin.getDefault().getExpressionManager();
            if (manager instanceof ExpressionManager) {
                ((ExpressionManager)manager).moveExpressions(expressions, targetExpression, this.fInsertBefore);
            }
            return true;
        }
        return false;
    }

    private boolean performVariableOrWatchAdaptableDrop(IStructuredSelection selection) {
        IExpressionManager manager;
        ArrayList<IExpression> expressions = new ArrayList<IExpression>(selection.size());
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            String expressionText = this.createExpressionString(element);
            if (expressionText != null) {
                IExpression expression = this.createExpression(expressionText);
                if (expression != null) {
                    expressions.add(expression);
                    continue;
                }
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Drop failed.  Watch expression could not be created for the text " + expressionText));
                return false;
            }
            return false;
        }
        if (expressions.size() == selection.size() && (manager = DebugPlugin.getDefault().getExpressionManager()) instanceof ExpressionManager) {
            IExpression targetExpression = this.getTargetExpression(this.getCurrentTarget());
            if (targetExpression != null) {
                ((ExpressionManager)manager).insertExpressions(expressions.toArray(new IExpression[expressions.size()]), targetExpression, this.fInsertBefore);
            } else {
                ((ExpressionManager)manager).addExpressions(expressions.toArray(new IExpression[expressions.size()]));
            }
            return true;
        }
        return false;
    }

    private boolean performTextDrop(String text) {
        IExpressionManager manager;
        IExpression expression = this.createExpression(text);
        if (expression != null && (manager = DebugPlugin.getDefault().getExpressionManager()) instanceof ExpressionManager) {
            IExpression targetExpression = this.getTargetExpression(this.getCurrentTarget());
            if (targetExpression != null) {
                ((ExpressionManager)manager).insertExpressions(new IExpression[]{expression}, targetExpression, this.fInsertBefore);
            } else {
                ((ExpressionManager)manager).addExpression(expression);
            }
            return true;
        }
        DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Drop failed.  Watch expression could not be created for the text " + text));
        return false;
    }

    private String createExpressionString(Object element) {
        try {
            if (element instanceof IVariable) {
                IVariable variable = (IVariable)element;
                IWatchExpressionFactoryAdapter factory = this.getFactory(variable);
                String exp = variable.getName();
                if (factory != null) {
                    exp = factory.createWatchExpression(variable);
                }
                return exp;
            }
            IWatchExpressionFactoryAdapter2 factory2 = this.getFactory2(element);
            if (factory2 != null) {
                return factory2.createWatchExpression(element);
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
        return null;
    }

    private IExpression createExpression(String exp) {
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(exp);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
        return expression;
    }

    private IWatchExpressionFactoryAdapter getFactory(IVariable variable) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWatchExpressionFactoryAdapter)variable.getAdapter((Class)clazz);
    }

    private IWatchExpressionFactoryAdapter2 getFactory2(Object element) {
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IWatchExpressionFactoryAdapter2)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

