/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.pde.api.tools.internal.builder.IllegalExtendsProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.IllegalFieldReferenceDetector;
import org.eclipse.pde.api.tools.internal.builder.IllegalImplementsProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.IllegalInstantiateProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.IllegalMethodReferenceDetector;
import org.eclipse.pde.api.tools.internal.builder.IllegalOverrideProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.LeakExtendsProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.LeakFieldProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.LeakImplementsProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.LeakParameterTypeDetector;
import org.eclipse.pde.api.tools.internal.builder.LeakReturnTypeDetector;
import org.eclipse.pde.api.tools.internal.builder.SystemApiDetector;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;

public class ProblemDetectorBuilder
extends ApiDescriptionVisitor {
    public static int K_ALL = -1;
    public static int K_USE = 1;
    public static int K_LEAK = 2;
    public static int K_SYSTEM = 4;
    private IllegalExtendsProblemDetector fIllegalExtends = null;
    private IllegalImplementsProblemDetector fIllegalImplements = null;
    private IllegalInstantiateProblemDetector fIllegalInstantiate = null;
    private IllegalOverrideProblemDetector fIllegalOverride = null;
    private IllegalMethodReferenceDetector fIllegalMethodRef = null;
    private IllegalFieldReferenceDetector fIllegalFieldRef = null;
    private SystemApiDetector fSystemApiDetector = null;
    private Set fNonApiPackageNames = new HashSet();
    private IApiComponent fComponent = null;
    private List fDetectors;
    private int fKindMask = 0;

    public ProblemDetectorBuilder(IApiComponent component, int kinds) {
        this.fKindMask = kinds;
        this.initializeDetectors(component);
    }

    public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
        int mask = description.getRestrictions();
        switch (element.getElementType()) {
            case 1: {
                if (!VisibilityModifiers.isPrivate(description.getVisibility())) break;
                this.fNonApiPackageNames.add(((IPackageDescriptor)element).getName());
                return false;
            }
            default: {
                if ((this.fKindMask & K_USE) <= 0 || RestrictionModifiers.isUnrestricted(mask)) break;
                if (RestrictionModifiers.isOverrideRestriction(mask) && this.fIllegalOverride != null) {
                    this.fIllegalOverride.addIllegalMethod((IMethodDescriptor)element, this.fComponent.getSymbolicName());
                }
                if (RestrictionModifiers.isExtendRestriction(mask) && this.fIllegalExtends != null) {
                    this.fIllegalExtends.addIllegalType((IReferenceTypeDescriptor)element, this.fComponent.getSymbolicName());
                }
                if (RestrictionModifiers.isImplementRestriction(mask) && this.fIllegalImplements != null) {
                    this.fIllegalImplements.addIllegalType((IReferenceTypeDescriptor)element, this.fComponent.getSymbolicName());
                }
                if (RestrictionModifiers.isInstantiateRestriction(mask) && this.fIllegalInstantiate != null) {
                    this.fIllegalInstantiate.addIllegalType((IReferenceTypeDescriptor)element, this.fComponent.getSymbolicName());
                }
                if (!RestrictionModifiers.isReferenceRestriction(mask)) break;
                if (element.getElementType() == 6 && this.fIllegalMethodRef != null) {
                    this.fIllegalMethodRef.addIllegalMethod((IMethodDescriptor)element, this.fComponent.getSymbolicName());
                    break;
                }
                if (element.getElementType() != 5 || this.fIllegalFieldRef == null) break;
                this.fIllegalFieldRef.addIllegalField((IFieldDescriptor)element, this.fComponent.getSymbolicName());
            }
        }
        return true;
    }

    public void setOwningComponent(IApiComponent component) {
        this.fComponent = component;
    }

    private IProject getProject(IApiComponent component) {
        if (component instanceof ProjectComponent) {
            ProjectComponent comp = (ProjectComponent)component;
            return comp.getJavaProject().getProject();
        }
        return null;
    }

    private void initializeDetectors(IApiComponent component) {
        this.fDetectors = new ArrayList();
        IProject project = this.getProject(component);
        if ((this.fKindMask & K_USE) > 0) {
            this.addUseDetectors(this.fDetectors, project);
        }
        if ((this.fKindMask & K_SYSTEM) > 0) {
            this.addSystemDetector(this.fDetectors, project);
        }
        if ((this.fKindMask & K_LEAK) > 0) {
            this.addLeakDetectors(this.fDetectors, project);
        }
    }

    private boolean isIgnore(String problemKey, IProject project) {
        int severity = ApiPlugin.getDefault().getSeverityLevel(problemKey, project);
        return severity == 0;
    }

    Set getNonApiPackageNames() {
        return this.fNonApiPackageNames;
    }

    public boolean addNonApiPackageName(String packagee) {
        if (packagee != null) {
            return this.fNonApiPackageNames.add(packagee);
        }
        return false;
    }

    public List getProblemDetectors() {
        return this.fDetectors;
    }

    private void addSystemDetector(List detectors, IProject project) {
        if (project != null) {
            if (!this.isIgnore("INVALID_REFERENCE_IN_SYSTEM_LIBRARIES", project) && this.fSystemApiDetector == null) {
                this.fSystemApiDetector = new SystemApiDetector();
                this.fDetectors.add(this.fSystemApiDetector);
            }
        } else {
            this.fSystemApiDetector = new SystemApiDetector();
            this.fDetectors.add(this.fSystemApiDetector);
        }
    }

    private void addUseDetectors(List detectors, IProject project) {
        if (project != null) {
            if (!this.isIgnore("ILLEGAL_EXTEND", project) && this.fIllegalExtends == null) {
                this.fIllegalExtends = new IllegalExtendsProblemDetector();
                detectors.add(this.fIllegalExtends);
            }
            if (!this.isIgnore("ILLEGAL_IMPLEMENT", project) && this.fIllegalImplements == null) {
                this.fIllegalImplements = new IllegalImplementsProblemDetector();
                detectors.add(this.fIllegalImplements);
            }
            if (!this.isIgnore("ILLEGAL_INSTANTIATE", project) && this.fIllegalInstantiate == null) {
                this.fIllegalInstantiate = new IllegalInstantiateProblemDetector();
                detectors.add(this.fIllegalInstantiate);
            }
            if (!this.isIgnore("ILLEGAL_OVERRIDE", project) && this.fIllegalOverride == null) {
                this.fIllegalOverride = new IllegalOverrideProblemDetector();
                detectors.add(this.fIllegalOverride);
            }
            if (!this.isIgnore("ILLEGAL_REFERENCE", project) && this.fIllegalMethodRef == null) {
                this.fIllegalMethodRef = new IllegalMethodReferenceDetector();
                detectors.add(this.fIllegalMethodRef);
                this.fIllegalFieldRef = new IllegalFieldReferenceDetector();
                detectors.add(this.fIllegalFieldRef);
            }
        } else {
            this.fIllegalExtends = new IllegalExtendsProblemDetector();
            detectors.add(this.fIllegalExtends);
            this.fIllegalImplements = new IllegalImplementsProblemDetector();
            detectors.add(this.fIllegalImplements);
            this.fIllegalInstantiate = new IllegalInstantiateProblemDetector();
            detectors.add(this.fIllegalInstantiate);
            this.fIllegalOverride = new IllegalOverrideProblemDetector();
            detectors.add(this.fIllegalOverride);
            this.fIllegalMethodRef = new IllegalMethodReferenceDetector();
            detectors.add(this.fIllegalMethodRef);
            this.fIllegalFieldRef = new IllegalFieldReferenceDetector();
            detectors.add(this.fIllegalFieldRef);
        }
    }

    private void addLeakDetectors(List detectors, IProject project) {
        if (project != null) {
            if (!this.isIgnore("LEAK_EXTEND", project)) {
                detectors.add(new LeakExtendsProblemDetector(this.fNonApiPackageNames));
            }
            if (!this.isIgnore("LEAK_IMPLEMENT", project)) {
                detectors.add(new LeakImplementsProblemDetector(this.fNonApiPackageNames));
            }
            if (!this.isIgnore("LEAK_FIELD_DECL", project)) {
                detectors.add(new LeakFieldProblemDetector(this.fNonApiPackageNames));
            }
            if (!this.isIgnore("LEAK_METHOD_PARAM", project)) {
                detectors.add(new LeakParameterTypeDetector(this.fNonApiPackageNames));
            }
            if (!this.isIgnore("LEAK_METHOD_RETURN_TYPE", project)) {
                detectors.add(new LeakReturnTypeDetector(this.fNonApiPackageNames));
            }
        } else {
            detectors.add(new LeakExtendsProblemDetector(this.fNonApiPackageNames));
            detectors.add(new LeakImplementsProblemDetector(this.fNonApiPackageNames));
            detectors.add(new LeakFieldProblemDetector(this.fNonApiPackageNames));
            detectors.add(new LeakReturnTypeDetector(this.fNonApiPackageNames));
            detectors.add(new LeakParameterTypeDetector(this.fNonApiPackageNames));
        }
    }
}

