/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.IHelpActivitySupport;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;

public class HelpBasePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help.base";
    private static HelpBasePlugin plugin;
    private File configurationDirectory;
    private BundleContext context;
    private IHelpActivitySupport helpActivitySupport = new IHelpActivitySupport(){

        public boolean isEnabled(String href) {
            return true;
        }

        public boolean isRoleEnabled(String href) {
            return true;
        }

        public boolean isEnabledTopic(String href, String locale) {
            return true;
        }

        public void enableActivities(String href) {
        }

        public boolean isFilteringEnabled() {
            return false;
        }

        public void setFilteringEnabled(boolean enabled) {
        }

        public boolean isUserCanToggleFiltering() {
            return false;
        }

        public String getShowAllMessage() {
            return null;
        }

        public String getDocumentMessage(boolean embedded) {
            return null;
        }

        public boolean getDocumentMessageUsesLiveHelp(boolean embedded) {
            return false;
        }

        public String getLocalScopeCheckboxLabel() {
            return null;
        }
    };

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpBasePlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logStatus(IStatus errorStatus) {
        HelpBasePlugin.getDefault().getLog().log(errorStatus);
    }

    public static HelpBasePlugin getDefault() {
        return plugin;
    }

    public void stop(BundleContext context) throws Exception {
        BaseHelpSystem.shutdown();
        this.context = null;
        plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        URL configURL;
        super.start(context);
        plugin = this;
        this.context = context;
        Location location = Platform.getConfigurationLocation();
        if (location != null && (configURL = location.getURL()) != null && configURL.getProtocol().startsWith("file")) {
            this.configurationDirectory = new File(configURL.getFile(), PLUGIN_ID);
        }
        if (this.configurationDirectory == null) {
            this.configurationDirectory = this.getStateLocation().toFile();
        }
        BaseHelpSystem.startup();
    }

    public static File getConfigurationDirectory() {
        return HelpBasePlugin.getDefault().configurationDirectory;
    }

    public static IHelpActivitySupport getActivitySupport() {
        return HelpBasePlugin.getDefault().helpActivitySupport;
    }

    public static void setActivitySupport(IHelpActivitySupport activitySupport) {
        HelpBasePlugin.getDefault().helpActivitySupport = activitySupport;
    }

    public static BundleContext getBundleContext() {
        return HelpBasePlugin.getDefault().context;
    }
}

