/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarimport;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RefactoringLocationControl
extends Composite {
    protected final Combo fCombo;
    protected final String fKey;
    protected final IWizard fWizard;
    protected final int MAX_HISTORY_SIZE = 5;

    public RefactoringLocationControl(IWizard wizard, Composite parent, String key) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fCombo = new Combo((Composite)this, 2052);
        this.fCombo.setLayoutData((Object)this.createGridData(1808, 1, 0));
        Assert.isNotNull((Object)wizard);
        Assert.isTrue((key != null && !"".equals(key) ? 1 : 0) != 0);
        this.fWizard = wizard;
        this.fKey = key;
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData data = new GridData(flag);
        data.horizontalIndent = indent;
        data.horizontalSpan = hspan;
        return data;
    }

    public Combo getControl() {
        return this.fCombo;
    }

    public String getText() {
        return this.fCombo.getText();
    }

    public void loadHistory() {
        IDialogSettings settings = this.fWizard.getDialogSettings();
        if (settings != null) {
            String[] locations = settings.getArray(this.fKey);
            if (locations == null || locations.length == 0) {
                return;
            }
            int index = 0;
            while (index < locations.length) {
                this.fCombo.add(locations[index]);
                ++index;
            }
            this.fCombo.select(0);
        }
    }

    public void saveHistory() {
        IDialogSettings settings = this.fWizard.getDialogSettings();
        if (settings != null) {
            LinkedList<String> locations = new LinkedList<String>();
            String[] items = this.fCombo.getItems();
            int index = 0;
            while (index < items.length) {
                locations.add(items[index]);
                ++index;
            }
            String text = this.fCombo.getText().trim();
            if (!"".equals(text)) {
                locations.remove(text);
                locations.addFirst(text);
            }
            int size = locations.size();
            int index2 = 0;
            while (index2 < size - 5) {
                locations.removeLast();
                ++index2;
            }
            settings.put(this.fKey, locations.toArray(new String[locations.size()]));
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fCombo.setEnabled(enabled);
    }

    public void setText(String text) {
        this.fCombo.setText(text);
    }
}

