/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.io.CharConversionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class UseSupertypeAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public UseSupertypeAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public UseSupertypeAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.UseSupertypeAction_use_Supertype);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.use_supertype_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isUseSuperTypeAvailable(selection));
        }
        catch (JavaModelException e) {
            if (!(e.getException() instanceof CharConversionException) && JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isUseSuperTypeAvailable(selection)) {
                IType singleSelectedType = UseSupertypeAction.getSingleSelectedType(selection);
                if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)singleSelectedType)) {
                    return;
                }
                RefactoringExecutionStarter.startUseSupertypeRefactoring(singleSelectedType, this.getShell());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IType getSingleSelectedType(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof IType) {
            return (IType)first;
        }
        if (first instanceof ICompilationUnit) {
            return JavaElementUtil.getMainType((ICompilationUnit)first);
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isUseSuperTypeAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IType type = RefactoringActions.getEnclosingOrPrimaryType(this.fEditor);
            if (RefactoringAvailabilityTester.isUseSuperTypeAvailable(type)) {
                if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
                    return;
                }
                RefactoringExecutionStarter.startUseSupertypeRefactoring(type, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.UseSupertypeAction_to_activate);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

