/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.internal.debug.ui.breakpoints.ExceptionBreakpointDetailPane;
import org.eclipse.jdt.internal.debug.ui.breakpoints.LineBreakpointDetailPane;
import org.eclipse.jdt.internal.debug.ui.breakpoints.MethodBreakpointDetailPane;
import org.eclipse.jdt.internal.debug.ui.breakpoints.StandardBreakpointDetailPane;
import org.eclipse.jdt.internal.debug.ui.breakpoints.WatchpointDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BreakpointDetailPaneFactory
implements IDetailPaneFactory {
    private Map fNameMap;

    public Set getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> set = new HashSet<String>();
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("org.eclipse.jdt.debug.javaLineBreakpointMarker".equals(type)) {
                    set.add(LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT);
                } else if ("org.eclipse.jdt.debug.javaWatchpointMarker".equals(type)) {
                    set.add(WatchpointDetailPane.DETAIL_PANE_WATCHPOINT);
                } else if ("org.eclipse.jdt.debug.javaMethodBreakpointMarker".equals(type)) {
                    set.add(MethodBreakpointDetailPane.DETAIL_PANE_METHOD_BREAKPOINT);
                } else if ("org.eclipse.jdt.debug.javaExceptionBreakpointMarker".equals(type)) {
                    set.add(ExceptionBreakpointDetailPane.DETAIL_PANE_EXCEPTION_BREAKPOINT);
                } else {
                    set.add(StandardBreakpointDetailPane.DETAIL_PANE_STANDARD);
                }
            }
            catch (CoreException coreException) {}
        }
        return set;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("org.eclipse.jdt.debug.javaLineBreakpointMarker".equals(type)) {
                    return LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT;
                }
                if ("org.eclipse.jdt.debug.javaWatchpointMarker".equals(type)) {
                    return WatchpointDetailPane.DETAIL_PANE_WATCHPOINT;
                }
                if ("org.eclipse.jdt.debug.javaExceptionBreakpointMarker".equals(type)) {
                    return ExceptionBreakpointDetailPane.DETAIL_PANE_EXCEPTION_BREAKPOINT;
                }
                if ("org.eclipse.jdt.debug.javaMethodBreakpointMarker".equals(type)) {
                    return MethodBreakpointDetailPane.DETAIL_PANE_METHOD_BREAKPOINT;
                }
                return StandardBreakpointDetailPane.DETAIL_PANE_STANDARD;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IDetailPane createDetailPane(String paneID) {
        if (LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT.equals(paneID)) {
            return new LineBreakpointDetailPane();
        }
        if (StandardBreakpointDetailPane.DETAIL_PANE_STANDARD.equals(paneID)) {
            return new StandardBreakpointDetailPane();
        }
        if (WatchpointDetailPane.DETAIL_PANE_WATCHPOINT.equals(paneID)) {
            return new WatchpointDetailPane();
        }
        if (MethodBreakpointDetailPane.DETAIL_PANE_METHOD_BREAKPOINT.equals(paneID)) {
            return new MethodBreakpointDetailPane();
        }
        if (ExceptionBreakpointDetailPane.DETAIL_PANE_EXCEPTION_BREAKPOINT.equals(paneID)) {
            return new ExceptionBreakpointDetailPane();
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        return (String)this.getNameMap().get(paneID);
    }

    public String getDetailPaneDescription(String paneID) {
        return (String)this.getNameMap().get(paneID);
    }

    private Map getNameMap() {
        if (this.fNameMap == null) {
            this.fNameMap = new HashMap();
            this.fNameMap.put(LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT, BreakpointMessages.BreakpointDetailPaneFactory_0);
            this.fNameMap.put(WatchpointDetailPane.DETAIL_PANE_WATCHPOINT, BreakpointMessages.WatchpointDetailPane_0);
            this.fNameMap.put(MethodBreakpointDetailPane.DETAIL_PANE_METHOD_BREAKPOINT, BreakpointMessages.BreakpointDetailPaneFactory_1);
            this.fNameMap.put(StandardBreakpointDetailPane.DETAIL_PANE_STANDARD, BreakpointMessages.StandardBreakpointDetailPane_0);
            this.fNameMap.put(ExceptionBreakpointDetailPane.DETAIL_PANE_EXCEPTION_BREAKPOINT, BreakpointMessages.ExceptionBreakpointDetailPane_0);
        }
        return this.fNameMap;
    }
}

