/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.OpenTypeHierarchyAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.IHandlerService;

public class SnippetOpenHierarchyOnSelectionAction
extends OpenTypeHierarchyAction {
    private JavaSnippetEditor fEditor;
    private String fDialogTitle;
    private String fDialogMessage;
    static /* synthetic */ Class class$0;

    public SnippetOpenHierarchyOnSelectionAction(JavaSnippetEditor editor) {
        super((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setResources();
        this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.type.hierarchy");
        ActionHandler handler = new ActionHandler((IAction)this);
        IWorkbenchPartSite iWorkbenchPartSite = editor.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
        handlerService.activateHandler("org.eclipse.jdt.ui.edit.text.java.open.type.hierarchy", (IHandler)handler);
    }

    protected void setResources() {
        this.setText(SnippetMessages.getString("SnippetOpenHierarchyOnSelectionAction.label"));
        this.setDescription(SnippetMessages.getString("SnippetOpenHierarchyOnSelectionAction.tooltip"));
        this.setToolTipText(SnippetMessages.getString("SnippetOpenHierarchyOnSelectionAction.description"));
        this.setDialogTitle(SnippetMessages.getString("SnippetOpenHierarchyOnSelectionDialog.title"));
        this.setDialogMessage(SnippetMessages.getString("SnippetOpenHierarchyOnSelectionDialog.message"));
    }

    protected void setDialogTitle(String title) {
        this.fDialogTitle = title;
    }

    protected void setDialogMessage(String message) {
        this.fDialogMessage = message;
    }

    public void run() {
        if (this.fEditor == null) {
            return;
        }
        try {
            IJavaElement chosen;
            IJavaElement[] result = this.fEditor.codeResolve();
            if (result != null && result.length > 0 && (chosen = this.selectJavaElement(this.filterResolveResults(result), this.getShell(), this.fDialogTitle, this.fDialogMessage)) != null) {
                this.run((IStructuredSelection)new StructuredSelection((Object)chosen));
                return;
            }
        }
        catch (JavaModelException x) {
            JDIDebugUIPlugin.log(x);
        }
        this.getShell().getDisplay().beep();
    }

    protected void setEditor(JavaSnippetEditor contentEditor) {
        this.fEditor = contentEditor;
    }

    protected List filterResolveResults(IJavaElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<IJavaElement> refs = new ArrayList<IJavaElement>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    protected IJavaElement selectJavaElement(List elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.size();
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return (IJavaElement)elements.get(0);
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(elements.toArray());
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IJavaElement) {
                    return (IJavaElement)current;
                }
                ++i;
            }
        }
        return null;
    }
}

