/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.ctxhelp.text;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.xml.sax.SAXParseException;

public class CtxHelpMarkerManager {
    public static void refreshMarkers(CtxHelpModel model) {
        CtxHelpMarkerManager.deleteMarkers(model);
        CtxHelpMarkerManager.createMarkers(model);
    }

    public static void deleteMarkers(CtxHelpModel model) {
        try {
            IMarker[] problems = model.getUnderlyingResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (problems != null) {
                int index = 0;
                while (index < problems.length) {
                    problems[index].delete();
                    ++index;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static void createMarkers(CtxHelpModel model) {
        Collection errors = model.getErrors();
        if (errors == null || errors.size() == 0) {
            return;
        }
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            Throwable exception = (Throwable)iter.next();
            if (!(exception instanceof SAXParseException)) continue;
            int line = ((SAXParseException)exception).getLineNumber();
            try {
                IMarker marker = model.getUnderlyingResource().createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("lineNumber", line);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)exception.getLocalizedMessage());
            }
            catch (CoreException coreException) {}
        }
    }
}

