/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.scheduler.SchedulerStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UpdateSchedulerPlugin
extends AbstractUIPlugin {
    public static final String P_ENABLED = "enabled";
    public static final String P_SCHEDULE = "schedule";
    public static final String VALUE_ON_STARTUP = "on-startup";
    public static final String VALUE_ON_SCHEDULE = "on-schedule";
    public static final String P_DOWNLOAD = "download";
    private static UpdateSchedulerPlugin plugin;
    private ResourceBundle resourceBundle;
    private static SchedulerStartup scheduler;

    public UpdateSchedulerPlugin() {
        plugin = this;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.update.internal.scheduler.UpdateSchedulerResources");
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static UpdateSchedulerPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return UpdateSchedulerPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void logException(Throwable e) {
        UpdateSchedulerPlugin.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UpdateSchedulerPlugin.getPluginId(), 0, message, e);
        }
        UpdateSchedulerPlugin.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                ErrorDialog.openError((Shell)UpdateSchedulerPlugin.getActiveWorkbenchShell(), null, null, (IStatus)status);
            }
            Bundle bundle = Platform.getBundle((String)"org.eclipse.update.scheduler");
            Platform.getLog((Bundle)bundle).log(status);
        } else {
            MessageDialog.openInformation((Shell)UpdateSchedulerPlugin.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static IWorkbenchPage getActivePage() {
        UpdateSchedulerPlugin plugin = UpdateSchedulerPlugin.getDefault();
        IWorkbenchWindow window = plugin.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = UpdateSchedulerPlugin.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UpdateSchedulerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static SchedulerStartup getScheduler() {
        if (scheduler == null) {
            scheduler = new SchedulerStartup();
        }
        return scheduler;
    }

    static void setScheduler(SchedulerStartup scheduler) {
        UpdateSchedulerPlugin.scheduler = scheduler;
    }
}

