/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SimpleTextViewer
extends AbstractViewer {
    private SourceViewer fSourceViewer;
    private ICompareInput fInput;

    SimpleTextViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fSourceViewer.setEditable(false);
    }

    public Control getControl() {
        return this.fSourceViewer.getTextWidget();
    }

    public void setInput(Object input) {
        if (input instanceof IStreamContentAccessor) {
            this.fSourceViewer.setDocument((IDocument)new Document(this.getString(input)));
        } else if (input instanceof ICompareInput) {
            this.fInput = (ICompareInput)input;
            ITypedElement left = this.fInput.getLeft();
            this.fSourceViewer.setDocument((IDocument)new Document(this.getString(left)));
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            try {
                return Utilities.readString((IStreamContentAccessor)input);
            }
            catch (CoreException ex) {
                CompareUIPlugin.log(ex);
            }
        }
        return "";
    }
}

