/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.internal.WorkQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class Worker
implements IRunnableWithProgress {
    private final WorkQueue work = new WorkQueue();
    private boolean isWorking;
    private final List errors = new ArrayList();
    private WorkProgressMonitor currentMonitor;
    private IRunnableWithProgress currentTask;
    private final String taskName;

    public Worker(String taskName) {
        this.taskName = taskName;
    }

    public void run(IProgressMonitor monitor) {
        this.errors.clear();
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getTaskName(), (int)100);
        try {
            try {
                this.isWorking = true;
                while (!this.work.isEmpty()) {
                    try {
                        this.performNextTask(pm);
                        this.checkCancelled(pm);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        this.checkCancelled(pm);
                    }
                    catch (InterruptedException interruptedException) {
                        this.checkCancelled(pm);
                    }
                    catch (InvocationTargetException e) {
                        this.handleError(e.getTargetException());
                    }
                    pm.setWorkRemaining(100);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.work.clear();
                this.isWorking = false;
                if (monitor != null) {
                    monitor.done();
                }
                this.currentMonitor = null;
                this.currentTask = null;
            }
        }
        finally {
            this.isWorking = false;
            if (monitor != null) {
                monitor.done();
            }
            this.currentMonitor = null;
            this.currentTask = null;
        }
    }

    private WorkProgressMonitor subMonitorFor(SubMonitor pm, int ticks) {
        return new WorkProgressMonitor((IProgressMonitor)pm.newChild(ticks));
    }

    private void handleError(Throwable targetException) {
        this.errors.add(targetException);
    }

    public Throwable[] getErrors() {
        return this.errors.toArray(new Throwable[this.errors.size()]);
    }

    private void checkCancelled(SubMonitor pm) {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected String getTaskName() {
        return this.taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performNextTask(SubMonitor pm) throws InvocationTargetException, InterruptedException {
        Worker worker = this;
        synchronized (worker) {
            if (this.work.isEmpty()) {
                return;
            }
            this.currentTask = this.work.remove();
        }
        this.currentMonitor = this.subMonitorFor(pm, 10);
        this.currentTask.run((IProgressMonitor)this.currentMonitor);
    }

    public synchronized void add(IRunnableWithProgress r) {
        if (this.currentTask != null && this.currentTask.equals(r)) {
            this.currentMonitor.cancelTask();
        }
        this.work.add(r);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public boolean hasWork() {
        return this.isWorking() || !this.work.isEmpty();
    }

    private static class WorkProgressMonitor
    extends ProgressMonitorWrapper {
        private boolean localCancel;

        protected WorkProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public void cancelTask() {
            this.localCancel = true;
        }

        public boolean isCanceled() {
            return this.localCancel || super.isCanceled();
        }
    }
}

