/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public class CVSCompareEditorInput
extends CompareEditorInput {
    private ITypedElement left;
    private ITypedElement right;
    private ITypedElement ancestor;
    private Image leftImage;
    private Image rightImage;
    private Image ancestorImage;
    private static final int NODE_EQUAL = 0;
    private static final int NODE_NOT_EQUAL = 1;
    private static final int NODE_UNKNOWN = 2;
    String toolTipText;
    private String title;

    public CVSCompareEditorInput(ResourceEditionNode left, ResourceEditionNode right) {
        this(left, right, null);
    }

    public CVSCompareEditorInput(String title, String toolTip, ResourceEditionNode left, ResourceEditionNode right) {
        this(left, right, null);
        this.title = title;
        this.toolTipText = toolTip;
    }

    public CVSCompareEditorInput(ResourceEditionNode left, ResourceEditionNode right, ResourceEditionNode ancestor) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.ancestor = ancestor;
        if (left != null) {
            this.leftImage = left.getImage();
        }
        if (right != null) {
            this.rightImage = right.getImage();
        }
        if (ancestor != null) {
            this.ancestorImage = ancestor.getImage();
        }
    }

    private String getLabel(ITypedElement element) {
        if (element instanceof ResourceEditionNode) {
            ICVSRemoteResource edition;
            ICVSRemoteResource resource = edition = ((ResourceEditionNode)element).getRemoteResource();
            if (edition instanceof ICVSRemoteFile) {
                try {
                    String name = resource.getName();
                    String revision = ((ICVSRemoteFile)edition).getRevision();
                    String msg = null;
                    if (this.isShowAuthor()) {
                        String author = ((ICVSRemoteFile)edition).getLogEntry((IProgressMonitor)new NullProgressMonitor()).getAuthor();
                        msg = NLS.bind((String)CVSUIMessages.nameRevisionAndAuthor, (Object[])new String[]{name, revision, author});
                    } else {
                        msg = NLS.bind((String)CVSUIMessages.nameAndRevision, (Object[])new String[]{name, revision});
                    }
                    return msg;
                }
                catch (TeamException teamException) {}
            }
            try {
                if (edition.isContainer()) {
                    CVSTag tag = ((ICVSRemoteFolder)edition).getTag();
                    if (tag == null) {
                        return NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_inHead, (Object[])new String[]{edition.getName()});
                    }
                    if (tag.getType() == 1) {
                        return NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_inBranch, (Object[])new Object[]{edition.getName(), tag.getName()});
                    }
                    return NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_repository, (Object[])new Object[]{edition.getName(), tag.getName()});
                }
                return NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_repository, (Object[])new Object[]{edition.getName(), resource.getSyncInfo().getRevision()});
            }
            catch (TeamException e) {
                this.handle((Exception)((Object)e));
            }
        }
        return element.getName();
    }

    private boolean isShowAuthor() {
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        return store.getBoolean("org.eclipse.team.ui.show_author_in_compare_editor");
    }

    private String getVersionLabel(ITypedElement element) {
        if (element instanceof ResourceEditionNode) {
            ICVSRemoteResource edition;
            ICVSRemoteResource resource = edition = ((ResourceEditionNode)element).getRemoteResource();
            try {
                if (edition.isContainer()) {
                    CVSTag tag = ((ICVSRemoteFolder)resource).getTag();
                    if (tag == null) {
                        return CVSUIMessages.CVSCompareEditorInput_headLabel;
                    }
                    if (tag.getType() == 1) {
                        return NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_branchLabel, (Object[])new String[]{tag.getName()});
                    }
                    return tag.getName();
                }
                return resource.getSyncInfo().getRevision();
            }
            catch (TeamException e) {
                this.handle((Exception)((Object)e));
            }
        }
        return element.getName();
    }

    private String guessResourceName() {
        if (this.left != null) {
            return this.left.getName();
        }
        if (this.right != null) {
            return this.right.getName();
        }
        if (this.ancestor != null) {
            return this.ancestor.getName();
        }
        return "";
    }

    private Object guessResourcePath() {
        if (this.left != null && this.left instanceof ResourceEditionNode) {
            return ((ResourceEditionNode)this.left).getRemoteResource().getRepositoryRelativePath();
        }
        if (this.right != null && this.right instanceof ResourceEditionNode) {
            return ((ResourceEditionNode)this.right).getRemoteResource().getRepositoryRelativePath();
        }
        if (this.ancestor != null && this.ancestor instanceof ResourceEditionNode) {
            return ((ResourceEditionNode)this.ancestor).getRemoteResource().getRepositoryRelativePath();
        }
        return this.guessResourceName();
    }

    private void handle(Exception e) {
        Throwable t = e;
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        Object error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, "org.eclipse.team.cvs.ui", 1, CVSUIMessages.internal, t));
        this.setMessage(error.getMessage());
        if (!(t instanceof TeamException)) {
            CVSUIPlugin.log(error.getSeverity(), error.getMessage(), t);
        }
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        this.setLabels(cc, (IStructuredSelection)new StructuredSelection());
        if (this.title == null) {
            if (this.ancestor != null) {
                this.title = NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_titleAncestor, (Object[])new Object[]{this.guessResourceName(), this.getVersionLabel(this.ancestor), this.getVersionLabel(this.left), this.getVersionLabel(this.right)});
                this.toolTipText = NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_titleAncestor, (Object[])new Object[]{this.guessResourcePath(), this.getVersionLabel(this.ancestor), this.getVersionLabel(this.left), this.getVersionLabel(this.right)});
            } else {
                String leftName = null;
                if (this.left != null) {
                    leftName = this.left.getName();
                }
                String rightName = null;
                if (this.right != null) {
                    rightName = this.right.getName();
                }
                if (leftName != null && !leftName.equals(rightName)) {
                    this.title = NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_titleNoAncestorDifferent, (Object[])new Object[]{leftName, this.getVersionLabel(this.left), rightName, this.getVersionLabel(this.right)});
                } else {
                    this.title = NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_titleNoAncestor, (Object[])new Object[]{this.guessResourceName(), this.getVersionLabel(this.left), this.getVersionLabel(this.right)});
                    this.title = NLS.bind((String)CVSUIMessages.CVSCompareEditorInput_titleNoAncestor, (Object[])new Object[]{this.guessResourcePath(), this.getVersionLabel(this.left), this.getVersionLabel(this.right)});
                }
            }
        }
        this.setTitle(this.title);
    }

    private void setLabels(CompareConfiguration cc, IStructuredSelection selection) {
        ITypedElement left = this.left;
        ITypedElement right = this.right;
        ITypedElement ancestor = this.ancestor;
        if (left != null) {
            cc.setLeftLabel(this.getLabel(left));
            cc.setLeftImage(this.leftImage);
        }
        if (right != null) {
            cc.setRightLabel(this.getLabel(right));
            cc.setRightImage(this.rightImage);
        }
        if (ancestor != null) {
            cc.setAncestorLabel(this.getLabel(ancestor));
            cc.setAncestorImage(this.ancestorImage);
        }
    }

    public boolean isSaveNeeded() {
        return false;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean threeWay;
        boolean bl = threeWay = this.ancestor != null;
        if (this.right == null || this.left == null) {
            this.setMessage(CVSUIMessages.CVSCompareEditorInput_different);
            return null;
        }
        this.initLabels();
        Differencer d = new Differencer(){

            protected boolean contentsEqual(Object input1, Object input2) {
                int compare = CVSCompareEditorInput.this.teamEqual(input1, input2);
                if (compare == 0) {
                    return true;
                }
                if (compare == 1) {
                    return false;
                }
                return super.contentsEqual(input1, input2);
            }

            protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
                if (node instanceof ITypedElement) {
                    ITypedElement element = (ITypedElement)node;
                    progressMonitor.subTask(NLS.bind((String)CVSUIMessages.CompareEditorInput_fileProgress, (Object[])new String[]{element.getName()}));
                    progressMonitor.worked(1);
                }
            }

            protected Object[] getChildren(Object input) {
                Object[] children;
                if (input instanceof IStructureComparator && (children = ((IStructureComparator)input).getChildren()) != null) {
                    return children;
                }
                return null;
            }

            protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                return new DiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        try {
            Object result = null;
            monitor.beginTask(CVSUIMessages.CVSCompareEditorInput_comparing, 30);
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 30);
            sub.beginTask(CVSUIMessages.CVSCompareEditorInput_comparing, 100);
            try {
                result = d.findDifferences(threeWay, (IProgressMonitor)sub, null, (Object)this.ancestor, (Object)this.left, (Object)this.right);
            }
            finally {
                sub.done();
            }
            Object object = result;
            return object;
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (RuntimeException e) {
            this.handle(e);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    protected int teamEqual(Object left, Object right) {
        block10: {
            String rightLocation;
            ICVSRemoteResource leftEdition = null;
            if (left instanceof ResourceEditionNode) {
                leftEdition = ((ResourceEditionNode)left).getRemoteResource();
            }
            ICVSRemoteResource rightEdition = null;
            if (right instanceof ResourceEditionNode) {
                rightEdition = ((ResourceEditionNode)right).getRemoteResource();
            }
            if (leftEdition == null || rightEdition == null) {
                return 2;
            }
            if (leftEdition.isContainer() && rightEdition.isContainer()) {
                return 0;
            }
            if (leftEdition.isContainer() != rightEdition.isContainer()) {
                return 1;
            }
            String leftLocation = leftEdition.getRepository().getLocation(false);
            if (!leftLocation.equals(rightLocation = rightEdition.getRepository().getLocation(false))) {
                return 2;
            }
            try {
                ResourceSyncInfo leftInfo = leftEdition.getSyncInfo();
                ResourceSyncInfo rightInfo = rightEdition.getSyncInfo();
                if (!leftEdition.getRepositoryRelativePath().equals(rightEdition.getRepositoryRelativePath()) || !leftInfo.getRevision().equals(rightInfo.getRevision())) break block10;
                return 0;
            }
            catch (TeamException e) {
                this.handle((Exception)((Object)e));
                return 2;
            }
        }
        if (this.considerContentIfRevisionOrPathDiffers()) {
            return 2;
        }
        return 1;
    }

    private boolean considerContentIfRevisionOrPathDiffers() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_consider_contents");
    }

    public Viewer createDiffViewer(Composite parent) {
        final Viewer viewer = super.createDiffViewer(parent);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompareConfiguration cc = CVSCompareEditorInput.this.getCompareConfiguration();
                CVSCompareEditorInput.this.setLabels(cc, (IStructuredSelection)event.getSelection());
            }
        });
        ((StructuredViewer)viewer).addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object o;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof DiffNode) {
                    CVSCompareEditorInput.this.updateLabelsFor((DiffNode)o);
                }
            }
        });
        ((StructuredViewer)viewer).addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DiffNode diffNode;
                Object o;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof DiffNode && (diffNode = (DiffNode)o).hasChildren()) {
                    AbstractTreeViewer atv;
                    atv.setExpandedState(o, !(atv = (AbstractTreeViewer)viewer).getExpandedState(o));
                }
            }
        });
        return viewer;
    }

    protected void updateLabelsFor(DiffNode node) {
        CompareConfiguration cc = this.getCompareConfiguration();
        ITypedElement l = node.getLeft();
        if (l == null) {
            cc.setLeftLabel(CVSUIMessages.CVSCompareEditorInput_0);
            cc.setLeftImage(null);
        } else {
            cc.setLeftLabel(this.getLabel(l));
            cc.setLeftImage(l.getImage());
        }
        ITypedElement r = node.getRight();
        if (r == null) {
            cc.setRightLabel(CVSUIMessages.CVSCompareEditorInput_1);
            cc.setRightImage(null);
        } else {
            cc.setRightLabel(this.getLabel(r));
            cc.setRightImage(r.getImage());
        }
    }

    public String getToolTipText() {
        if (this.toolTipText != null) {
            return this.toolTipText;
        }
        return super.getToolTipText();
    }
}

