/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerCompletionField
extends MarkerField {
    static final String COMPLETE_IMAGE_PATH = "$nl$/icons/full/obj16/complete_tsk.gif";
    static final String INCOMPLETE_IMAGE_PATH = "$nl$/icons/full/obj16/incomplete_tsk.gif";
    private static final int DONE = 2;
    private static final int NOT_DONE = 1;
    private static final int UNDEFINED = 0;

    public int compare(MarkerItem item1, MarkerItem item2) {
        return this.getDoneConstant(item2) - this.getDoneConstant(item1);
    }

    public String getColumnHeaderText() {
        return "";
    }

    public String getColumnTooltipText() {
        return this.getName();
    }

    private Image getCompleteImage() {
        return MarkerSupportInternalUtilities.createImage(COMPLETE_IMAGE_PATH, this.getImageManager());
    }

    public int getDefaultColumnWidth(Control control) {
        return 40;
    }

    private int getDoneConstant(MarkerItem item) {
        int done = 0;
        if (item.getMarker() != null && item.getAttributeValue("userEditable", true)) {
            done = 1;
            if (item.getAttributeValue("done", false)) {
                done = 2;
            }
        }
        return done;
    }

    public EditingSupport getEditingSupport(ColumnViewer viewer) {
        return new CompletionEditingSupport(viewer);
    }

    private Image getImage(Object element) {
        switch (this.getDoneConstant((MarkerItem)element)) {
            case 2: {
                return this.getCompleteImage();
            }
            case 1: {
                return MarkerSupportInternalUtilities.createImage(INCOMPLETE_IMAGE_PATH, this.getImageManager());
            }
        }
        return null;
    }

    public String getValue(MarkerItem item) {
        return "";
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        cell.setImage(this.getImage(cell.getElement()));
    }

    private class CompletionEditingSupport
    extends EditingSupport {
        private CheckboxCellEditor editor;

        public CompletionEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            if (element instanceof MarkerEntry) {
                return ((MarkerEntry)element).getAttributeValue("userEditable", false);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            return new Boolean(((MarkerEntry)element).getAttributeValue("done", false));
        }

        protected void setValue(Object element, Object value) {
            MarkerEntry entry = (MarkerEntry)element;
            Boolean booleanValue = (Boolean)value;
            try {
                entry.getMarker().setAttribute("done", booleanValue.booleanValue());
            }
            catch (CoreException e) {
                Policy.handle(e);
            }
        }
    }
}

