/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class RuntimeInstallJob
extends Job {
    private FeatureExportInfo fInfo;
    private ProvisioningUI ui;

    public RuntimeInstallJob(String jobName, FeatureExportInfo info) {
        super(jobName);
        this.fInfo = info;
        this.ui = ProvisioningUI.getDefaultUI();
        this.ui.manageJob((Job)this, 2);
    }

    public static void modifyInfoForInstall(FeatureExportInfo info) {
        info.exportSource = false;
        info.useJarFormat = true;
        info.exportMetadata = true;
        info.qualifier = QualifierReplacer.getDateQualifier();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            ProvisioningSession session = this.ui.getSession();
            monitor.beginTask(PDEUIMessages.RuntimeInstallJob_Job_name_installing, 12 + 2 * this.fInfo.items.length);
            URI destination = new File(this.fInfo.destinationDirectory).toURI();
            this.ui.loadArtifactRepository(destination, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IMetadataRepository metaRepo = this.ui.loadMetadataRepository(destination, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProfileRegistry profileRegistry = (IProfileRegistry)session.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
            if (profileRegistry == null) {
                Status status = new Status(4, PDEPlugin.getPluginId(), PDEUIMessages.RuntimeInstallJob_ErrorCouldntOpenProfile);
                return status;
            }
            IProfile profile = profileRegistry.getProfile("_SELF_");
            if (profile == null) {
                Status status = new Status(4, PDEPlugin.getPluginId(), PDEUIMessages.RuntimeInstallJob_ErrorCouldntOpenProfile);
                return status;
            }
            ArrayList<Object> toInstall = new ArrayList<Object>();
            int i = 0;
            while (i < this.fInfo.items.length) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.subTask(NLS.bind((String)PDEUIMessages.RuntimeInstallJob_Creating_installable_unit, (Object)this.fInfo.items[i].toString()));
                String id = null;
                String version = null;
                if (this.fInfo.items[i] instanceof IPluginModelBase) {
                    id = ((IPluginModelBase)this.fInfo.items[i]).getPluginBase().getId();
                    version = ((IPluginModelBase)this.fInfo.items[i]).getPluginBase().getVersion();
                } else if (this.fInfo.items[i] instanceof IFeatureModel) {
                    id = String.valueOf(((IFeatureModel)this.fInfo.items[i]).getFeature().getId()) + ".feature.group";
                    version = ((IFeatureModel)this.fInfo.items[i]).getFeature().getVersion();
                }
                if (id == null && version == null) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)PDEUIMessages.RuntimeInstallJob_ErrorCouldNotGetIdOrVersion, (Object)this.fInfo.items[i].toString()));
                    return status;
                }
                Version newVersion = Version.parseVersion((String)(version = QualifierReplacer.replaceQualifierInVersion(version, (String)id, null, null)));
                IQueryResult queryMatches = metaRepo.query(QueryUtil.createIUQuery((String)id, (Version)newVersion), monitor);
                if (queryMatches.isEmpty()) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)PDEUIMessages.RuntimeInstallJob_ErrorCouldNotFindUnitInRepo, (Object[])new String[]{id, version}));
                    return status;
                }
                IInstallableUnit iuToInstall = (IInstallableUnit)queryMatches.iterator().next();
                queryMatches = profile.query(QueryUtil.createIUQuery((String)id), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                if (queryMatches.isEmpty()) {
                    toInstall.add(iuToInstall);
                } else {
                    IInstallableUnit existingIU = (IInstallableUnit)queryMatches.iterator().next();
                    toInstall.add(this.createInstallableUnitPatch(existingIU, newVersion, profile, monitor));
                }
                monitor.worked(2);
                ++i;
            }
            if (toInstall.size() > 0) {
                InstallOperation operation = this.ui.getInstallOperation(toInstall, new URI[]{destination});
                operation.resolveModal((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                IStatus status = operation.getResolutionResult();
                if (status.getSeverity() == 8 || !status.isOK() && status.getSeverity() != 1) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                ProvisioningJob job = operation.getProvisioningJob(null);
                IStatus iStatus = status = job.runModal((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                return iStatus;
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (ProvisionException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IInstallableUnitPatch createInstallableUnitPatch(IInstallableUnit existingIU, Version newVersion, IProfile profile, IProgressMonitor monitor) {
        MetadataFactory.InstallableUnitPatchDescription iuPatchDescription = new MetadataFactory.InstallableUnitPatchDescription();
        String id = existingIU.getId();
        iuPatchDescription.setId(String.valueOf(id) + ".patch");
        iuPatchDescription.setProperty("org.eclipse.equinox.p2.name", NLS.bind((String)PDEUIMessages.RuntimeInstallJob_installPatchName, (Object)id));
        iuPatchDescription.setProperty("org.eclipse.equinox.p2.description", PDEUIMessages.RuntimeInstallJob_installPatchDescription);
        Version patchVersion = Version.createOSGi((int)1, (int)0, (int)0, (String)QualifierReplacer.getDateQualifier());
        iuPatchDescription.setVersion(patchVersion);
        iuPatchDescription.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)iuPatchDescription.getId(), (VersionRange)new VersionRange(Version.createOSGi((int)0, (int)0, (int)0), true, patchVersion, false), (int)0, null));
        ArrayList<IProvidedCapability> list = new ArrayList<IProvidedCapability>(1);
        list.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iuPatchDescription.getId(), (Version)iuPatchDescription.getVersion()));
        iuPatchDescription.addProvidedCapabilities(list);
        IRequirement applyTo = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, null, null, (boolean)false, (boolean)false);
        IRequirement newValue = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)new VersionRange(newVersion, true, newVersion, true), null, (boolean)false, (boolean)false);
        iuPatchDescription.setRequirementChanges(new IRequirementChange[]{MetadataFactory.createRequirementChange((IRequirement)applyTo, (IRequirement)newValue)});
        iuPatchDescription.setApplicabilityScope(new IRequirement[0][0]);
        IQueryResult queryMatches = profile.query(QueryUtil.createMatchQuery((String)"requirements.exists(rc | $0 ~= rc)", (Object[])new Object[]{existingIU}), monitor);
        if (!queryMatches.isEmpty()) {
            IInstallableUnit lifecycleUnit = (IInstallableUnit)queryMatches.iterator().next();
            iuPatchDescription.setLifeCycle(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)lifecycleUnit.getId(), (VersionRange)new VersionRange(lifecycleUnit.getVersion(), true, lifecycleUnit.getVersion(), true), null, (boolean)false, (boolean)false, (boolean)false));
        }
        iuPatchDescription.setProperty("org.eclipse.equinox.p2.type.patch", Boolean.TRUE.toString());
        return MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iuPatchDescription);
    }
}

