/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.commands.CommandList;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CommandComposerDialog
extends FormDialog {
    private CommandComposerPart fCCP;
    private ParameterizedCommand fPC;
    private Button fOKButton;

    public CommandComposerDialog(Shell parentShell, int filterType, ParameterizedCommand preselectedCommand, IEvaluationContext snapshot) {
        super(parentShell);
        this.setShellStyle(3312);
        this.fCCP = new CommandComposerPart();
        this.fCCP.setFilterType(filterType);
        this.fCCP.setPresetCommand(preselectedCommand);
        this.fCCP.setSnapshotContext(snapshot);
    }

    protected void createFormContent(IManagedForm mform) {
        ScrolledForm form = mform.getForm();
        mform.getToolkit().decorateFormHeading(form.getForm());
        this.initializeDialogUnits((Control)form);
        this.fCCP.createCC(form, mform.getToolkit(), new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommandComposerDialog.this.updateOkButtonEnablement(event.getSelection());
            }
        });
        CommandComposerDialog.applyDialogFont((Control)form);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.fOKButton = this.getButton(0);
        CommandList list = this.fCCP.getCommandList();
        if (list == null) {
            this.updateOkButtonEnablement(false);
            return;
        }
        ISelection selection = list.getSelection();
        this.updateOkButtonEnablement(selection);
    }

    private void updateOkButtonEnablement(Object selection) {
        if (selection == null) {
            this.updateOkButtonEnablement(false);
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            this.updateOkButtonEnablement(false);
            return;
        }
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection.getFirstElement() instanceof Command) {
            this.updateOkButtonEnablement(true);
            return;
        }
        this.updateOkButtonEnablement(false);
    }

    private void updateOkButtonEnablement(boolean enabled) {
        if (this.fOKButton != null) {
            this.fOKButton.setEnabled(enabled);
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(PDEUIMessages.CommandSerializerPart_name);
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.command_composer_dialog");
    }

    public void okPressed() {
        this.fPC = this.fCCP.getParameterizedCommand();
        super.okPressed();
    }

    public boolean close() {
        this.fCCP.dispose();
        return super.close();
    }

    public ParameterizedCommand getCommand() {
        return this.fPC;
    }
}

