/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.LauncherUtilsStatusHandler;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PluginValidationStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        if (status.getCode() == 1000) {
            return this.createExtensionError((String)source);
        }
        if (status.getCode() == 1001) {
            this.displayValidationError((LaunchValidationOperation)source);
        }
        return null;
    }

    private Object createExtensionError(String bundleID) {
        String name = NLS.bind((String)PDEMessages.EclipsePluginValidationOperation_pluginMissing, (Object)bundleID);
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        Image image = provider.get(PDEPluginImages.DESC_PLUGIN_OBJ);
        return new NamedElement(name, image);
    }

    private void displayValidationError(final LaunchValidationOperation op) throws CoreException {
        final int[] result = new int[1];
        final Display display = LauncherUtilsStatusHandler.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                PluginStatusDialog dialog = new PluginStatusDialog(display.getActiveShell());
                dialog.showCancelButton(true);
                dialog.setInput(op.getInput());
                result[0] = dialog.open();
            }
        });
        if (result[0] == 1) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }
}

