/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.importing.IBundleImporter;
import org.eclipse.pde.internal.core.importing.provisional.BundleImportDescription;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.provisional.IBundeImportWizardPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizard;

public class RepositoryImportWizard
extends Wizard {
    private Map fImportMap;
    private Map fIdToPages = new HashMap();
    private static final String STORE_SECTION = "RepositoryImportWizard";

    public RepositoryImportWizard(Map importMap) {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_IMPORT_WIZ);
        this.setWindowTitle(PDEUIMessages.ImportWizard_title);
        this.fImportMap = importMap;
    }

    public void addPages() {
        Iterator iterator = this.fImportMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IBundleImporter importer = (IBundleImporter)entry.getKey();
            BundleImportDescription[] descriptions = (BundleImportDescription[])entry.getValue();
            IBundeImportWizardPage page = (IBundeImportWizardPage)this.fIdToPages.get(importer.getId());
            if (page != null || (page = this.getImportPage(importer.getId())) == null) continue;
            this.fIdToPages.put(importer.getId(), page);
            this.addPage(page);
            page.setSelection(descriptions);
        }
    }

    private IBundeImportWizardPage getImportPage(String importerId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.pde.ui.bundleImportPages");
        if (point != null) {
            IConfigurationElement[] infos = point.getConfigurationElements();
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement element = infos[i];
                String id = element.getAttribute("bundleImporter");
                if (id != null && importerId.equals(id)) {
                    try {
                        return (IBundeImportWizardPage)element.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        HashMap<Object, BundleImportDescription[]> importMap = new HashMap<Object, BundleImportDescription[]>();
        ArrayList<Object> plugins = new ArrayList<Object>();
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IBundeImportWizardPage page = (IBundeImportWizardPage)pages[i];
            if (page.finish()) {
                BundleImportDescription[] descriptions = page.getSelection();
                if (descriptions != null && descriptions.length > 0) {
                    int j = 0;
                    while (j < descriptions.length) {
                        Object plugin;
                        Object importer;
                        BundleImportDescription description = descriptions[j];
                        if (j == 0 && (importer = description.getProperty("BUNDLE_IMPORTER")) != null) {
                            importMap.put(importer, descriptions);
                        }
                        if ((plugin = description.getProperty("PLUGIN")) != null) {
                            plugins.add(plugin);
                        }
                        ++j;
                    }
                }
            } else {
                return false;
            }
            ++i;
        }
        if (!importMap.isEmpty()) {
            PluginImportWizard.doImportOperation(4, plugins.toArray(new IPluginModelBase[plugins.size()]), false, false, null, importMap);
        }
        return true;
    }
}

