/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractPDELaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void initializeFrom(ILaunchConfiguration configuration) {
        final ILaunchConfiguration config = configuration;
        final ILaunchConfigurationTab[] tabs = this.getTabs();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    if (config instanceof ILaunchConfigurationWorkingCopy) {
                        AbstractPDELaunchConfigurationTabGroup.this.checkBackwardCompatibility((ILaunchConfigurationWorkingCopy)config);
                    }
                }
                catch (CoreException coreException) {}
                int i = 0;
                while (i < tabs.length) {
                    tabs[i].initializeFrom(config);
                    ++i;
                }
            }
        });
    }

    private void checkBackwardCompatibility(ILaunchConfigurationWorkingCopy wc) throws CoreException {
        String value;
        String id = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (id == null) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        }
        if ((value = wc.getAttribute("vmargs", null)) != null) {
            wc.setAttribute("vmargs", null);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, value);
        }
        if ((value = wc.getAttribute("progargs", null)) != null) {
            wc.setAttribute("progargs", null);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, value);
        }
        if ((value = wc.getAttribute("location0", null)) != null) {
            wc.setAttribute("location0", null);
            wc.setAttribute("location", value);
        }
        BundleLauncherHelper.checkBackwardCompatibility((ILaunchConfiguration)wc, (boolean)false);
        if (wc.isDirty()) {
            wc.doSave();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String vmArgs;
        super.setDefaults(configuration);
        if (TargetPlatformHelper.usesNewApplicationModel()) {
            configuration.setAttribute("pde.version", "3.3");
        } else if (TargetPlatformHelper.getTargetVersion() >= 3.2) {
            configuration.setAttribute("pde.version", "3.2a");
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        String programArgs = LaunchArgumentsHelper.getInitialProgramArguments().trim();
        if (programArgs.length() > 0) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
        }
        if ((vmArgs = LaunchArgumentsHelper.getInitialVMArguments().trim()).length() > 0) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
        configuration.setAttribute("append.args", true);
    }
}

