/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.util.xml.ExTagListener;
import org.eclipse.equinox.internal.util.xml.Tag;
import org.eclipse.equinox.internal.util.xml.XMLParser;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class DeclarationParser
implements ExTagListener {
    private static final String XMLNS_1_0 = "http://www.osgi.org/xmlns/scr/v1.0.0";
    private static final String XMLNS_1_1 = "http://www.osgi.org/xmlns/scr/v1.1.0";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String COMPONENT_TAG_NAME = "component";
    private static final String ATTR_AUTOENABLE = "enabled";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FACTORY = "factory";
    private static final String ATTR_IMMEDIATE = "immediate";
    private static final String ATTR_CONF_POLICY = "configuration-policy";
    private static final String ATTR_ACTIVATE = "activate";
    private static final String ATTR_DEACTIVATE = "deactivate";
    private static final String ATTR_MODIFIED = "modified";
    private static final String TAG_IMPLEMENTATION = "implementation";
    private static final String ATTR_CLASS = "class";
    private static final String TAG_PROPERTY = "property";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TYPE = "type";
    private static final String TAG_PROPERTIES = "properties";
    private static final String ATTR_ENTRY = "entry";
    private static final String TAG_SERVICE = "service";
    private static final String ATTR_SERVICEFACTORY = "servicefactory";
    private static final String TAG_PROVIDE = "provide";
    private static final String ATTR_INTERFACE = "interface";
    private static final String TAG_REFERENCE = "reference";
    private static final String ATTR_CARDINALITY = "cardinality";
    private static final String ATTR_POLICY = "policy";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_BIND = "bind";
    private static final String ATTR_UNBIND = "unbind";
    public Vector components;
    private Bundle bundle;
    private BundleContext bc;
    private ServiceComponent currentComponent;
    private String closeTag;
    boolean immediateSet = false;
    private Hashtable namespaces = null;
    private boolean rootPassed = false;
    private String currentURL = null;

    public void parse(InputStream in, Bundle bundle, Vector components, String processingURL) throws Exception {
        this.components = components;
        this.bundle = bundle;
        this.bc = bundle.getBundleContext();
        this.currentURL = processingURL;
        this.rootPassed = false;
        XMLParser.parseXML(in, (ExTagListener)this, -1);
        this.bundle = null;
        this.bc = null;
        this.currentComponent = null;
        this.currentURL = null;
        this.closeTag = null;
        this.namespaces = null;
    }

    public final void startTag(Tag tag) {
        try {
            try {
                this.processNamespacesEnter(tag);
                String tagName = tag.getName();
                if (this.isCorrectComponentTag(tagName)) {
                    this.doCorrectComponentTag(tag, tagName);
                }
            }
            catch (IllegalArgumentException iae) {
                this.currentComponent = null;
                this.closeTag = null;
                Activator.log(this.bundle.getBundleContext(), 1, String.valueOf(NLS.bind((String)Messages.ERROR_PROCESSING_START_TAG, (Object)this.currentURL, (Object)this.bundle)) + iae.getMessage(), null);
                if (Activator.DEBUG) {
                    Activator.log.debug("[SCR] Tracing the last exception", (Throwable)iae);
                }
                if (!this.rootPassed) {
                    this.rootPassed = true;
                }
            }
            catch (Throwable e) {
                Activator.log(this.bundle.getBundleContext(), 1, NLS.bind((String)Messages.ERROR_PROCESSING_START_TAG, (Object)this.currentURL, (Object)this.bundle), e);
                if (!this.rootPassed) {
                    this.rootPassed = true;
                }
            }
        }
        finally {
            if (!this.rootPassed) {
                this.rootPassed = true;
            }
        }
    }

    private void doEndTag(Tag tag) throws InvalidSyntaxException {
        if (this.currentComponent != null) {
            String tagName = tag.getName().intern();
            if (tagName == TAG_IMPLEMENTATION) {
                this.doImplementation(tag);
            } else if (tagName == TAG_PROPERTY) {
                this.doProperty(tag);
            } else if (tagName == TAG_PROPERTIES) {
                this.doProperties(tag);
            } else if (tagName == TAG_SERVICE) {
                this.doService(tag);
            } else if (tagName == TAG_REFERENCE) {
                this.doReference(tag);
            } else if (tagName != TAG_PROVIDE) {
                if (tagName == this.closeTag) {
                    if (!this.immediateSet && this.currentComponent.factory == null) {
                        this.currentComponent.setImmediate(this.currentComponent.serviceInterfaces == null);
                    }
                    this.currentComponent.validate(tag.getLine(), this.isNamespace11(tag.getName()));
                    if (this.components == null) {
                        this.components = new Vector(1, 1);
                    }
                    this.components.addElement(this.currentComponent);
                    this.currentComponent = null;
                    this.closeTag = null;
                } else {
                    IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.ILLEGAL_TAG_FOUND, (Object)tagName, (Object)Integer.toString(tag.getLine())));
                    throw e;
                }
            }
        }
    }

    public final void endTag(Tag tag) {
        try {
            this.doEndTag(tag);
            this.processNamespacesLeave(tag);
        }
        catch (IllegalArgumentException iae) {
            this.currentComponent = null;
            this.closeTag = null;
            Activator.log(this.bundle.getBundleContext(), 1, String.valueOf(NLS.bind((String)Messages.ERROR_PROCESSING_END_TAG, (Object)this.currentURL, (Object)this.bundle)) + iae.getMessage(), null);
            if (Activator.DEBUG) {
                Activator.log.debug("[SCR] Tracing the last exception", (Throwable)iae);
            }
        }
        catch (Throwable e) {
            this.currentComponent = null;
            this.closeTag = null;
            Activator.log(this.bundle.getBundleContext(), 1, NLS.bind((String)Messages.ERROR_PROCESSING_END_TAG, (Object)this.currentURL, (Object)this.bundle), e);
        }
    }

    private int getCardinality(String value) {
        if ("0..1".equals(value)) {
            return 0;
        }
        if ("0..n".equals(value)) {
            return 1;
        }
        if ("1..1".equals(value)) {
            return 2;
        }
        if ("1..n".equals(value)) {
            return 3;
        }
        return -1;
    }

    private void doReference(Tag tag) throws InvalidSyntaxException {
        String name = tag.getAttribute(ATTR_NAME);
        String iface = tag.getAttribute(ATTR_INTERFACE);
        if (iface == null) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.NO_INTERFACE_ATTR_IN_REFERENCE_TAG, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        String cardinalityS = tag.getAttribute(ATTR_CARDINALITY);
        int cardinality = 2;
        if (cardinalityS != null && (cardinality = this.getCardinality(cardinalityS)) < 0) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_CARDINALITY_ATTR, (Object)cardinalityS, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        String policyS = tag.getAttribute(ATTR_POLICY);
        int policy = 0;
        if (policyS != null) {
            if (policyS.equals("static")) {
                policy = 0;
            } else if (policyS.equals("dynamic")) {
                policy = 1;
            } else {
                IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_POLICY_ATTR, (Object)policyS, (Object)Integer.toString(tag.getLine())));
                throw e;
            }
        }
        String bind = tag.getAttribute(ATTR_BIND);
        String unbind = tag.getAttribute(ATTR_UNBIND);
        if (bind != null) {
            if (bind.equals("")) {
                IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_REFERENCE_TAG__BIND_ATTR_EMPTY, (Object)Integer.toString(tag.getLine())));
                throw e;
            }
            if (bind.equals(unbind)) {
                IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_REFERENCE_TAG__BIND_EQUALS_UNBIND, (Object)Integer.toString(tag.getLine())));
                throw e;
            }
        }
        if (unbind != null && unbind.equals("")) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_REFERENCE_TAG__UNBIND_ATTR_EMPTY, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        ComponentReference ref = new ComponentReference(this.currentComponent);
        ref.name = name;
        ref.interfaceName = iface;
        ref.cardinality = cardinality;
        ref.policy = policy;
        ref.bind = bind;
        ref.unbind = unbind;
        ref.target = tag.getAttribute(ATTR_TARGET);
        if (ref.target != null) {
            Activator.createFilter(ref.target);
        }
    }

    private void doImplementation(Tag tag) {
        if (this.currentComponent.implementation != null) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_COMPONENT_TAG__MULTIPLE_IMPL_ATTRIBS, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        String tmp = tag.getAttribute(ATTR_CLASS);
        if (tmp == null) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_COMPONENT_TAG__NO_CLASS_ATTR, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        this.currentComponent.implementation = tmp;
    }

    private void doService(Tag tag) {
        int size;
        String tmp = tag.getAttribute(ATTR_SERVICEFACTORY);
        if (tmp != null) {
            this.currentComponent.serviceFactory = Boolean.valueOf(tmp);
        }
        if ((size = tag.size()) == 0) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_SERVICE_TAG__NO_PROVIDE_TAG, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        if (this.currentComponent.serviceInterfaces != null) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.DUPLICATED_SERVICE_TAGS, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        int i = 0;
        while (i < size) {
            String iFace;
            Tag p = tag.getTagAt(i);
            String pName = p.getName().intern();
            if (pName == TAG_PROVIDE) {
                iFace = p.getAttribute(ATTR_INTERFACE);
                if (iFace == null) {
                    IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_PROVIDE_TAG__NO_INTERFACE_ATTR, (Object)Integer.toString(tag.getLine())));
                    throw e;
                }
                if (this.currentComponent.serviceInterfaces == null) {
                    this.currentComponent.serviceInterfaces = new Vector(size);
                }
            } else {
                IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.ILLEGAL_ELEMENT_IN_SERVICE_TAG, (Object)pName, (Object)Integer.toString(tag.getLine())));
                throw e;
            }
            this.currentComponent.serviceInterfaces.addElement(iFace);
            ++i;
        }
    }

    private void doProperty(Tag tag) {
        String name = null;
        try {
            Object _value;
            int mtType;
            name = tag.getAttribute(ATTR_NAME);
            if (name == null) {
                IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_PROPERTY_TAG__NO_NAME_ATTR, (Object)Integer.toString(tag.getLine())));
                throw e;
            }
            String type = tag.getAttribute(ATTR_TYPE);
            if (type == null || "String".equals(type)) {
                mtType = 1;
            } else if ("Boolean".equals(type)) {
                mtType = 11;
            } else if ("Integer".equals(type)) {
                mtType = 3;
            } else if ("Long".equals(type)) {
                mtType = 2;
            } else if ("Char".equals(type) || "Character".equals(type)) {
                mtType = 5;
            } else if ("Double".equals(type)) {
                mtType = 7;
            } else if ("Float".equals(type)) {
                mtType = 8;
            } else if ("Byte".equals(type)) {
                mtType = 6;
            } else if ("Short".equals(type)) {
                mtType = 4;
            } else {
                IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_PROPERTY_TYPE, (Object)type, (Object)Integer.toString(tag.getLine())));
                throw e;
            }
            String value = tag.getAttribute(ATTR_VALUE);
            if (value != null) {
                _value = DeclarationParser.makeObject(value, mtType);
            } else {
                value = tag.getContent();
                if (value == null) {
                    IllegalArgumentException e = new IllegalArgumentException(Messages.INVALID_PROPERTY_TAG__NO_BODY_CONTENT);
                    throw e;
                }
                StringTokenizer tok = new StringTokenizer(value, "\n\r");
                Vector<String> el = new Vector<String>(10);
                while (tok.hasMoreTokens()) {
                    String next = tok.nextToken().trim();
                    if (next.length() <= 0) continue;
                    el.addElement(next);
                }
                if (el.size() == 0) {
                    IllegalArgumentException e = new IllegalArgumentException(Messages.INVALID_PROPERTY_TAG__NO_BODY_CONTENT);
                    throw e;
                }
                Object[] values = new String[el.size()];
                el.copyInto(values);
                _value = DeclarationParser.makeArr((String[])values, mtType);
            }
            if (this.currentComponent.properties == null) {
                this.currentComponent.properties = new Properties();
            }
            this.currentComponent.properties.put(name, _value);
        }
        catch (IllegalArgumentException iae) {
            Activator.log(this.bundle.getBundleContext(), 1, String.valueOf(NLS.bind((String)Messages.ERROR_PROCESSING_PROPERTY, (Object)name, (Object)this.currentURL)) + iae.getMessage(), null);
            if (Activator.DEBUG) {
                Activator.log.debug("[SCR] Tracing the last exception", (Throwable)iae);
            }
        }
        catch (Throwable e) {
            Activator.log(this.bundle.getBundleContext(), 1, NLS.bind((String)Messages.ERROR_PROCESSING_PROPERTY, (Object)name, (Object)this.currentURL), e);
        }
    }

    private void doProperties(Tag tag) {
        String fileEntry = tag.getAttribute(ATTR_ENTRY);
        if (fileEntry == null) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_PROPERTIES_TAG__NO_ENTRY_ATTR, (Object)Integer.toString(tag.getLine())));
            throw e;
        }
        InputStream is = null;
        try {
            URL resource = this.bundle.getEntry(fileEntry);
            is = resource != null ? resource.openStream() : null;
        }
        catch (IOException iOException) {}
        boolean invalid = true;
        if (is != null) {
            if (this.currentComponent.properties == null) {
                this.currentComponent.properties = new Properties();
            }
            try {
                this.currentComponent.properties.load(is);
                invalid = false;
            }
            catch (IOException e) {
                Activator.log(this.bundle.getBundleContext(), 1, Messages.ERROR_LOADING_PROPERTIES_FILE, e);
            }
        }
        if (invalid) {
            IllegalArgumentException e = new IllegalArgumentException(NLS.bind((String)Messages.INVALID_PROPERTIES_TAG__INVALID_ENTRY_VALUE, (Object)Integer.toString(tag.getLine()), (Object)fileEntry));
            throw e;
        }
    }

    private void doCorrectComponentTag(Tag tag, String tagName) {
        this.closeTag = tagName.intern();
        String tmp = tag.getAttribute(ATTR_NAME);
        this.immediateSet = false;
        this.currentComponent = new ServiceComponent();
        this.currentComponent.bundle = this.bundle;
        this.currentComponent.bc = this.bc;
        this.currentComponent.name = tmp;
        tmp = tag.getAttribute(ATTR_AUTOENABLE);
        if (tmp != null) {
            this.currentComponent.autoenable = Boolean.valueOf(tmp);
        }
        if ((tmp = tag.getAttribute(ATTR_FACTORY)) != null && tmp.length() == 0) {
            tmp = null;
        }
        this.currentComponent.factory = tmp;
        tmp = tag.getAttribute(ATTR_IMMEDIATE);
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        if (tmp != null) {
            this.currentComponent.immediate = Boolean.valueOf(tmp);
            this.immediateSet = true;
        }
        if (this.isNamespace11(tagName)) {
            tmp = tag.getAttribute(ATTR_CONF_POLICY);
            if (tmp != null && tmp.length() == 0) {
                tmp = null;
            }
            if (tmp != null) {
                this.currentComponent.configurationPolicy = tmp.intern();
            }
            if ((tmp = tag.getAttribute(ATTR_ACTIVATE)) != null && tmp.length() == 0) {
                tmp = null;
            }
            if (tmp != null) {
                this.currentComponent.activateMethodName = tmp;
                this.currentComponent.activateMethodDeclared = true;
            }
            if ((tmp = tag.getAttribute(ATTR_DEACTIVATE)) != null && tmp.length() == 0) {
                tmp = null;
            }
            if (tmp != null) {
                this.currentComponent.deactivateMethodName = tmp;
                this.currentComponent.deactivateMethodDeclared = true;
            }
            if ((tmp = tag.getAttribute(ATTR_MODIFIED)) != null && tmp.length() == 0) {
                tmp = null;
            }
            if (tmp != null) {
                this.currentComponent.modifyMethodName = tmp;
            }
        } else {
            if (tag.getAttribute(ATTR_CONF_POLICY) != null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_TAG_ACCORDING_TO_NAMESPACE1_0, (Object)ATTR_CONF_POLICY, (Object)Integer.toString(tag.getLine())));
            }
            if (tag.getAttribute(ATTR_ACTIVATE) != null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_TAG_ACCORDING_TO_NAMESPACE1_0, (Object)ATTR_ACTIVATE, (Object)Integer.toString(tag.getLine())));
            }
            if (tag.getAttribute(ATTR_DEACTIVATE) != null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_TAG_ACCORDING_TO_NAMESPACE1_0, (Object)ATTR_DEACTIVATE, (Object)Integer.toString(tag.getLine())));
            }
            if (tag.getAttribute(ATTR_MODIFIED) != null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.INVALID_TAG_ACCORDING_TO_NAMESPACE1_0, (Object)ATTR_MODIFIED, (Object)Integer.toString(tag.getLine())));
            }
        }
    }

    private boolean isCorrectComponentTag(String tagName) {
        String localTagName;
        String qualifier = this.getNamespaceQualifier(tagName);
        String string = localTagName = qualifier.length() == 0 ? tagName : tagName.substring(qualifier.length() + 1);
        if (!localTagName.equals(COMPONENT_TAG_NAME)) {
            return false;
        }
        String namespace = this.getCurrentNamespace(qualifier);
        if (!this.rootPassed) {
            return namespace.length() == 0 || namespace.equals(XMLNS_1_0) || namespace.equals(XMLNS_1_1);
        }
        return namespace.equals(XMLNS_1_0) || namespace.equals(XMLNS_1_1);
    }

    public static Object makeObject(String string, int syntax) throws IllegalArgumentException {
        try {
            switch (syntax) {
                case 1: {
                    return string;
                }
                case 3: {
                    return new Integer(string);
                }
                case 2: {
                    return new Long(string);
                }
                case 8: {
                    return new Float(string);
                }
                case 7: {
                    return new Double(string);
                }
                case 6: {
                    return new Byte(string);
                }
                case 4: {
                    return new Short(string);
                }
                case 5: {
                    if (string.length() == 0) {
                        throw new IllegalArgumentException(Messages.MISSING_CHARACTER);
                    }
                    return new Character(string.charAt(0));
                }
                case 11: {
                    return Boolean.valueOf(string);
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.UNSUPPORTED_TYPE, (Object)String.valueOf(syntax)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.INCORRECT_VALUE_TYPE, (Object)string));
        }
    }

    public static Object makeArr(String[] array, int syntax) throws IllegalArgumentException {
        switch (syntax) {
            case 1: {
                return array;
            }
            case 3: {
                int[] ints = new int[array.length];
                int i = 0;
                while (i < array.length) {
                    ints[i] = Integer.parseInt(array[i]);
                    ++i;
                }
                return ints;
            }
            case 2: {
                long[] longs = new long[array.length];
                int i = 0;
                while (i < array.length) {
                    longs[i] = Long.parseLong(array[i]);
                    ++i;
                }
                return longs;
            }
            case 8: {
                float[] floats = new float[array.length];
                int i = 0;
                while (i < array.length) {
                    floats[i] = Float.valueOf(array[i]).floatValue();
                    ++i;
                }
                return floats;
            }
            case 7: {
                double[] doubles = new double[array.length];
                int i = 0;
                while (i < array.length) {
                    doubles[i] = Double.valueOf(array[i]);
                    ++i;
                }
                return doubles;
            }
            case 6: {
                byte[] bytes = new byte[array.length];
                int i = 0;
                while (i < array.length) {
                    bytes[i] = Byte.parseByte(array[i]);
                    ++i;
                }
                return bytes;
            }
            case 4: {
                short[] shorts = new short[array.length];
                int i = 0;
                while (i < array.length) {
                    shorts[i] = Short.parseShort(array[i]);
                    ++i;
                }
                return shorts;
            }
            case 5: {
                char[] chars = new char[array.length];
                int i = 0;
                while (i < array.length) {
                    chars[i] = array[i].charAt(0);
                    ++i;
                }
                return chars;
            }
            case 11: {
                boolean[] booleans = new boolean[array.length];
                int i = 0;
                while (i < array.length) {
                    booleans[i] = Boolean.valueOf(array[i]);
                    ++i;
                }
                return booleans;
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.UNSUPPORTED_TYPE, (Object)String.valueOf(syntax)));
    }

    private boolean isNamespace11(String tagName) {
        String qualifier = this.getNamespaceQualifier(tagName);
        String namespace = this.getCurrentNamespace(qualifier);
        if (!this.rootPassed) {
            return namespace.length() != 0 && namespace.equals(XMLNS_1_1);
        }
        return namespace.equals(XMLNS_1_1);
    }

    private void processNamespacesEnter(Tag tag) {
        Enumeration en = tag.getAttributeNames();
        while (en.hasMoreElements()) {
            String qualifier;
            String attrName = (String)en.nextElement();
            if (!attrName.startsWith(ATTR_XMLNS) || (qualifier = attrName.substring(ATTR_XMLNS.length())).length() != 0 && (qualifier.charAt(0) != ':' || (qualifier = qualifier.substring(1)).length() <= 0)) continue;
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
            Stack<String> stack = null;
            stack = (Stack<String>)this.namespaces.get(qualifier);
            if (stack == null) {
                stack = new Stack<String>();
                this.namespaces.put(qualifier, stack);
            }
            stack.push(tag.getAttribute(attrName));
        }
    }

    private String getCurrentNamespace(String qualifier) {
        if (this.namespaces == null || qualifier == null) {
            return "";
        }
        Stack stack = (Stack)this.namespaces.get(qualifier);
        if (stack == null || stack.empty()) {
            return "";
        }
        return (String)stack.peek();
    }

    private void processNamespacesLeave(Tag tag) {
        if (this.namespaces == null) {
            return;
        }
        Enumeration en = tag.getAttributeNames();
        while (en.hasMoreElements()) {
            Stack stack;
            String qualifier;
            String attrName = (String)en.nextElement();
            if (!attrName.startsWith(ATTR_XMLNS) || (qualifier = attrName.substring(ATTR_XMLNS.length())).length() != 0 && (qualifier.charAt(0) != ':' || (qualifier = qualifier.substring(1)).length() <= 0) || (stack = (Stack)this.namespaces.get(qualifier)) == null) continue;
            if (!stack.empty()) {
                stack.pop();
            }
            if (!stack.empty()) continue;
            this.namespaces.remove(qualifier);
        }
    }

    private String getNamespaceQualifier(String name) {
        int index = name.indexOf(58);
        if (index < 0) {
            return "";
        }
        return name.substring(0, index);
    }
}

