/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXButton
extends JButton {
    private String text;
    private boolean borderPainted = true;
    private boolean contentAreaFilled = true;
    private static final Painter<JXButton> DEFAULT_BACKGROUND_PAINTER = new DefaultBackgroundPainter();
    private static final Painter<JXButton> DEFAULT_FOREGROUND_PAINTER = new DefaultForegroundPainter();
    private Painter<JXButton> fgPainter = DEFAULT_FOREGROUND_PAINTER;
    private Painter<JXButton> bgPainter = DEFAULT_BACKGROUND_PAINTER;
    private boolean paintBorderInsets = true;
    private boolean painting;

    public JXButton() {
    }

    public JXButton(String text) {
        super(text);
    }

    public JXButton(Action a) {
        super(a);
    }

    public JXButton(Icon icon) {
        super(icon);
    }

    public JXButton(String text, Icon icon) {
        super(text, icon);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        super.setText(text);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setBorderPainted(boolean b) {
        this.borderPainted = b;
        super.setBorderPainted(b);
    }

    @Override
    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    @Override
    public void setContentAreaFilled(boolean b) {
        this.contentAreaFilled = b;
        super.setContentAreaFilled(b);
    }

    @Override
    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public Painter<JXButton> getBackgroundPainter() {
        return this.bgPainter;
    }

    public void setBackgroundPainter(Painter<JXButton> p) {
        Painter<JXButton> old = this.getBackgroundPainter();
        this.bgPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter<JXButton> getForegroundPainter() {
        return this.fgPainter;
    }

    public void setForegroundPainter(Painter<JXButton> p) {
        Painter<JXButton> old = this.getForegroundPainter();
        this.fgPainter = p;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Painter<JXButton> bgPainter = this.getBackgroundPainter();
        Painter<JXButton> fgPainter = this.getForegroundPainter();
        if (this.painting || bgPainter == null && fgPainter == null) {
            super.paintComponent(g);
        } else {
            this.invokePainter(g, bgPainter);
            this.invokePainter(g, fgPainter);
        }
    }

    private void invokePainter(Graphics g, Painter<JXButton> ptr) {
        if (ptr == null) {
            return;
        }
        if (this.isPaintBorderInsets()) {
            ptr.paint((Graphics2D)g, this, this.getWidth(), this.getHeight());
        } else {
            Graphics2D g2 = (Graphics2D)g;
            Insets ins = this.getInsets();
            g2.translate(ins.left, ins.top);
            ptr.paint(g2, this, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            g2.translate(-ins.left, -ins.top);
        }
    }

    protected void setPainting(boolean b) {
        this.painting = b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultForegroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultForegroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JXButton b, int width, int height) {
            b.setPainting(true);
            boolean t1 = b.isBorderPainted();
            boolean t2 = b.isContentAreaFilled();
            b.borderPainted = false;
            b.contentAreaFilled = false;
            b.paint(g);
            b.borderPainted = t1;
            b.contentAreaFilled = t2;
            b.setPainting(false);
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultBackgroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultBackgroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JXButton b, int width, int height) {
            b.setPainting(true);
            String tmp = b.text;
            b.text = "";
            b.paint(g);
            b.text = tmp;
            b.setPainting(false);
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }
}

