/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeySequenceInputPanel
extends JPanel {
    public static final String PROP_KEYSEQUENCE = "keySequence";
    private Vector strokes = new Vector();
    private StringBuffer text = new StringBuffer();
    private final ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
    public JTextArea collisionLabel;
    public JTextField keySequenceInputField;
    public JLabel keySequenceLabel;

    public KeySequenceInputPanel() {
        this.initComponents();
        this.keySequenceInputField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_LBL_KSIP_Sequence"));
        this.getAccessibleContext().setAccessibleName(this.bundle.getString("MSP_AddTitle"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_KSIP"));
        this.keySequenceInputField.setFocusTraversalKeysEnabled(false);
    }

    public void clear() {
        this.strokes.clear();
        this.text.setLength(0);
        this.keySequenceInputField.setText(this.text.toString());
        this.firePropertyChange(PROP_KEYSEQUENCE, null, null);
    }

    public void setInfoText(String string) {
        this.collisionLabel.setText(string + ' ');
    }

    public KeyStroke[] getKeySequence() {
        return this.strokes.toArray(new KeyStroke[0]);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        return dimension;
    }

    public void requestFocus() {
        this.keySequenceInputField.requestFocus();
    }

    private void initComponents() {
        this.keySequenceLabel = new JLabel();
        this.keySequenceInputField = new JTextField();
        this.collisionLabel = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        this.keySequenceLabel.setLabelFor(this.keySequenceInputField);
        Mnemonics.setLocalizedText((JLabel)this.keySequenceLabel, (String)this.bundle.getString("LBL_KSIP_Sequence"));
        this.keySequenceLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.keySequenceLabel, gridBagConstraints);
        this.keySequenceInputField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                KeySequenceInputPanel.this.keySequenceInputFieldKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                KeySequenceInputPanel.this.keySequenceInputFieldKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                KeySequenceInputPanel.this.keySequenceInputFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.keySequenceInputField, gridBagConstraints);
        this.collisionLabel.setLineWrap(true);
        this.collisionLabel.setEditable(false);
        this.collisionLabel.setRows(2);
        this.collisionLabel.setForeground(Color.red);
        this.collisionLabel.setBackground(this.getBackground());
        this.collisionLabel.setDisabledTextColor(Color.red);
        this.collisionLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.collisionLabel, gridBagConstraints);
    }

    private void keySequenceInputFieldKeyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    private void keySequenceInputFieldKeyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
        this.keySequenceInputField.setText(this.text.toString());
    }

    private void keySequenceInputFieldKeyPressed(KeyEvent keyEvent) {
        String string = this.keySequenceInputField.getText();
        if (keyEvent.getModifiers() == 0 && KeyStroke.getKeyStroke(9, 0).equals(KeyStroke.getKeyStrokeForEvent(keyEvent)) && string != null && string.length() > 0) {
            this.keySequenceInputField.transferFocus();
            return;
        }
        keyEvent.consume();
        String string2 = KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
        if (this.isModifier(keyEvent.getKeyCode())) {
            this.keySequenceInputField.setText(this.text.toString() + string2 + '+');
        } else {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            this.strokes.add(keyStroke);
            this.text.append(Utilities.keyStrokeToString(keyStroke));
            this.text.append(' ');
            this.keySequenceInputField.setText(this.text.toString());
            this.firePropertyChange(PROP_KEYSEQUENCE, null, null);
        }
    }

    private boolean isModifier(int n) {
        return n == 18 || n == 65406 || n == 17 || n == 16 || n == 157;
    }
}

