/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.pdf.ReconfigureReaderPanel;
import org.netbeans.modules.pdf.Settings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class PDFOpenSupport
implements OpenCookie {
    private static final String DEFAULT_MACOS_VIEWER = "open";
    private static final String[] APP_DIRS = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final String[] VIEWER_NAMES = new String[]{"evince", "xpdf", "kghostview", "ggv", "acroread"};
    static final String FALLBACK_VIEWER_NAME = "acroread";
    private File f;

    public PDFOpenSupport(File file) {
        this.f = file;
    }

    public void open() {
        String string;
        boolean bl;
        String string2 = this.f.getAbsolutePath();
        if (Utilities.isWindows()) {
            PDFOpenSupport.tryCommand(new String[]{"cmd.exe", "/C", "start", "\"PDF Viewer\"", string2});
            return;
        }
        Settings settings = Settings.getDefault();
        File file = settings.getPDFViewer();
        boolean bl2 = bl = file == null;
        if (bl && Utilities.getOperatingSystem() == 4096 && PDFOpenSupport.tryCommand(new String[]{string = DEFAULT_MACOS_VIEWER, string2})) {
            settings.setPDFViewer(new File(string));
            return;
        }
        if (bl && (file = PDFOpenSupport.tryPredefinedViewers(string2)) != null) {
            settings.setPDFViewer(file);
            return;
        }
        if (bl) {
            file = new File(FALLBACK_VIEWER_NAME);
        }
        boolean bl3 = false;
        while (true) {
            try {
                PDFOpenSupport.tryCommandExc(new String[]{file.getPath(), string2});
                if (!bl && !bl3) break;
                settings.setPDFViewer(file);
            }
            catch (IOException iOException) {
                bl3 = true;
                String string3 = iOException.getLocalizedMessage();
                ReconfigureReaderPanel reconfigureReaderPanel = new ReconfigureReaderPanel(file, string3);
                String string4 = NbBundle.getMessage(PDFOpenSupport.class, (String)"TITLE_pick_a_viewer");
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)reconfigureReaderPanel, string4);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != DialogDescriptor.OK_OPTION) break;
                file = reconfigureReaderPanel.getSelectedFile();
                settings.setPDFViewer(file);
                continue;
            }
            break;
        }
    }

    private static File tryPredefinedViewers(String string) {
        for (int i = 0; i < APP_DIRS.length; ++i) {
            File file = new File(APP_DIRS[i]);
            if (!file.exists() || !file.isDirectory()) continue;
            for (int j = 0; j < VIEWER_NAMES.length; ++j) {
                String string2 = APP_DIRS[i] + File.separatorChar + VIEWER_NAMES[j];
                File file2 = new File(string2);
                if (!file2.exists() || !PDFOpenSupport.tryCommand(new String[]{string2, string})) continue;
                return file2;
            }
        }
        return null;
    }

    private static boolean tryCommand(String[] stringArray) {
        try {
            PDFOpenSupport.tryCommandExc(stringArray);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void tryCommandExc(String[] stringArray) throws IOException {
        Runtime.getRuntime().exec(stringArray);
    }
}

