/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class XmlFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    static final String DECODER_SELECTED = "decoder-selected";
    static final String ENCODER_SELECTED = "encoder-selected";
    private static final Logger LOG = Logger.getLogger(XmlFileEncodingQueryImpl.class.getName());
    private static final XmlFileEncodingQueryImpl singleton = new XmlFileEncodingQueryImpl();

    private XmlFileEncodingQueryImpl() {
    }

    public static XmlFileEncodingQueryImpl singleton() {
        return singleton;
    }

    public synchronized Charset getEncoding(FileObject fileObject) {
        assert (fileObject != null);
        return new XMLCharset();
    }

    private static class XMLDecoder
    extends CharsetDecoder {
        private ByteBuffer buffer = ByteBuffer.allocate(4096);
        private ByteBuffer remainder;
        private CharsetDecoder decoder;

        public XMLDecoder(Charset charset) {
            super(charset, 1.0f, 2.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (this.buffer == null) {
                assert (this.decoder != null);
                if (this.remainder != null) {
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.remainder.remaining() + byteBuffer.remaining());
                    byteBuffer2.put(this.remainder);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer2.flip();
                    CoderResult coderResult = this.decoder.decode(byteBuffer2, charBuffer, false);
                    this.remainder = byteBuffer2.hasRemaining() ? byteBuffer2 : null;
                    return coderResult;
                }
                return this.decoder.decode(byteBuffer, charBuffer, false);
            }
            if (this.buffer.remaining() == 0) {
                return this.handleHead(byteBuffer, charBuffer);
            }
            if (this.buffer.remaining() < byteBuffer.remaining()) {
                int n = byteBuffer.limit();
                byteBuffer.limit(byteBuffer.position() + this.buffer.remaining());
                this.buffer.put(byteBuffer);
                byteBuffer.limit(n);
                return this.handleHead(byteBuffer, charBuffer);
            }
            this.buffer.put(byteBuffer);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult handleHead(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            Charset charset;
            String string = null;
            try {
                string = this.getEncoding();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (string == null) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            this.decoder = charset.newDecoder();
            LOG.log(Level.FINEST, XmlFileEncodingQueryImpl.DECODER_SELECTED, this.decoder);
            return this.flushHead(byteBuffer, charBuffer);
        }

        private CoderResult flushHead(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            this.buffer.flip();
            CoderResult coderResult = this.decoder.decode(this.buffer, charBuffer, byteBuffer == null);
            if (coderResult.isOverflow()) {
                this.remainder = this.buffer;
                this.buffer = null;
                return coderResult;
            }
            this.buffer = null;
            if (byteBuffer == null) {
                return coderResult;
            }
            return this.decoder.decode(byteBuffer, charBuffer, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getEncoding() throws IOException {
            byte[] byArray = this.buffer.array();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                String string = EncodingUtil.detectEncoding(byteArrayInputStream);
                return string;
            }
            finally {
                byteArrayInputStream.close();
            }
        }

        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.buffer != null) {
                CoderResult coderResult = this.handleHead(null, charBuffer);
                return coderResult;
            }
            if (this.remainder != null) {
                this.decoder.decode(this.remainder, charBuffer, true);
            } else {
                ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(0).flip();
                this.decoder.decode(byteBuffer, charBuffer, true);
            }
            CoderResult coderResult = this.decoder.flush(charBuffer);
            return coderResult;
        }

        protected void implReset() {
            if (this.decoder != null) {
                this.decoder.reset();
            }
        }
    }

    private static class XMLEncoder
    extends CharsetEncoder {
        private CharBuffer buffer = CharBuffer.allocate(4096);
        private CharBuffer remainder;
        private CharsetEncoder encoder;

        public XMLEncoder(Charset charset) {
            super(charset, 1.0f, 2.0f);
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (this.buffer == null) {
                CoderResult coderResult;
                assert (this.encoder != null);
                if (this.remainder != null) {
                    coderResult = this.encoder.encode(this.remainder, byteBuffer, false);
                    if (!this.remainder.hasRemaining()) {
                        this.remainder = null;
                    }
                }
                coderResult = this.encoder.encode(charBuffer, byteBuffer, false);
                return coderResult;
            }
            if (this.buffer.remaining() == 0 || this.buffer.position() > 0 && charBuffer.limit() == 0) {
                return this.handleHead(charBuffer, byteBuffer);
            }
            if (this.buffer.remaining() < charBuffer.remaining()) {
                int n = charBuffer.limit();
                charBuffer.limit(charBuffer.position() + this.buffer.remaining());
                this.buffer.put(charBuffer);
                charBuffer.limit(n);
                return this.handleHead(charBuffer, byteBuffer);
            }
            this.buffer.put(charBuffer);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult handleHead(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            Charset charset;
            String string = null;
            try {
                string = this.getEncoding();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (string == null) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                this.buffer = null;
                XmlFileEncodingQueryImpl.throwUnknownEncoding();
                return null;
            }
            this.encoder = charset.newEncoder();
            LOG.log(Level.FINEST, XmlFileEncodingQueryImpl.ENCODER_SELECTED, this.encoder);
            return this.flushHead(charBuffer, byteBuffer);
        }

        private CoderResult flushHead(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            this.buffer.flip();
            CoderResult coderResult = this.encoder.encode(this.buffer, byteBuffer, charBuffer == null);
            if (coderResult.isOverflow()) {
                this.remainder = this.buffer;
                this.buffer = null;
                return coderResult;
            }
            this.buffer = null;
            if (charBuffer == null) {
                return coderResult;
            }
            return this.encoder.encode(charBuffer, byteBuffer, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getEncoding() throws IOException {
            String string = this.buffer.asReadOnlyBuffer().flip().toString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            try {
                String string2 = EncodingUtil.detectEncoding(byteArrayInputStream);
                return string2;
            }
            finally {
                ((InputStream)byteArrayInputStream).close();
            }
        }

        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.buffer != null) {
                CoderResult coderResult = this.handleHead(null, byteBuffer);
                return coderResult;
            }
            if (this.remainder != null) {
                this.encoder.encode(this.remainder, byteBuffer, true);
            } else {
                CharBuffer charBuffer = (CharBuffer)CharBuffer.allocate(0).flip();
                this.encoder.encode(charBuffer, byteBuffer, true);
            }
            CoderResult coderResult = this.encoder.flush(byteBuffer);
            return coderResult;
        }

        protected void implReset() {
            if (this.encoder != null) {
                this.encoder.reset();
            }
        }
    }

    private static class XMLCharset
    extends Charset {
        public XMLCharset() {
            super("UTF-8", new String[0]);
        }

        public boolean contains(Charset charset) {
            return false;
        }

        public CharsetDecoder newDecoder() {
            return new XMLDecoder(this);
        }

        public CharsetEncoder newEncoder() {
            return new XMLEncoder(this);
        }
    }
}

