/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPredicate
implements StarPredicate {
    protected final List<StarPredicate> children = new ArrayList<StarPredicate>();
    private HashMap<Integer, List<StarPredicate>> childrenHashMap = null;
    private int hashValue = 0;
    protected final List<RolapStar.Column> columns = new ArrayList<RolapStar.Column>();
    protected BitKey columnBitKey = null;

    protected ListPredicate(List<StarPredicate> predicateList) {
        for (StarPredicate predicate : predicateList) {
            this.columnBitKey = this.columnBitKey == null ? predicate.getConstrainedColumnBitKey().copy() : this.columnBitKey.or(predicate.getConstrainedColumnBitKey());
            this.children.add(predicate);
            for (RolapStar.Column column : predicate.getConstrainedColumnList()) {
                if (this.columns.contains(column)) continue;
                this.columns.add(column);
            }
        }
    }

    @Override
    public List<RolapStar.Column> getConstrainedColumnList() {
        return this.columns;
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        return this.columnBitKey;
    }

    public List<StarPredicate> getChildren() {
        return this.children;
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = 37;
            for (StarPredicate child : this.children) {
                int childHashCode = child.hashCode();
                if (childHashCode == 0) continue;
                this.hashValue *= childHashCode;
            }
            this.hashValue ^= this.children.size();
        }
        return this.hashValue;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        boolean isEqual;
        boolean bl = isEqual = that instanceof ListPredicate && this.getConstrainedColumnBitKey().equals(that.getConstrainedColumnBitKey());
        if (isEqual) {
            ListPredicate thatPred = (ListPredicate)that;
            if (this.getOp() != thatPred.getOp() || this.getChildren().size() != thatPred.getChildren().size()) {
                isEqual = false;
            }
            if (isEqual) {
                if (this.childrenHashMap == null) {
                    this.childrenHashMap = new HashMap();
                    for (StarPredicate thisChild : this.getChildren()) {
                        Integer key = new Integer(thisChild.hashCode());
                        List<StarPredicate> predList = this.childrenHashMap.get(key);
                        if (predList == null) {
                            predList = new ArrayList<StarPredicate>();
                        }
                        predList.add(thisChild);
                        this.childrenHashMap.put(key, predList);
                    }
                }
                for (StarPredicate thatChild : thatPred.getChildren()) {
                    List<StarPredicate> predList = this.childrenHashMap.get(thatChild.hashCode());
                    if (predList == null) {
                        isEqual = false;
                        break;
                    }
                    boolean foundMatch = false;
                    for (StarPredicate pred : predList) {
                        if (!thatChild.equalConstraint(pred)) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return isEqual;
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        throw Util.needToImplement(this);
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        if (this.children.size() == 1) {
            this.children.get(0).toSql(sqlQuery, buf);
        } else {
            int k = 0;
            buf.append("(");
            for (StarPredicate child : this.children) {
                if (k++ > 0) {
                    buf.append(" ").append(this.getOp()).append(" ");
                }
                child.toSql(sqlQuery, buf);
            }
            buf.append(")");
        }
    }

    protected abstract String getOp();

    @Override
    public void describe(StringBuilder buf) {
        buf.append(this.getOp()).append("(");
        int k = 0;
        for (StarPredicate child : this.children) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(child);
        }
        buf.append(')');
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.describe(buf);
        return buf.toString();
    }
}

