/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormattingSettingsFromNbPreferences
extends StorageFilter<String, TypedValue> {
    private static final Logger LOG = Logger.getLogger(FormattingSettingsFromNbPreferences.class.getName());
    private static final Map<String, String> affectedMimeTypes = new HashMap<String, String>();

    public FormattingSettingsFromNbPreferences() {
        super("Preferences");
    }

    public void afterLoad(Map<String, TypedValue> map, MimePath mimePath, String string, boolean bl) throws IOException {
        if (bl || mimePath.size() != 1 || !affectedMimeTypes.containsKey(mimePath.getPath())) {
            return;
        }
        try {
            Preferences preferences = this.getNbPreferences(mimePath.getPath());
            if (preferences != null && preferences.nodeExists("CodeStyle/default")) {
                Preferences preferences2 = preferences.node("CodeStyle/default");
                for (String string2 : preferences2.keys()) {
                    TypedValue typedValue;
                    if (map.containsKey(string2) || (typedValue = this.guessTypedValue(preferences2.get(string2, null))) == null) continue;
                    map.put(string2, typedValue);
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("Injecting '" + string2 + "' = '" + typedValue.getValue() + "' (" + typedValue.getJavaType() + ") for '" + mimePath.getPath() + "'");
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.FINE, null, backingStoreException);
        }
    }

    public void beforeSave(Map<String, TypedValue> map, MimePath mimePath, String string, boolean bl) throws IOException {
        if (bl || mimePath.size() != 1 || !affectedMimeTypes.containsKey(mimePath.getPath())) {
            return;
        }
        try {
            Preferences preferences = this.getNbPreferences(mimePath.getPath());
            if (preferences != null && preferences.nodeExists("CodeStyle/default")) {
                preferences.node("CodeStyle").removeNode();
                preferences.flush();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Cleaning up NbPreferences/CodeStyle node for '" + mimePath.getPath() + "'");
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.FINE, null, backingStoreException);
        }
    }

    private Preferences getNbPreferences(String string) {
        ClassLoader classLoader;
        Preferences preferences = null;
        String string2 = affectedMimeTypes.get(string);
        if (string2 != null && (classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)) != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string2);
                preferences = NbPreferences.forModule(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, null, classNotFoundException);
            }
        }
        return preferences;
    }

    private TypedValue guessTypedValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("true")) {
            return new TypedValue(Boolean.TRUE.toString(), Boolean.class.getName());
        }
        if (string.equalsIgnoreCase("false")) {
            return new TypedValue(Boolean.FALSE.toString(), Boolean.class.getName());
        }
        try {
            Integer n = Integer.parseInt(string);
            return new TypedValue(string, Integer.class.getName());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long l = Long.parseLong(string);
                return new TypedValue(string, Long.class.getName());
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Float f = Float.valueOf(Float.parseFloat(string));
                    return new TypedValue(string, Float.class.getName());
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        Double d = Double.parseDouble(string);
                        return new TypedValue(string, Double.class.getName());
                    }
                    catch (NumberFormatException numberFormatException4) {
                        return new TypedValue(string, String.class.getName());
                    }
                }
            }
        }
    }

    static {
        affectedMimeTypes.put("text/x-java", "org.netbeans.api.java.source.CodeStyle");
        affectedMimeTypes.put("text/x-ruby", "org.netbeans.modules.ruby.options.CodeStyle");
    }
}

