/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.dnd;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.dnd.DragElement;
import rex.graphics.mdxeditor.mdxbuilder.dnd.TransferableMdxBuilderTreeNode;
import rex.metadata.QueryElement;
import rex.utils.S;

public class DimensionTreeToMBTDragSource
extends JComponent
implements DragSourceListener,
DragGestureListener,
DragSourceMotionListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    TransferableMdxBuilderTreeNode transferable;
    TreeElement oldNode;
    JTree sourceTree;
    String uniqueName;
    private int ITEM_WIDTH = 9;
    private int ITEM_HEIGHT = 25;
    Point p;

    public DimensionTreeToMBTDragSource(JTree tree, int actions2) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions2, this);
        this.source.addDragSourceMotionListener(this);
    }

    public int getItemWidth() {
        return this.ITEM_WIDTH * this.uniqueName.length();
    }

    public int getItemHeight() {
        return this.ITEM_HEIGHT;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path != null && path.getPathCount() > 1 && (((TreeElement)path.getLastPathComponent()).getUserObject() instanceof DimensionElement || ((TreeElement)path.getLastPathComponent()).getUserObject() instanceof QueryElement)) {
            this.oldNode = (TreeElement)path.getLastPathComponent();
            DimensionTreeElement userObject = (DimensionTreeElement)this.oldNode.getUserObject();
            this.uniqueName = userObject.getUniqueName();
            this.transferable = new TransferableMdxBuilderTreeNode(userObject);
            this.source.startDrag(dge, DragSource.DefaultCopyDrop, userObject.getIcon() == null ? null : userObject.getIcon().getImage(), new Point(10, 10), this.transferable, this);
            DragElement glassPane = (DragElement)SwingUtilities.getRootPane(this.sourceTree).getGlassPane();
            glassPane.setVisible(true);
            Point point = (Point)dge.getDragOrigin().clone();
            SwingUtilities.convertPointToScreen(point, this);
            SwingUtilities.convertPointFromScreen(point, glassPane);
            glassPane.setPoint(point);
            glassPane.setImage(this.uniqueName, this.getItemHeight(), this.getItemWidth());
            glassPane.showString(true);
            glassPane.repaint();
        }
    }

    public void dragMouseMoved(DragSourceDragEvent dsde) {
        try {
            DragElement glassPane = (DragElement)SwingUtilities.getRootPane(this.sourceTree).getGlassPane();
            this.p = (Point)dsde.getLocation().clone();
            SwingUtilities.convertPointFromScreen(this.p, glassPane);
            glassPane.setPoint(this.p);
            glassPane.showString(true);
            glassPane.repaint();
        }
        catch (ClassCastException cce) {
            S.out(cce.getMessage());
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        DragElement glassPane = (DragElement)SwingUtilities.getRootPane(this.sourceTree).getGlassPane();
        glassPane.setVisible(true);
        Point point = (Point)dsde.getLocation().clone();
        SwingUtilities.convertPointToScreen(point, this);
        SwingUtilities.convertPointFromScreen(point, glassPane);
        glassPane.setPoint(point);
        glassPane.showString(false);
        glassPane.repaint();
    }
}

