/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.undo.AddTableCellUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddTableCellAction
extends NodeAction {
    private static AddTableCellAction instance = null;

    public static synchronized AddTableCellAction getInstance() {
        if (instance == null) {
            instance = new AddTableCellAction();
        }
        return instance;
    }

    private AddTableCellAction() {
    }

    public String getName() {
        return NbBundle.getMessage(AddTableCellAction.class, (String)"AddTableCellAction.Name.CTL_AddTableCellAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof TableNullCellNode)) continue;
            TableNullCellNode cellNode = (TableNullCellNode)activatedNodes[i];
            JasperDesign jd = (JasperDesign)cellNode.getLookup().lookup(JasperDesign.class);
            DesignCell cell = new DesignCell();
            TableMatrix tm = new TableMatrix(jd, cellNode.getTable());
            TableCell tc = tm.findTableCell(cellNode.getColumn(), cellNode.getSection(), cellNode.getGroup() != null ? cellNode.getGroup().getName() : null);
            int h = tm.getCellBounds((TableCell)tc).height;
            if (h == 0) {
                h = 30;
            }
            cell.setHeight(Integer.valueOf(h));
            TableModelUtils.addCell(cellNode.getColumn(), cell, cellNode.getSection(), cellNode.getGroup() != null ? cellNode.getGroup().getName() : null);
            System.out.println(" Added cell for group: " + cellNode.getSection() + "  " + (cellNode.getGroup() != null ? cellNode.getGroup().getName() : null));
            System.out.flush();
            AddTableCellUndoableEdit edit = new AddTableCellUndoableEdit(cellNode.getTable(), jd, cell, cellNode.getColumn(), cellNode.getSection(), cellNode.getGroup());
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
            TableModelUtils.fixTableLayout(cellNode.getTable(), jd);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof TableNullCellNode) continue;
            return false;
        }
        return true;
    }
}

