/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.undo.DeleteBandUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class DeleteBandAction
extends NodeAction {
    private static DeleteBandAction instance = null;

    public static synchronized DeleteBandAction getInstance() {
        if (instance == null) {
            instance = new DeleteBandAction();
        }
        return instance;
    }

    private DeleteBandAction() {
    }

    public String getName() {
        return I18n.getString("DeleteBandAction.Name.CTL_DeleteBandAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            JRDesignSection section;
            JRDesignGroup group;
            if (!(activatedNodes[i] instanceof BandNode)) continue;
            BandNode nbn = (BandNode)activatedNodes[i];
            JasperDesign jd = nbn.getJasperDesign();
            JRDesignBand band = nbn.getBand();
            if (jd == null || band == null) continue;
            if (band.getOrigin().getBandType() == 1) {
                jd.setBackground(null);
            } else if (band.getOrigin().getBandType() == 2) {
                jd.setTitle(null);
            } else if (band.getOrigin().getBandType() == 3) {
                jd.setPageHeader(null);
            } else if (band.getOrigin().getBandType() == 4) {
                jd.setColumnHeader(null);
            } else if (band.getOrigin().getBandType() == 6) {
                JRDesignSection section2 = (JRDesignSection)jd.getDetailSection();
                section2.removeBand((JRBand)band);
            } else if (band.getOrigin().getBandType() == 8) {
                jd.setColumnFooter(null);
            } else if (band.getOrigin().getBandType() == 9) {
                jd.setPageFooter(null);
            } else if (band.getOrigin().getBandType() == 10) {
                jd.setLastPageFooter(null);
            } else if (band.getOrigin().getBandType() == 11) {
                jd.setSummary(null);
            } else if (band.getOrigin().getBandType() == 12) {
                jd.setNoData(null);
            } else if (band.getOrigin().getBandType() == 5) {
                group = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                section = (JRDesignSection)group.getGroupHeaderSection();
                section.removeBand((JRBand)band);
            } else if (band.getOrigin().getBandType() == 7) {
                group = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                section = (JRDesignSection)group.getGroupFooterSection();
                section.removeBand((JRBand)band);
            }
            DeleteBandUndoableEdit edit = new DeleteBandUndoableEdit(band, jd);
            IReportManager.getInstance().addUndoableEdit(edit);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof BandNode) continue;
            return false;
        }
        return true;
    }
}

