/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compiler.prompt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.swingx.JXDatePicker;

public class JDateTimePicker
extends JPanel {
    private Locale locale = null;
    private JXDatePicker datePicker = null;
    private JLabel jLabelH;
    private JLabel jLabelMin;
    private JLabel jLabelSec;
    private JPanel jPanel1;
    private JSpinner jSpinnerH;
    private JSpinner jSpinnerM;
    private JSpinner jSpinnerS;

    public JDateTimePicker() {
        this.initComponents();
        this.jSpinnerH.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        this.jSpinnerM.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.jSpinnerS.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.datePicker = new JXDatePicker();
        this.datePicker.setEditable(true);
        this.jPanel1.add((Component)this.datePicker, "Center");
        this.setDate(new Date());
        this.applyI18n();
    }

    public void setDateFormat(DateFormat format) {
        DateFormat[] formats = this.datePicker.getFormats();
        System.out.println("Setting format...");
        for (DateFormat f : formats) {
            System.out.println(f + "");
        }
        System.out.flush();
        ArrayList<DateFormat> listFormats = new ArrayList<DateFormat>(Arrays.asList(formats));
        listFormats.add(0, format);
        this.datePicker.setFormats(listFormats.toArray(new DateFormat[listFormats.size()]));
    }

    public void setDate(Date d) {
        if (d == null) {
            return;
        }
        GregorianCalendar gc = null;
        gc = this.getLocale() != null ? new GregorianCalendar(this.getLocale()) : new GregorianCalendar();
        gc.setTime(d);
        this.jSpinnerH.setValue(gc.get(11));
        this.jSpinnerM.setValue(gc.get(12));
        this.jSpinnerS.setValue(gc.get(13));
        try {
            this.datePicker.setDate(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date getDate() {
        if (this.datePicker.getDate() == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(this.datePicker.getDate());
        gc.set(11, ((SpinnerNumberModel)this.jSpinnerH.getModel()).getNumber().intValue());
        gc.set(12, ((SpinnerNumberModel)this.jSpinnerM.getModel()).getNumber().intValue());
        gc.set(13, ((SpinnerNumberModel)this.jSpinnerS.getModel()).getNumber().intValue());
        return gc.getTime();
    }

    public void applyI18n() {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelH = new JLabel();
        this.jSpinnerH = new JSpinner();
        this.jLabelMin = new JLabel();
        this.jSpinnerM = new JSpinner();
        this.jLabelSec = new JLabel();
        this.jSpinnerS = new JSpinner();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel1.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelH.setText("\u6642\u9593");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.jLabelH, gridBagConstraints);
        this.jSpinnerH.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerH.setPreferredSize(new Dimension(35, 18));
        this.add((Component)this.jSpinnerH, new GridBagConstraints());
        this.jLabelMin.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jLabelMin, gridBagConstraints);
        this.jSpinnerM.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerM.setPreferredSize(new Dimension(35, 18));
        this.add((Component)this.jSpinnerM, new GridBagConstraints());
        this.jLabelSec.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jLabelSec, gridBagConstraints);
        this.jSpinnerS.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerS.setPreferredSize(new Dimension(35, 18));
        this.add((Component)this.jSpinnerS, new GridBagConstraints());
    }
}

