/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.jdesktop.layout.GroupLayout;

public class FilterExpressionDialog
extends JDialog {
    private String filterExpression = "";
    private ExpressionEditor editorPane = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_EXPRESSION = 1;

    public FilterExpressionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public FilterExpressionDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.editorPane = new ExpressionEditor();
        this.jPanel2.add((Component)this.editorPane, "Center");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FilterExpressionDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Add/modify field");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FilterExpressionDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("\u30d5\u30a3\u30eb\u30bf");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterExpressionDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterExpressionDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, 412, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -1, 400, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -1, 400, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanel2, -1, 277, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, 33, -2)));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.filterExpression = this.editorPane.getExpression();
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.setFilterExpression(filterExpression, null);
    }

    public void setFilterExpression(String filterExpression, JRDesignDataset subDataset) {
        this.filterExpression = filterExpression;
        this.editorPane.setExpression(filterExpression);
        if (subDataset != null) {
            this.editorPane.setExpressionContext(new ExpressionContext(subDataset));
        }
    }

    public void setFocusedExpression(int expID) {
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.editorPane);
            }
        }
    }
}

