/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignSortField;

public class SortFieldDialog
extends JDialog {
    private JRDesignSortField tmpSortField = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxSortBy;
    private JComboBox jComboBoxSortType;
    private JLabel jLabelSortBy;
    private JLabel jLabelSortType;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private int dialogResult;

    public SortFieldDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jComboBoxSortBy.setEditable(false);
        this.jComboBoxSortType.addItem(new Tag(0, "Ascending"));
        this.jComboBoxSortType.addItem(new Tag(1, "Descending"));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SortFieldDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.pack();
    }

    private void setFieldNames(List fields) {
        this.jComboBoxSortBy.removeAllItems();
        ArrayList<String> newList = new ArrayList<String>();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                JRDesignField f = (JRDesignField)fields.get(i);
                newList.add(f.getName());
            }
        }
        Object[] names = newList.toArray();
        Arrays.sort(names);
        this.jComboBoxSortBy.setModel(new DefaultComboBoxModel<Object>(names));
    }

    private void initComponents() {
        this.jLabelSortBy = new JLabel();
        this.jComboBoxSortBy = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelSortType = new JLabel();
        this.jComboBoxSortType = new JComboBox();
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SortFieldDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelSortBy.setText("\u30bd\u30fc\u30c8\u30ad\u30fc");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelSortBy, gridBagConstraints);
        this.jComboBoxSortBy.setEditable(true);
        this.jComboBoxSortBy.setPreferredSize(new Dimension(250, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jComboBoxSortBy, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelSortType.setText("\u30bd\u30fc\u30c8\u30bf\u30a4\u30d7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelSortType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 8, 4);
        this.getContentPane().add((Component)this.jComboBoxSortType, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String fieldName = (String)this.jComboBoxSortBy.getSelectedItem();
        if (fieldName == null) {
            fieldName = "";
        }
        if ((fieldName = fieldName.trim()).length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("SortFieldDialog.Message.Error"), I18n.getString("SortFieldDialog.Message.Error2"), 2);
            return;
        }
        this.tmpSortField = new JRDesignSortField();
        this.tmpSortField.setName(fieldName);
        this.tmpSortField.setOrder(this.jComboBoxSortType.getSelectedIndex() == 1 ? (byte)1 : 0);
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.setFieldNames(dataset.getFieldsList());
    }

    public JRDesignSortField getSortField() {
        return this.tmpSortField;
    }

    public void setSortField(JRDesignSortField sortField) {
        this.tmpSortField = new JRDesignSortField();
        this.tmpSortField.setName(sortField.getName());
        this.tmpSortField.setOrder(sortField.getOrder());
        this.jComboBoxSortBy.setSelectedItem(this.tmpSortField.getName());
        this.jComboBoxSortType.setSelectedIndex(this.tmpSortField.getOrder() == 1 ? 1 : 0);
    }
}

