/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.logpane;

import com.jaspersoft.ireport.designer.logpane.IRConsoleTopComponent;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class LogTextArea
extends JPanel {
    private StringBuffer outputBuffer;
    private String title = null;
    private IRConsoleTopComponent logPane = null;
    private boolean removable = false;
    private int maxlines = 5000;
    private JEditorPane jEditorPaneOutput;
    private JMenuItem jMenuItemClearLog;
    private JMenuItem jMenuItemCloseLog;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemSelectAll;
    private JPopupMenu jPopupMenuLog;
    private JScrollPane jScrollPaneOutput;
    private JSeparator jSeparator1;
    private EventListenerList listenerList = null;

    public LogTextArea(String title) {
        this.initComponents();
        this.outputBuffer = new StringBuffer();
        this.setTitle(title);
        this.jEditorPaneOutput.setContentType("text/html");
        try {
            this.maxlines = Integer.parseInt(System.getProperty("ireport.maxoutputlines", "5000"));
        }
        catch (Exception ex) {
            this.maxlines = 5000;
        }
        this.clearConsole();
        this.jEditorPaneOutput.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                String fileName;
                File f;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL().getFile().endsWith(".jrxml") && (f = new File(fileName = e.getURL().getFile())).exists()) {
                    Misc.openFile(f);
                }
            }
        });
    }

    private void initComponents() {
        this.jPopupMenuLog = new JPopupMenu();
        this.jMenuItemClearLog = new JMenuItem();
        this.jMenuItemCloseLog = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemSelectAll = new JMenuItem();
        this.jScrollPaneOutput = new JScrollPane();
        this.jEditorPaneOutput = new JEditorPane();
        this.jMenuItemClearLog.setText(I18n.getString("LogTextArea.Menu.ClearLog"));
        this.jMenuItemClearLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemClearLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemClearLog);
        this.jMenuItemCloseLog.setText(I18n.getString("LogTextArea.Menu.CloseLog"));
        this.jMenuItemCloseLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemCloseLogActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCloseLog);
        this.jPopupMenuLog.add(this.jSeparator1);
        this.jMenuItemCopy.setText(I18n.getString("LogTextArea.Menu.Copy"));
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemCopy);
        this.jMenuItemSelectAll.setText(I18n.getString("Global.Button.SelectAll"));
        this.jMenuItemSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogTextArea.this.jMenuItemSelectAllActionPerformed(evt);
            }
        });
        this.jPopupMenuLog.add(this.jMenuItemSelectAll);
        this.setLayout(new BorderLayout());
        this.jScrollPaneOutput.setHorizontalScrollBarPolicy(32);
        this.jScrollPaneOutput.setVerticalScrollBarPolicy(22);
        this.jScrollPaneOutput.setMinimumSize(new Dimension(22, 75));
        this.jScrollPaneOutput.setPreferredSize(new Dimension(3, 100));
        this.jEditorPaneOutput.setBackground(new Color(204, 204, 204));
        this.jEditorPaneOutput.setEditable(false);
        this.jEditorPaneOutput.setFont(new Font("\uff2d\uff33 \u660e\u671d", 0, 12));
        this.jEditorPaneOutput.setOpaque(false);
        this.jEditorPaneOutput.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LogTextArea.this.jEditorPaneOutputMouseClicked(evt);
            }
        });
        this.jScrollPaneOutput.setViewportView(this.jEditorPaneOutput);
        this.add((Component)this.jScrollPaneOutput, "Center");
    }

    private void jMenuItemSelectAllActionPerformed(ActionEvent evt) {
        this.jEditorPaneOutput.selectAll();
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        this.jEditorPaneOutput.copy();
    }

    private void jMenuItemCloseLogActionPerformed(ActionEvent evt) {
        this.getLogPane().removeLog(this);
    }

    private void jMenuItemClearLogActionPerformed(ActionEvent evt) {
        this.clearConsole();
    }

    private void jEditorPaneOutputMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenuLog.show(this, evt.getPoint().x, evt.getPoint().y);
        }
    }

    public void logOnConsole(String noHTML) {
        noHTML = LogTextArea.tail(noHTML, this.maxlines);
        this.logOnConsole(noHTML, false);
    }

    public void logOnConsole(String text, int messageType) {
        if (text == null) {
            return;
        }
        if (!text.startsWith("<html>")) {
            text = text.replaceAll("\\>", "&gt;");
            text = text.replaceAll("\\<", "&lt;");
            text = text.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            text = text.replaceAll("\\n", "<br>");
            text = text.replaceAll("\\s", "&nbsp;");
            text = "<font face=\"\uff2d\uff33 \u660e\u671d\" size=\"3\" color=\"#000000\">" + text + "</font>";
        } else {
            text = text.substring(6);
        }
        URL img_url = null;
        try {
            switch (messageType) {
                case 1: {
                    img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/logpane/information.png");
                    break;
                }
                case 2: {
                    img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/logpane/warning.png");
                    break;
                }
                case 0: {
                    img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/logpane/error.png");
                    break;
                }
                case 3: {
                    img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/logpane/question.png");
                    break;
                }
                default: {
                    img_url = null;
                    break;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (img_url != null) {
            text = "<img align=\"right\" src=\"" + img_url + "\">" + text;
        }
        this.logOnConsole(text, true);
    }

    public void logOnConsole(String s, boolean isHTML) {
        try {
            if (this.jEditorPaneOutput == null) {
                this.outputBuffer.append(s);
            } else {
                this.jEditorPaneOutput.setContentType("text/html");
                if (!isHTML) {
                    s = s.replaceAll("\\>", "&gt;");
                    s = s.replaceAll("\\<", "&lt;");
                    s = s.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
                    s = s.replaceAll("\\n", "<br>");
                    s = s.replaceAll("\\s", "&nbsp;");
                }
                HTMLDocument doc = (HTMLDocument)this.jEditorPaneOutput.getDocument();
                HTMLEditorKit editorKit = (HTMLEditorKit)this.jEditorPaneOutput.getEditorKit();
                if (!s.startsWith("<")) {
                    s = "<font face=\"Courier New\" size=\"3\" >" + s + "</font>";
                }
                editorKit.insertHTML(doc, doc.getLength(), s, 0, 0, null);
                this.logPane.setActiveLog(this);
            }
        }
        catch (Exception exsx) {
            JOptionPane.showMessageDialog(this, "" + exsx.getMessage());
        }
    }

    public void clearConsole() {
        this.jEditorPaneOutput.setContentType("text/html");
        this.outputBuffer.setLength(0);
        this.jEditorPaneOutput.setText("");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, title));
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public IRConsoleTopComponent getLogPane() {
        return this.logPane;
    }

    public void setLogPane(IRConsoleTopComponent logPane) {
        this.logPane = logPane;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public static int countMatches(String str, String sub) {
        if (str == null || str.length() == 0 || sub == null || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String tail(String str, int lines) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int total = LogTextArea.countMatches(str, "\n");
        int splitTo = total - lines;
        if (splitTo <= 0) {
            return str;
        }
        int count = 0;
        int idx = 0;
        while (count < splitTo && (idx = str.indexOf("\n", idx)) != -1) {
            ++count;
            ++idx;
        }
        return str.substring(idx);
    }
}

