/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Unit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiUnitNumberEditor
extends JPanel
implements ChangeListener {
    private int value = 0;
    private Unit selectedUnit = null;
    private boolean updating = false;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private JComboBox jComboBox1;
    private JSpinner jSpinner1;

    public void addChangeListener(ChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public MultiUnitNumberEditor() {
        this.initComponents();
        this.jComboBox1.setModel(new DefaultComboBoxModel<Unit>(Unit.getStandardUnits()));
        String unit = IReportManager.getPreferences().get("Unit", "cm");
        int index = Unit.getUnitIndex(unit);
        this.jComboBox1.setSelectedIndex(index);
        this.selectedUnit = Unit.getStandardUnits()[index];
    }

    private void fireStateChangedEvent() {
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private void initComponents() {
        this.jSpinner1 = new JSpinner();
        this.jComboBox1 = new JComboBox();
        this.setPreferredSize(new Dimension(80, 20));
        this.setLayout(new BorderLayout(4, 0));
        this.add((Component)this.jSpinner1, "Center");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MultiUnitNumberEditor.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.add((Component)this.jComboBox1, "After");
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (this.isUpdating()) {
            return;
        }
        this.setSelectedUnit((Unit)this.jComboBox1.getSelectedItem());
    }

    public int getValue() {
        return this.value;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jComboBox1.setEnabled(enabled);
        this.jSpinner1.setEnabled(enabled);
    }

    public void setValue(int value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        this.updateDisplayValue();
    }

    public void setSelectedUnit(Unit unit) {
        if (unit.equals(this.selectedUnit)) {
            return;
        }
        int index = Unit.getUnitIndex(unit.getKeyName());
        if (this.jComboBox1.getSelectedIndex() != index) {
            this.jComboBox1.setSelectedIndex(index);
        }
        this.selectedUnit = unit;
        boolean oldState = this.setUpdating(true);
        this.jSpinner1.getModel().removeChangeListener(this);
        SpinnerNumberModel snm = null;
        if (unit.getKeyName().equals("pixels")) {
            snm = new SpinnerNumberModel(this.getValue(), 0, 50000, 1);
            this.jSpinner1.setModel(snm);
        } else {
            double displayVal = unit.convert(this.getValue());
            double step = 0.1;
            if (unit.getKeyName().equals("inches")) {
                step = 0.01;
            } else if (unit.getKeyName().equals("cm")) {
                step = 0.01;
            } else if (unit.getKeyName().equals("cm")) {
                step = 1.0;
            }
            snm = new SpinnerNumberModel(displayVal, 0.0, 50000.0, step);
            this.jSpinner1.setModel(snm);
        }
        snm.addChangeListener(this);
        this.setUpdating(oldState);
    }

    public void updateDisplayValue() {
        boolean oldState = this.setUpdating(true);
        this.jSpinner1.setValue(this.getSelectedUnit().convert(this.getValue()));
        this.setUpdating(oldState);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.isUpdating()) {
            return;
        }
        double d = ((Number)this.jSpinner1.getModel().getValue()).doubleValue();
        int x = (int)this.getSelectedUnit().toPixel(d);
        if (x != this.value) {
            this.value = x;
            this.fireStateChangedEvent();
        }
    }

    public Unit getSelectedUnit() {
        return this.selectedUnit;
    }

    protected boolean isUpdating() {
        return this.updating;
    }

    protected boolean setUpdating(boolean updating) {
        boolean b = this.updating;
        this.updating = updating;
        return b;
    }
}

