/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.data.olap;

import bsh.EvalError;
import bsh.Interpreter;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.connection.MondrianConnection;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportQueryDialog;
import it.businesslogic.ireport.util.Misc;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import mondrian.olap.Result;
import org.apache.commons.beanutils.PropertyUtils;

public class OLAPQueryExecuter {
    private Interpreter interpreter = null;
    private Vector reportParameters = null;
    private String queryString = "";
    private HashMap queryParameters = new HashMap();

    public OLAPQueryExecuter(String queryStr, Vector reportParameters) {
        this.setQueryString(queryStr);
        this.setReportParameters(reportParameters);
    }

    public String prepareQuery() throws Exception {
        Enumeration enumParams = this.getReportParameters().elements();
        while (enumParams.hasMoreElements()) {
            Object paramVal;
            JRParameter param = (JRParameter)enumParams.nextElement();
            String parameterName = param.getName();
            if (this.queryString.indexOf("$P!{" + parameterName + "}") > 0) {
                paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), param.getDefaultValueExpression(), this.getReportParameters());
                if (paramVal == null) {
                    paramVal = "";
                }
                this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
                continue;
            }
            if (this.getQueryString().indexOf("$P{" + parameterName + "}") <= 0) continue;
            paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), param.getDefaultValueExpression(), this.getReportParameters());
            if (paramVal == null) {
                paramVal = "";
            }
            this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
        }
        return this.queryString;
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        return interpreter;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            try {
                this.interpreter = this.prepareExpressionEvaluator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Vector getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(Vector reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HashMap getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(HashMap queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Query createOlapQuery() throws Exception {
        this.prepareQuery();
        try {
            Query query;
            IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
            if (!(conn instanceof MondrianConnection)) {
                throw new Exception("No OLAP (Mondrian) connection selected.");
            }
            Connection mconn = ((MondrianConnection)conn).getMondrianConnection();
            if (mconn == null) {
                throw new Exception("The supplied mondrian.olap.Connection object is null.");
            }
            Query query2 = query = mconn.parseQuery(this.queryString);
            Object var6_6 = null;
            return query2;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                throw throwable;
            }
        }
    }

    public Result executeOlapQuery() throws Exception {
        this.prepareQuery();
        try {
            Result result;
            IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
            if (!(conn instanceof MondrianConnection)) {
                throw new Exception("No OLAP (Mondrian) connection selected.");
            }
            Connection mconn = ((MondrianConnection)conn).getMondrianConnection();
            if (mconn == null) {
                throw new Exception("The supplied mondrian.olap.Connection object is null.");
            }
            Query query = mconn.parseQuery(this.queryString);
            Result result2 = result = mconn.execute(query);
            Object var7_7 = null;
            return result2;
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                throw throwable;
            }
        }
    }

    public Vector getFields(Object obj) {
        Vector<JRField> fields = new Vector<JRField>();
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors(obj.getClass());
        for (int nd = 0; nd < pd.length; ++nd) {
            String fieldName = pd[nd].getName();
            if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null) continue;
            String returnType = pd[nd].getPropertyType().getName();
            JRField field = new JRField(fieldName, Misc.getJRFieldType(returnType));
            field.setDescription("");
            fields.addElement(field);
        }
        return fields;
    }
}

