/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.gui.sheet.Tag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class SheetProperty
implements ActionListener {
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int INTEGER = 6;
    public static final int COMBOBOX = 2;
    public static final int COLOR = 3;
    public static final int BOOLEAN = 4;
    public static final int COMBOBOX_NK = 5;
    public static final int PASSWORD = 7;
    public static final int CATEGORY_LABEL = 99;
    public static final int TEXT = 8;
    protected String name = "";
    protected String keyName = "";
    protected String group = "";
    protected int type;
    private Vector tags = null;
    protected Object defaultValue = null;
    protected Object value = null;
    private boolean readOnly = false;
    private boolean setting = false;
    protected JComponent component = null;
    private JComponent labelComponent = null;
    private boolean showResetButton = true;
    private Color labelColor = Color.BLACK;
    private Vector currentSelection = new Vector();
    private String labelError = null;
    private static final Color errorColor = Color.RED.darker();
    private static final ImageIcon errorIcon = new ImageIcon(SheetProperty.class.getResource("/it/businesslogic/ireport/icons/problems/error.png"));
    private EventListenerList listenerList = null;

    public SheetProperty(String keyName, String name, int type) {
        this(keyName, name, type, null);
    }

    public SheetProperty(String keyName, String name, int type, Object defaultValue) {
        this.setName(name);
        this.setKeyName(keyName);
        this.setDefaultValue(defaultValue);
        this.setType(type);
        this.tags = new Vector();
    }

    public SheetProperty(String keyName, String name, String groupname, int type, Object defaultValue) {
        this.setName(name);
        this.setKeyName(keyName);
        this.setDefaultValue(defaultValue);
        this.setType(type);
        this.tags = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Vector getTags() {
        return this.tags;
    }

    public void setTags(Vector tags) {
        this.tags = tags;
    }

    public void setTags(Tag[] tags_array) {
        this.tags = new Vector();
        for (int i = 0; i < tags_array.length; ++i) {
            this.tags.add(tags_array[i]);
        }
    }

    public JComponent getEditor() {
        if (this.component != null) {
            return this.component;
        }
        if (this.getType() == 1) {
            this.component = new JNumberField();
            this.component.setBorder(null);
            ((JNumberField)this.component).addActionListener(this);
        } else if (this.getType() == 6) {
            this.component = new JNumberField();
            this.component.setBorder(null);
            try {
                ((JNumberField)this.component).setInteger(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            ((JNumberField)this.component).addActionListener(this);
        } else if (this.getType() == 2 || this.getType() == 5) {
            this.component = new JComboBox(this.getTags());
            this.component.setBorder(null);
            for (int i = 0; i < this.component.getComponentCount(); ++i) {
                try {
                    Component obj = this.component.getComponent(i);
                    if (obj == null || obj.getClass().getMethod("setBorder", Border.class) == null) continue;
                    Method mtd = obj.getClass().getMethod("setBorder", Border.class);
                    mtd.invoke((Object)obj, new Object[]{null});
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((JComboBox)this.component).addActionListener(this);
        } else if (this.getType() == 4) {
            this.component = new JCheckBox("");
            ((JCheckBox)this.component).addActionListener(this);
        } else if (this.getType() == 3) {
            this.component = new ColorSelectorPanel();
            ((ColorSelectorPanel)this.component).addActionListener(this);
        } else if (this.getType() == 99) {
            this.component = new JPanel();
            this.component.setBackground(Color.LIGHT_GRAY);
        } else if (this.getType() == 7) {
            this.component = new JPasswordField();
            this.component.setBorder(null);
            ((JTextField)this.component).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent evt) {
                    SheetProperty.this.actionPerformed(null);
                }

                public void insertUpdate(DocumentEvent evt) {
                    SheetProperty.this.actionPerformed(null);
                }

                public void removeUpdate(DocumentEvent evt) {
                    SheetProperty.this.actionPerformed(null);
                }
            });
        } else if (this.getType() == 8) {
            this.component = new JTextField();
            this.component.setBorder(null);
            ((JTextField)this.component).addActionListener(this);
            ((JTextField)this.component).addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getComponent()).selectAll();
                }

                public void focusLost(FocusEvent e) {
                    SheetProperty.this.actionPerformed(null);
                }
            });
        } else {
            this.component = new JTextField();
            this.component.setBorder(null);
            ((JTextField)this.component).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent evt) {
                    SheetProperty.this.actionPerformed(null);
                }

                public void insertUpdate(DocumentEvent evt) {
                    SheetProperty.this.actionPerformed(null);
                }

                public void removeUpdate(DocumentEvent evt) {
                    SheetProperty.this.actionPerformed(null);
                }
            });
        }
        return this.component;
    }

    public Object getEditorValue(JComponent component) {
        if (this.getType() == 1) {
            return new Double(((JNumberField)component).getValue());
        }
        if (this.getType() == 6) {
            return new Integer((int)((JNumberField)component).getValue());
        }
        if (this.getType() == 2) {
            Object obj = ((JComboBox)component).getSelectedItem();
            if (obj != null) {
                if (obj instanceof Tag) {
                    return ((Tag)obj).getValue();
                }
                return obj;
            }
            return null;
        }
        if (this.getType() == 5) {
            Object obj = ((JComboBox)component).getSelectedItem();
            if (obj != null) {
                return new Integer(((Tag)obj).getValue() + "");
            }
            return null;
        }
        if (this.getType() == 4) {
            return new Boolean(((JCheckBox)component).isSelected());
        }
        if (this.getType() == 4) {
            return new String(((JPasswordField)component).getPassword());
        }
        if (this.getType() == 3) {
            return ((ColorSelectorPanel)component).getValue();
        }
        return ((JTextField)component).getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setEditorValue(JComponent component, Object obj) {
        block29: {
            block28: {
                block27: {
                    block26: {
                        String str = "" + obj;
                        component.setForeground(Color.BLACK);
                        try {
                            block25: {
                                try {
                                    this.setSetting(true);
                                    if (this.getType() == 1) {
                                        if (obj == null) {
                                            str = "0";
                                        }
                                        ((JNumberField)component).setValue(Double.parseDouble(str));
                                        if (obj == null) {
                                            ((JNumberField)component).setForeground(Color.LIGHT_GRAY);
                                        }
                                        break block25;
                                    }
                                    if (this.getType() == 6) {
                                        if (obj == null) {
                                            str = "0";
                                        }
                                        ((JNumberField)component).setValue(Integer.parseInt(str));
                                        if (obj == null) {
                                            ((JNumberField)component).setForeground(Color.LIGHT_GRAY);
                                        }
                                        break block25;
                                    }
                                    if (this.getType() == 2) {
                                        if (obj == null) {
                                            this.setSetting(false);
                                            if (this.getTags().size() > 0 && ((Tag)this.getTags().elementAt(0)).getValue() == null) {
                                                ((JComboBox)component).setSelectedIndex(0);
                                            }
                                            Object var8_4 = null;
                                            this.setSetting(false);
                                            return;
                                        }
                                        boolean found = false;
                                        for (int i = 0; i < this.getTags().size(); ++i) {
                                            Tag t = (Tag)this.getTags().elementAt(i);
                                            if (t.getValue() == null || !t.getValue().equals(str)) continue;
                                            found = true;
                                            ((JComboBox)component).setSelectedIndex(i);
                                            break;
                                        }
                                        if (!found && ((JComboBox)component).isEditable()) {
                                            ((JComboBox)component).setSelectedItem(obj);
                                        }
                                        break block25;
                                    }
                                    if (this.getType() == 5) {
                                        if (obj == null) {
                                            this.setSetting(false);
                                            if (this.getTags().size() > 0) {
                                                ((JComboBox)component).setSelectedIndex(0);
                                            }
                                            break block26;
                                        }
                                        for (int i = 0; i < this.getTags().size(); ++i) {
                                            Tag t = (Tag)this.getTags().elementAt(i);
                                            if (!(t.getValue() + "").equals(str)) continue;
                                            ((JComboBox)component).setSelectedIndex(i);
                                            break block25;
                                        }
                                        break block25;
                                    }
                                    if (this.getType() == 4) {
                                        if (obj == null) {
                                            ((JCheckBox)component).setSelected(false);
                                            this.setSetting(false);
                                            break block27;
                                        }
                                        ((JCheckBox)component).setSelected(str.equals("true"));
                                        break block25;
                                    }
                                    if (this.getType() == 3) {
                                        ((ColorSelectorPanel)component).setValue(obj);
                                        break block25;
                                    }
                                    if (this.getType() == 7) {
                                        if (obj == null) {
                                            ((JPasswordField)component).setText("");
                                            this.setSetting(false);
                                            break block28;
                                        }
                                        ((JPasswordField)component).setText(str);
                                        break block25;
                                    }
                                    if (obj == null) {
                                        ((JTextField)component).setText("");
                                        this.setSetting(false);
                                        break block29;
                                    }
                                    ((JTextField)component).setText(str);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    Object var8_10 = null;
                                    this.setSetting(false);
                                    return;
                                }
                            }
                            Object var8_9 = null;
                            this.setSetting(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var8_11 = null;
                            this.setSetting(false);
                            throw throwable;
                        }
                    }
                    Object var8_5 = null;
                    this.setSetting(false);
                    return;
                }
                Object var8_6 = null;
                this.setSetting(false);
                return;
            }
            Object var8_7 = null;
            this.setSetting(false);
            return;
        }
        Object var8_8 = null;
        this.setSetting(false);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.setEditorValue(this.getEditor(), value == null ? this.getDefaultValue() : value);
    }

    public void updateLabel() {
        if (this.getType() != 99) {
            try {
                if (this.getLabelComponent() != null) {
                    boolean needBold = this.value != null && !this.isReadOnly() && this.isShowResetButton();
                    Font f = this.getLabelComponent().getFont();
                    if (f.isBold() && !needBold) {
                        ((JLabel)this.getLabelComponent()).setFont(f.deriveFont(0));
                    } else if (!f.isBold() && needBold) {
                        ((JLabel)this.getLabelComponent()).setFont(f.deriveFont(1));
                    }
                    ((JLabel)this.getLabelComponent()).setText(this.getName());
                    if (this.isReadOnly()) {
                        this.getLabelComponent().setEnabled(false);
                    } else {
                        this.getLabelComponent().setEnabled(true);
                    }
                    if (this.labelError != null) {
                        ((JLabel)this.getLabelComponent()).setIcon(errorIcon);
                        this.getLabelComponent().setForeground(errorColor);
                        this.getLabelComponent().setToolTipText(this.labelError);
                    } else {
                        ((JLabel)this.getLabelComponent()).setIcon(null);
                        this.getLabelComponent().setForeground(this.getLabelColor());
                        this.getLabelComponent().setToolTipText(this.getName());
                    }
                    this.getLabelComponent().updateUI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.isSetting()) {
            return;
        }
        this.getEditor().setForeground(Color.BLACK);
        Object new_value = this.getEditorValue(this.getEditor());
        if (new_value != null && new_value.equals(this.value)) {
            return;
        }
        Object oldValue = this.value;
        this.value = new_value;
        if (oldValue == null || new_value == null) {
            this.updateLabel();
        }
        this.fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(new SheetPropertyValueChangedEvent(this.getKeyName(), oldValue, new_value, this));
        if (this.getType() == 8 || this.getType() == 1) {
            FocusManager.getCurrentManager().clearGlobalFocusOwner();
        }
    }

    public synchronized void addSheetPropertyValueChangedListener(SheetPropertyValueChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(SheetPropertyValueChangedListener.class, listener);
    }

    public synchronized void removeSheetPropertyValueChangedListener(SheetPropertyValueChangedListener listener) {
        this.listenerList.remove(SheetPropertyValueChangedListener.class, listener);
    }

    public void fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(SheetPropertyValueChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SheetPropertyValueChangedListener.class) continue;
            ((SheetPropertyValueChangedListener)listeners[i + 1]).sheetPropertyValueChanged(event);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.getEditor().setEnabled(!readOnly);
    }

    public JComponent getLabelComponent() {
        return this.labelComponent;
    }

    public void setLabelComponent(JComponent labelComponent) {
        this.labelComponent = labelComponent;
    }

    public boolean isSetting() {
        return this.setting;
    }

    public void setSetting(boolean setting) {
        this.setting = setting;
    }

    public boolean isShowResetButton() {
        return this.showResetButton;
    }

    public void setShowResetButton(boolean showResetButton) {
        this.showResetButton = showResetButton;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Vector getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(Vector currentSelection) {
        this.currentSelection = currentSelection;
    }

    public String getLabelError() {
        return this.labelError;
    }

    public void setLabelError(String labelError) {
        this.labelError = labelError;
    }
}

