/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.style;

import it.businesslogic.ireport.Template;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class JRTemplateDialog
extends JDialog {
    Template tmpTemplate = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxType;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionArea;
    private JSeparator jSeparator1;
    private int dialogResult;

    public JRTemplateDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setClassTypes();
        this.jComboBoxType.setSelectedItem("java.lang.String");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRTemplateDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setClassTypes() {
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"java.lang.String", "java.io.File", "java.net.URL", "java.io.InputStream", "net.sf.jasperreports.engine.JRTemplate"}));
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Add/modify field");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRTemplateDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel2.setText("Template expression class");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxType, gridBagConstraints);
        this.jLabel4.setText("Template expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jRTextExpressionArea.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionArea.setMinimumSize(new Dimension(100, 204));
        this.jRTextExpressionArea.setPreferredSize(new Dimension(350, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jRTextExpressionArea, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 4, 0);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTemplateDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRTemplateDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jRTextExpressionArea.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRFieldDialog.notValidTemplateExpression", "Please insert a valid template expression!"), I18n.getString("messages.jRFieldDialog.notValidTemplateExpressionCaption", "Invalid expression!"), 2);
            return;
        }
        this.tmpTemplate = new Template(this.jRTextExpressionArea.getText(), "" + this.jComboBoxType.getSelectedItem());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public Template getTemplate() {
        return this.tmpTemplate;
    }

    public void setTemplate(Template tmpTemplate) {
        this.jComboBoxType.setSelectedItem(new String(tmpTemplate.getExpressionClass()));
        this.jRTextExpressionArea.setText(tmpTemplate.getExpression());
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRTemplateDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRTemplateDialog.buttonOK", "OK"));
        this.jLabel2.setText(I18n.getString("jRTemplateDialog.label2", "Template expression class type"));
        this.jLabel4.setText(I18n.getString("jRTemplateDialog.label4", "Template expression"));
        this.setTitle(I18n.getString("jRTemplateDialog.title", "Add/modify template"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRTemplateDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("jRTemplateDialog.buttonOKMnemonic", "o").charAt(0));
    }
}

